const app = getApp()
const util = require('util.js')
const taskMsgAuthObj = require('auth');

export default class TaskFrontPage {
  constructor() {
    this.metaDatas = {};
    this.renders = {};
    this.controllers = {};

    this.curPage = {};
    this.components = {};
  }

  replaceDataField(obj, str) {
    if (!obj || (!str && str != 0)) return "";

    //为了忽略大小写，需要将数据对象的属性名变成小写
    let objTmp = {};
    for (let p in obj) {
      objTmp[p.toLowerCase()] = obj[p];
    }

    var patt = new RegExp("{([\\w|\.|\\u4E00-\\u9FA5]*)}", "ig");
    var result = patt.exec(str);
    while (result != null) {
      let fieldStr = result[0];
      fieldStr = fieldStr.substring(1, fieldStr.length - 1);
      var fieldName = fieldStr;
      var format = "";
      if (fieldStr.indexOf(",") > 0) {
        format = fieldStr.substr(fieldStr.indexOf(",") + 1);
        fieldName = fieldStr.substr(0, fieldStr.indexOf(","));
      }
      fieldName = fieldName.replace(/ /g, "").toLowerCase();
      let fieldVal = objTmp[fieldName];
      if (fieldVal || fieldVal == 0) {
        if (typeof (fieldVal) == "object") {
          if (str == "{" + fieldName + "}") {
            return fieldVal;
          } else {
            str = str.replace("{" + fieldStr + "}", JSON.stringify(fieldVal));
          }
        } else if (format == "datetime") {
          str = str.replace("{" + fieldStr + "}", new Date(fieldVal).format("yyyy-MM-dd HH:mm:ss"));
        } else if (format == "date") {
          str = str.replace("{" + fieldStr + "}", new Date(fieldVal).format("yyyy-MM-dd"));
        } else if (format == "time") {
          str = str.replace("{" + fieldStr + "}", new Date(fieldVal).format("HH:mm:ss"));
        } else if ((format.indexOf("\"") >= 0 || format.indexOf("'") >= 0)
          && (format.indexOf("yy") >= 0 || format.indexOf("MM") >= 0
            || format.indexOf("dd") >= 0 || format.indexOf("HH") >= 0
            || format.indexOf("hh") >= 0 || format.indexOf("ss") >= 0)) {
          format = format.replace(/"/g, "").replace(/'/g, "");
          var dateStr = fieldVal + '';
          //if (dateStr.indexOf("T") < 0) dateStr = dateStr.replace(/-/g, '/');
          str = str.replace("{" + fieldStr + "}", new Date(dateStr).format(format));
        } else if (format == "money") {
          str = str.replace("{" + fieldStr + "}", this.formatMoney(fieldVal, 2));
        } else if (format == "filesize") {
          str = str.replace("{" + fieldStr + "}", this.formatFileSize(fieldVal));
        } else {
          str = str.replace("{" + fieldStr + "}", (fieldVal + "").replace(/\{/g, "`(`").replace(/\}/g, "`)`"));
        }
      } else {
        str = str.replace("{" + fieldStr + "}", "");
      }
      patt = new RegExp("{([\\w|\.|\\u4E00-\\u9FA5]*)}", "ig");
      result = patt.exec(str);
    }

    return str;
  }

  exeExpress(str) {
    if (util.isNull(str) || typeof (str) != "string") return str;
    var start = str.indexOf("#[");
    if (start < 0) return str.replace(/\`\(\`/g, "{").replace(/\`\)\`/g, "}");
    var end = str.indexOf("]", start);
    if (end < 0) return str;
    var express = str.substr(start + 2, end - start - 2);
    var val = "";
    try {
      val = eval(express);
    } catch (err) { }
    var newStr = "";
    if (start > 0) newStr += str.substr(0, start);
    newStr += val;
    if (end < str.length - 1) newStr += str.substr(end + 1);
    return this.exeExpress(newStr);
  }

  get(cptId) {
    return this.components[cptId];
  }

  use(cptTypes, cb) {
    let arrTypes = cptTypes;
    if (typeof (arrTypes) == "string") arrTypes = [arrTypes];
    this.importCptFiles(this, this.curPage.dataModel, arrTypes, function () {
      if (cb) cb();
    });
  }

  parseCptTypes(dataModel, cptTypes) {
    //if (!this.metaDatas[dataModel.type]) return;
    if (!cptTypes.includes(dataModel.type))
      cptTypes.push(dataModel.type);
    if (dataModel.components) {
      for (let i = 0; i < dataModel.components.length; i++) {
        this.parseCptTypes(dataModel.components[i], cptTypes);
      }
    }
  }

  importCptFiles(tfp, pageDataModel, cptTypes, cb) {
    let needImportCptTypes = [];
    for (let i = 0; i < cptTypes.length; i++) {
      this.getNeedImportCptType(tfp, cptTypes[i], needImportCptTypes);
    }

    for (let i = 0; i < needImportCptTypes.length; i++) {
      let cptTypeName = needImportCptTypes[i];
      if (!this.controllers[cptTypeName]) {
        let controllerModule = require('components/' + cptTypeName.toLowerCase() + '.mini.js');
        this.controllers[cptTypeName] = controllerModule.default;
      }
    }
  }

  getNeedImportCptType(tfp, cptTypeName, needImportCptTypes) {
    //TODO 依赖
    if (!needImportCptTypes.includes(cptTypeName)) needImportCptTypes.push(cptTypeName);
  }

  bindController(e, that) {
    if (!that) that = this;
    that.setData({
      [e.target.id]: e.detail.value
    });
  }

  setData(obj) {
    var object = {};
    for (var o in obj) {
      var cpt = this.get(o);
      if (cpt) {
        var val = obj[o];
        if (cpt.transValue) val = cpt.transValue(val);
        cpt.dataModel.value = val;
        if (cpt.returnValue) cpt.returnValue(val, object);
      }
    }

    this._page.setData(object);
  }

  showPage() {
    if (this.curPage.dataModel["onShow"]) this._page[this.curPage.dataModel["onShow"]]();
  }

  refreshPage() {
    if (this.curPage.dataModel["onRefresh"]) this._page[this.curPage.dataModel["onRefresh"]]();
  }

  parsePage(__page, pageData) {
    this._page = __page;

    var cptTypes = [];
    this.parseCptTypes(pageData, cptTypes);
    this.use(cptTypes);

    this.parseCpt(pageData);

    this.initCptRuntime(this.curPage);
  }

  parseCpt(dataModel, parent) {
    if (!dataModel) {
      console.error("请提供组件的数据模型！");
      return null;
    }
    if (!dataModel.type) {
      console.error("请提供组件类型！");
      return null;
    }
    if (!parent && dataModel.type != "Page") {
      console.error("请提供父组件！");
      return;
    }

    var cpt;
    var cptClass = this.controllers[dataModel.type];
    if (!cptClass)
      cpt = { "dataModel": dataModel, "parent": parent };
    else
      cpt = new cptClass(this, dataModel, parent);

    if (dataModel.type == "Page") {
      this.curPage = cpt;
    }

    this.components[dataModel.id] = cpt;

    this._page[dataModel.id] = cpt;

    if (dataModel.components) {
      for (let i = 0; i < dataModel.components.length; i++) {
        let cdmChild = dataModel.components[i];
        this.parseCpt(cdmChild, cpt);
      }
    }
  }

  bindCptData(cdm, data, targetData) {
    var that = this;
    var cpt = this.get(cdm.id);
    for (let attrId in cpt.dataModel) {
      if (attrId == "id" || attrId == "type" || attrId == "formula") continue;

      let attrVal = cpt.dataModel[attrId];
      if (attrVal && typeof (attrVal) == "string"
        && ((attrVal.indexOf("{") >= 0 && attrVal.indexOf("}") > 0)
          || (attrVal.indexOf("#[") >= 0 && attrVal.indexOf("]") > 0))) {
        if (data && Array.isArray(data)) {
          for (var i = 0; i < data.length; i++) {
            var item = data[i];
            let val = null;
            try {
              val = this.replaceDataField(item, attrVal);
              if (!util.isNull(val)) val = this.exeExpress(val);
            } catch (e) {
              console.log(e);
            }
            if (!util.isNull(val)) {
              if (attrId == "dataBindingFormat") {
                if (cpt.returnValue) cpt.returnValue(val, targetData[i]);
              } else {
                if (cpt.returnAttrValue) cpt.returnAttrValue(attrId, val, targetData[i]);
              }
            }
          }
        } else {
          let val = null;
          try {
            val = this.replaceDataField(data, attrVal);
            if (!util.isNull(val)) val = this.exeExpress(val);
          } catch (e) {
            console.log(e);
          }
          if (!util.isNull(val)) {
            if (attrId == "dataBindingFormat") {
              cpt.dataModel.value = val;
              if (cpt.returnValue) cpt.returnValue(val, targetData);
            } else {
              cpt[attrId] = val;
              if (cpt.returnAttrValue) cpt.returnAttrValue(attrId, val, targetData);
            }
          }
        }
      }
    }

    if (cpt.dataModel.components) {
      for (var i = 0; i < cpt.dataModel.components.length; i++) {
        this.bindCptData(cpt.dataModel.components[i], data, targetData);
      }
    }
  }

  initCptRuntime(cpt) {
    let that = this;
    if (cpt["initRuntime"]) cpt.initRuntime();

    if (cpt["initLoad"]) {
      cpt.initLoad(function (b) {
        if (b && cpt.dataModel.components) {
          for (let i = 0; i < cpt.dataModel.components.length; i++) {
            let cdmChild = cpt.dataModel.components[i];
            that.initCptRuntime(that.components[cdmChild.id]);
          }
        }
      });
    }
    else {
      if (cpt.dataModel.components) {
        for (let i = 0; i < cpt.dataModel.components.length; i++) {
          let cdmChild = cpt.dataModel.components[i];
          that.initCptRuntime(that.components[cdmChild.id]);
        }
      }
    }
  }

  submit(cptId, args) {
    let that = this;
    // this._tfp._page.setData(args);
    var cpt = this.get(cptId);
    cpt.submit();
  }

  sendRequest(args, onResponse) {
    var that = this;
    util.request({
      "args": args,
      "success": function (req, res) {
        if (typeof onResponse == 'function') {
          onResponse(req, res)
        } else {
          that._page[onResponse](req, res);
        }
      }
    })
  }

  loginArgs(loginname, password) {
    return taskMsgAuthObj.loginArgsData(loginname, password);
  }

  onLogin(req, res) {
    taskMsgAuthObj.loginAuthData({
      "sessionId": res.sessionId,
      "loginname": req.loginname,
      "pwd": req.pwd,
      "data": res.data,
      "ts": res.ts
    });
  }

  checkLogin(args, cb) {
    if (wx.getStorageSync('l') && wx.getStorageSync('othercode')) {
      cb(true);
      return;
    }
    var that = this;
    that.getOthercode(function () {
      that.login({ "otherlogin": true }, function (req, res) {
        if (res.code == 0) {
          taskMsgAuthObj.loginAuthData({
            "sessionId": res.sessionId,
            "loginname": res.loginname,
            "pwd": res.pwd,
            "data": res.data,
            "ts": res.ts
          });
          cb(true);
        }
        else {
          let url = '../login/login';
          if (args.url) url = args.url;
          wx.redirectTo({
            url: url
          });
          cb(false);
        }
      })
    });
  }

  getOthercode(cb) {
    wx.login({
      success: res => {
        util.request({
          "args": {
            "projCode": app.globalData.projInfo.projCode,
            "miniCode": app.globalData.projInfo.miniCode,
            "code": res.code,
            "service": "sys/service/weixin/code2Session",
            "notAuth": true
          },
          "success": function (req0, res0) {
            wx.setStorageSync('keycode', res.code);
            wx.setStorageSync('othercode', res0.openId);
            // wx.setStorageSync('openId', res0.openId);
            // wx.setStorageSync('unionId', res0.unionId);
            wx.setStorageSync('sessionKey', res0.sessionKey);
            cb();
          },
          "fail": function (err) {
            console.log(err);
            cb();
          }
        })
      }
    });
  }

  login(args, cb) {
    //loginname
    //password TODO
    //othercode TODO
    //keycode
    if (wx.getStorageSync('l')) {
      cb(true);
      return;
    }
    if (args.loginname) {
      var args0 = taskMsgAuthObj.loginArgsData(args.loginname, args.password);
      args.ts = args0.ts;
      args.data = args0.data;
      args.pwd = args0.pwd;
    }
    var othercode = wx.getStorageSync('othercode');
    var keycode = wx.getStorageSync('keycode');
    var args1 = taskMsgAuthObj.otherArgsData(othercode, keycode);
    args.keycode = args1.keycode;
    args.dts = args1.dts;
    args.otherdata = args1.otherdata;
    args.service = 'sys/service/login.js';
    args.clientType = "web";
    args.notAuth = true;
    util.request({
      "args": args,
      "success": function (req, res) {
        if (args.otherlogin) {
          cb(req, res);
          return;
        }

        if (res.code == 0) {
          if (args.loginname) {
            taskMsgAuthObj.loginAuthData({
              "sessionId": res.sessionId,
              "loginname": args.loginname,
              "pwd": args.pwd,
              "data": res.data,
              "ts": res.ts
            });
          }
          else {
            taskMsgAuthObj.loginAuthData({
              "sessionId": res.sessionId,
              "loginname": res.loginname,
              "pwd": res.pwd,
              "data": res.data,
              "ts": res.ts
            });
          }

          cb(req, res);
        }
        else {
          wx.showToast({
            title: '用户名密码错误',
            icon: 'error',
            duration: 2000
          });
        }
      }
    });
  }

  getValue(value, dataType) {
    let val = value;
    if (!util.isNull(val)) {
      if (dataType && dataType != "text") {
        if (isNaN(val)) {
          return "";
        }
      }
      try {
        if (dataType == "int") {
          if (!util.isInt(val)) {
            return "";
          }
          val = parseInt(val);
        } else if (dataType == "float") {
          val = parseFloat(val);
        } else if (dataType == "money") {
          val = util.formatMoney(val, 2);
        }
      } catch (err) {
        console.error(err.message);
        return "";
      }
    }
    return val;
  }

  // 上传文件
  uploadFile(e, that) {
    // 判断 上传文件
    if (e.currentTarget.dataset.type == 'file') {
      //上传文件
      wx.showLoading({
        title: '加载中...',
      });
      if (that.data[e.currentTarget.dataset.array].length == e.currentTarget.dataset.number) {
        wx.hideLoading();
        wx.showToast({
          title: '文件最多上传' + e.currentTarget.dataset.number + '个！',
          icon: 'none',
          duration: 2000//持续的时间
        });
        return
      }
      wx.chooseMessageFile({
        count: 1,
        type: 'file',
        success(res) {
          // tempFilePath可以作为 img 标签的 src 属性显示图片
          const tempFilePaths = res.tempFiles[0];
          const tempFilePath = tempFilePaths.path;
          const size = tempFilePaths.size;
          const fileName = tempFilePaths.name;
          wx.uploadFile({
            //接口地址
            url: util.getServerUrl() + '/Upload',
            header: { 'args': JSON.stringify(util.getArgs({ 'appCode': e.currentTarget.dataset.appcode })) },
            filePath: tempFilePath,
            name: 'file',
            success(res) {
              var uploadfileList = that.data[e.currentTarget.dataset.array];
              uploadfileList.push({
                src: util.getServerUrl() + '/Download?fileCode=' + JSON.parse(res.data).fileCode,
                code: JSON.parse(res.data).fileCode,
                name: fileName,
                fileSize: size
              });
              that.setData({
                [e.currentTarget.dataset.array]: uploadfileList
              });
              wx.hideLoading();
            },
            fail(err) {
              console.log(err)
              wx.hideLoading({
                success: (res) => {
                  if (err.errMsg == 'request:fail timeout') {
                    wx.showToast({
                      title: '服务器压力太大啦!请稍后再试',
                      icon: 'none',
                      duration: 2000//持续的时间
                    })
                  }
                },
              })
            }
          });
        }, fail(e) {
          console.log(e)
          wx.hideLoading();
        }
      });
    } else if (e.currentTarget.dataset.type == 'image') {
      // 上传图片
      wx.showLoading({
        title: '加载中...',
      });
      if (that.data[e.currentTarget.dataset.array].length == e.currentTarget.dataset.number) {
        wx.hideLoading();
        wx.showToast({
          title: '图片最多上传' + e.currentTarget.dataset.number + '张！',
          icon: 'none',
          duration: 2000//持续的时间
        });
        return
      }
      wx.chooseMedia({
        count: 1,
        mediaType: ['image'],
        sizeType: ['original', 'compressed'],
        sourceType: ['album', 'camera'],
        success(res) {
          const tempFilePaths = res.tempFiles[0].tempFilePath;
          wx.uploadFile({
            //接口地址
            url: util.getServerUrl() + '/Upload',
            header: { 'args': JSON.stringify(util.getArgs({ 'appCode': e.currentTarget.dataset.appcode })) },
            filePath: tempFilePaths,
            name: 'images',
            success(res) {
              var uploadImageList = that.data[e.currentTarget.dataset.array];
              uploadImageList.push({
                code: JSON.parse(res.data).fileCode,
                src: util.getServerUrl() + '/Download?fileCode=' + JSON.parse(res.data).fileCode,
                fileName: JSON.parse(res.data).fileName,
                fileSize: JSON.parse(res.data).fileSize
              });
              that.setData({
                [e.currentTarget.dataset.array]: uploadImageList
              });
              wx.hideLoading();
            },
            fail(err) {
              console.log(err)
              wx.hideLoading({
                success: (res) => {
                  if (err.errMsg == 'request:fail timeout') {
                    wx.showToast({
                      title: '服务器压力太大啦!请稍后再试',
                      icon: 'none',
                      duration: 2000//持续的时间
                    })
                  }
                },
              })
            }
          });
        },
        fail(e) {
          console.log(e)
          wx.hideLoading();
        }
      });
    } else if (e.currentTarget.dataset.type == 'video') {
      //上传视频
      wx.showLoading({
        title: '加载中...',
      });
      if (that.data[e.currentTarget.dataset.array].length == e.currentTarget.dataset.number) {
        wx.hideLoading();
        wx.showToast({
          title: '视频最多上传' + e.currentTarget.dataset.number + '个！',
          icon: 'none',
          duration: 2000//持续的时间
        });
        return
      }
      wx.chooseMedia({
        count: 1,
        mediaType: ['video'],
        sourceType: ['album', 'camera'],
        maxDuration: 30,
        camera: 'back',
        success(res) {
          const tempFilePaths = res.tempFiles[0].tempFilePath;
          wx.uploadFile({
            //接口地址
            url: util.getServerUrl() + '/Upload',
            header: { 'args': JSON.stringify(util.getArgs({ 'appCode': e.currentTarget.dataset.appcode })) },
            filePath: tempFilePaths,
            name: 'file',
            success(res) {
              var uploadVideoList = that.data[e.currentTarget.dataset.array];
              uploadVideoList.push({
                code: JSON.parse(res.data).fileCode,
                src: util.getServerUrl() + '/Download?fileCode=' + JSON.parse(res.data).fileCode,
                fileName: JSON.parse(res.data).fileName,
                fileSize: JSON.parse(res.data).fileSize
              });
              that.setData({
                [e.currentTarget.dataset.array]: uploadVideoList
              });
              wx.hideLoading();
            },
            fail(err) {
              console.log(err)
              wx.hideLoading({
                success: (res) => {
                  if (err.errMsg == 'request:fail timeout') {
                    wx.showToast({
                      title: '服务器压力太大啦!请稍后再试',
                      icon: 'none',
                      duration: 2000//持续的时间
                    })
                  }
                },
              })
            }
          });
        },
        fail(e) {
          console.log(e)
          wx.hideLoading();
        }
      });
    }
  }
  // 打开文件
  openFile(e, that) {
    if (e.currentTarget.dataset.type == "file") {
      // 查看文件
      wx.showLoading({
        title: '加载中...',
      });
      var clickIndex = e.currentTarget.dataset.index;
      var uploadfileList = that.data[e.currentTarget.dataset.array];
      wx.downloadFile({
        url: uploadfileList[clickIndex].src,
        success: function (res) {
          const filePath = res.tempFilePath
          wx.openDocument({
            filePath: filePath,
            showMenu: true,
            success: function (res) {

            },
            complete: function (e) {
              wx.hideLoading();
            }
          })
        },
        fail: function (e) {
          wx.hideLoading();
        }
      })
    }
  }
  // 查看大图
  seeBiggerImage(e, that) {
    if (e.currentTarget.dataset.type == "image" && e.currentTarget.dataset.src) {
      // 展示大图
      wx.showLoading({
        title: '加载中...',
      });
      wx.previewImage({
        current: e.currentTarget.dataset.src, // 当前显示图片的http链接
        urls: [e.currentTarget.dataset.src], // 需要预览的图片http链接列表
        showmenu: false,
        complete: function (e) {
          wx.hideLoading();
        }
      })
    }
  }
  // 展示删除图标
  switchDel(e, that) {
    if (e.currentTarget.dataset.type == 'image') {
      // 切换展示删除图片按钮
      if (that.data[e.currentTarget.dataset.array].length == 0) {
        return;
      }
      that.setData({
        [e.currentTarget.dataset.delname]: !that.data[e.currentTarget.dataset.delname]
      })
    } else if (e.currentTarget.dataset.type == 'video') {
      // 切换展示删除视频按钮
      that.setData({
        [e.currentTarget.dataset.delname]: !that.data[e.currentTarget.dataset.delname]
      })
    }
  }
  // 删除文件
  delFile(e, that) {
    if (e.currentTarget.dataset.type == 'file') {
      var clickIndex = e.currentTarget.dataset.index;
      wx.showModal({
        title: '提示',
        content: '是否删除文件？',
        success(res) {
          if (res.confirm) {
            var uploadfileList = that.data[e.currentTarget.dataset.array];
            var temparray = []; //临时数组1
            for (var i = 0; i < uploadfileList.length; i++) {
              if (i == clickIndex) {
                continue;
              };
              temparray.push(uploadfileList[i]);
            };
            that.setData({
              [e.currentTarget.dataset.array]: temparray
            })
          }
        }
      });
    } else if (e.currentTarget.dataset.type == 'image') {
      // 删除图片
      var clickIndex = e.currentTarget.dataset.index;
      wx.showModal({
        title: '提示',
        content: '是否删除图片？',
        success(res) {
          if (res.confirm) {
            var uploadImageList = that.data[e.currentTarget.dataset.array];
            var temparray = []; //临时数组1
            for (var i = 0; i < uploadImageList.length; i++) {
              if (i == clickIndex) {
                continue;
              };
              temparray.push(uploadImageList[i]);
            };
            that.setData({
              [e.currentTarget.dataset.array]: temparray
            })
          }
        }
      });
    } else if (e.currentTarget.dataset.type == 'video') {
      var clickIndex = e.currentTarget.dataset.index;
      wx.showModal({
        title: '提示',
        content: '是否删除视频？',
        success(res) {
          if (res.confirm) {
            var uploadVideoList = that.data[e.currentTarget.dataset.array];
            var temparray = []; //临时数组1
            for (var i = 0; i < uploadVideoList.length; i++) {
              if (i == clickIndex) {
                continue;
              };
              temparray.push(uploadVideoList[i]);
            };
            that.setData({
              [e.currentTarget.dataset.array]: temparray
            })
          }
        }
      });
    }

  }
  // 扫描二维码
  scanCode(e, that) {
    // 只允许从相机扫码
    if (e.currentTarget.dataset.type == 'onlyCamera') {
      wx.scanCode({
        onlyFromCamera: true,
        success(res) {
          that.setData({
            [e.currentTarget.dataset.id]: res.result
          })
          if (that.data.bindchange) {
            that[that.data.bindchange]();
          }
        }
      })
    } else {
      // 允许从相机和相册扫码
      wx.scanCode({
        success(res) {
          that.setData({
            [e.currentTarget.dataset.id]: res.result
          })
          if (that.data.bindchange) {
            that[that.data.bindchange]();
          }
        }
      })
    }
  }
  toNewPage(e, type) {
    if (!type) {
      // 未设置跳转路径
      if (!e.currentTarget.dataset.url || e.currentTarget.dataset.url == 'undefined') {
        return
      }
      if (e.currentTarget.dataset.type == 'redirectTo') {
        wx.redirectTo({
          url: e.currentTarget.dataset.url,
        })
      } else if (e.currentTarget.dataset.type == 'navigateTo') {
        wx.navigateTo({
          url: e.currentTarget.dataset.url,
        })
      } else if (e.currentTarget.dataset.type == 'switchTab') {
        wx.switchTab({
          url: e.currentTarget.dataset.url,
        })
      }
    } else {
      wx[type]({
        url: e,
      })
    }
  }
  showMsg(msg, icon) {
    if (!msg) return;
    if (!icon) {
      icon = 'none'
    } else {
      icon = icon + ""
    }
    wx.showToast({
      title: msg,
      icon: icon,
      duration: 2000
    })
  }

  gotoPage(url, type) {
    this.toNewPage(url, type)
  }

  historyBack() {
    wx.navigateBack({
      delta: 1
    });
  }

  openDialog(title, content, confirm, cancel) {
    if (!content) {
      return this.showMsg('弹出层配置错误')
    }
    var that = this;
    if (!title) {
      wx.showModal({
        content: content,
        success(res) {
          if (res.confirm) {
            if (confirm) {
              if (typeof confirm == 'function') {
                confirm()
              } else {
                that._page[confirm]();
              }
            }
          } else if (res.cancel) {
            if (cancel) {
              if (typeof cancel == 'function') {
                cancel()
              } else {
                that._page[confirm]();
              }
            }
          }
        }
      })
    } else {
      wx.showModal({
        title: title,
        content: content,
        success(res) {
          if (res.confirm) {
            if (confirm) {
              if (typeof confirm == 'function') {
                confirm()
              } else {
                that._page[confirm]();
              }
            }
          } else if (res.cancel) {
            if (cancel) {
              if (typeof cancel == 'function') {
                cancel()
              } else {
                that._page[confirm]();
              }
            }
          }
        }
      })
    }
  }

  getUrlArg(urlname) {
    var that = this;
    if (urlname) {
      return that._page.data.urlArg[urlname];
    }
  }

  formatDate(date, fmt) {
    if (!date || !fmt) return
    date = new Date(date)
    var o = {
      'M+': date.getMonth() + 1, // 月份
      'd+': date.getDate(), // 日
      'H+': date.getHours(), // 小时
      'm+': date.getMinutes(), // 分
      's+': date.getSeconds(), // 秒
      'q+': Math.floor((date.getMonth() + 3) / 3), // 季度
      S: date.getMilliseconds() // 毫秒
    }
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length))
    for (var k in o) { if (new RegExp('(' + k + ')').test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length === 1) ? (o[k]) : (('00' + o[k]).substr(('' + o[k]).length))) }
    return fmt
  }

  /**
   * 格式化金额
   * @param  {[type]} s 输入值
   * @param  {[type]} n 小数点位数
   * @param  {[type]} t 是否显示千分位
   * @return {[type]}   返回值
   */
  formatMoney(s, n, t) {
    n = n > 0 && n <= 20 ? n : 2;
    s = parseFloat((s + "").replace(/[^\d\.-]/g, "")).toFixed(n) + "";
    if (!t) return s;
    var l = s.split(".")[0].split("").reverse();
    var r = s.split(".")[1];
    var t = "";
    for (var i = 0; i < l.length; i++) {
      t += l[i] + ((i + 1) % 3 === 0 && i + 1 != l.length ? "," : "");
    }
    return t.split("").reverse().join("") + "." + r;
  }

  /**
   * 格式化文件大小
   * @param  {[type]} bytes [description]
   * @return {[type]}       [description]
   */
  formatFileSize(bytes) {
    if (bytes === 0) return '0 B';
    var k = 1000,
      // or 1024
      sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
      i = Math.floor(Math.log(bytes) / Math.log(k));
    return (bytes / Math.pow(k, i)).toPrecision(3) + ' ' + sizes[i];
  }

  showLoading(title, mask, cb) {
    var that = this;
    wx.showLoading({
      title: title ? title + '' : '',
      mask: mask ? mask : false,
      success: function () {
        if (typeof cb == 'function') {
          return cb(true)
        } else {
          return that._page[cb](true);
        }
      },
      fail: function (err) {
        console.log(err)
        if (typeof cb == 'function') {
          return cb(false)
        } else {
          return that._page[cb](false);
        }
      }
    })
  }

  hideLoading(cb) {
    var that = this;
    wx.hideLoading({
      success: function () {
        if (typeof cb == 'function') {
          return cb(true)
        } else {
          return that._page[cb](true);
        }
      },
      fail: function (err) {
        console.log(err)
        if (typeof cb == 'function') {
          return cb(false)
        } else {
          return that._page[cb](false);
        }
      }
    });
  }


  /**
   * 支付模块 生成预付单
   * @param {*} obj 支付总额
   * @param {*} cb   回调
   */
  confirmOrder(obj, cb) {
    var that = this;
    wx.showLoading({
      title: '提交订单...',
    })
    var args = {};
    args.openId = wx.getStorageSync('othercode');
    args.total_fee = obj.total_fee;//支付总额
    args.out_trade_no = obj.out_trade_no;//商户订单号
    args.projCode = app.globalData.projInfo.projCode;//项目名称
    args.miniCode = app.globalData.projInfo.miniCode;//小程序名称
    args.serverUrl = util.getServerUrl(); //获取路径
    args.noTmClient = true;
    args.service = 'sys/service/wxPay/payOrder'
    args.clientType = "web";
    args.noSession = true;
    util.request({
      "args": args,
      "success": function (req, res) {
        wx.hideLoading();
        if (res.code == 0) {
          that._page.setData({
            pay_number: res.prepay_id,
            pay_data: res.pay_data
          });
          that.confirmPay(cb);
        } else {
          // console.log(res)
          wx.showToast({
            title: "支付服务错误",
            icon: 'error',
            duration: 2000
          })
          cb(false)
        }
      },
      fail: function (err) {
        wx.hideLoading();
        wx.showToast({
          title: err,
          icon: 'error',
          duration: 2000
        })
        cb(false);
      }
    });
  }

  confirmPay(cb) {
    var that = this;
    wx.requestPayment({
      timeStamp: that._page.data.pay_data.timeStamp,
      nonceStr: that._page.data.pay_data.nonceStr,
      package: that._page.data.pay_data.package,
      signType: that._page.data.pay_data.signType,
      paySign: that._page.data.pay_data.paySign,
      success: function (res) {
        console.log(res);
        cb(res)
      },
      fail: function (res) {
        if (res.errMsg != 'requestPayment:fail cancel') {
          wx.showToast({
            title: res.errmsg,
            icon: 'error',
            duration: 2000
          })
          cb(false)
        } else {
          cb(false)
        }
      },
      complete: function (res) { }
    })
  }



}
