const serverUrl = 'http://127.0.0.1:8001';
const serviceUrl = '/TaskMsgService';
const uploadUrl = '/TaskMsgUpload';
const downloadUrl = '/TaskMsgDownload';
const args = { "clientType": "web" };
const taskMsgAuthObj = require('auth');

const formatTime = date => {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()
  const hour = date.getHours()
  const minute = date.getMinutes()
  const second = date.getSeconds()

  return `${[year, month, day].map(formatNumber).join('/')} ${[hour, minute, second].map(formatNumber).join(':')}`
}

const formatNumber = n => {
  n = n.toString()
  return n[1] ? n : `0${n}`
}

const formatMoney = function(s, n, t) {
  n = n > 0 && n <= 20 ? n : 2;
  s = parseFloat((s + "").replace(/[^\d\.-]/g, "")).toFixed(n) + "";
  if (!t) return s;
  var l = s.split(".")[0].split("").reverse();
  var r = s.split(".")[1];
  var t = "";
  for (var i = 0; i < l.length; i++) {
    t += l[i] + ((i + 1) % 3 === 0 && i + 1 != l.length ? "," : "");
  }
  return t.split("").reverse().join("") + "." + r;
}

const formatDecimal = function(val, type, len) {
  if (!val && val != 0) return val;
  let decVal = parseFloat(val);
  if (!len && len != 0) return decVal;
  let decLen = parseInt(len);
  if (decLen == 0) return parseInt(decVal);
  if (type == "trunc") {
    decVal = Math.trunc(decVal);
  } else if (type == "toFixed") {
    decVal = decVal.toFixed(decLen);
  } else if (type == "toPrecision") {
    decVal = decVal.toPrecision(decLen);
  } else if (type == "ceil") {
    decVal = Math.ceil(decVal);
  } else if (type == "floor") {
    decVal = Math.floor(decVal);
  } else if (type == "abs") {
    decVal = Math.abs(decVal);
  } else if (type == "round") {
    let numPow = Math.pow(10, decLen);
    decVal = decVal * numPow;
    decVal = Math.round(decVal);
    decVal = decVal / numPow;
    decVal = decVal.toFixed(decLen);
  }
  return decVal;
}

const contains = function (arr, obj) {
  var i = arr.length;
  while (i--) {
    if (arr[i] == obj) {
      return true;
    }
  }
  return false;
}

const isNull = function (val) {
  return val == null || val == undefined || (typeof val == "string" && val.trim() == "");
}

const isInt = function(i) {
  return i == parseInt(i);
}

const testAuth = function () {
  taskMsgAuthObj.loginAuthData({
    "sessionId": "30e67480398011ed823e73472d51f796",
    "loginname": "admin",
    "pwd": "1f3f282182a8cc34b40f2799fc386992",
    "data": "+V9nsSci/vnbagt82TcUy6PU/+iXh/T4JXyZszsZ4Z7MDDwOiya7CziRmzBpPYXgpEuG0vEMsCW7cXswx9GwdQ==",
    "ts": "1663745825738"
  });
  taskMsgAuthObj.loadAuthData();
}

const getServerUrl = function(){
  return serverUrl;
}

const getArgs = function (d_args) {
  this.args = {};
  if (d_args && Object.prototype.toString.call(d_args) === '[object Object]') {
    for (var p in d_args) {
      this.args[p] = d_args[p];
    }
  }

  //身份信息
  if (!this.args.notAuth && taskMsgAuthObj) {
    if (!taskMsgAuthObj._isinit) taskMsgAuthObj.loadAuthData();
    taskMsgAuthObj.setAuthData(this);
  }
  return this.args;
}

const request = function (params) {
  var that = this;

  wx.showLoading({
    title: '加载数据中...',
  });
  wx.request({
    url: serverUrl + serviceUrl,
    data: that.getArgs(params.args),
    method: 'POST',

    success: function (res) {
      wx.hideLoading();
      if (res.statusCode == 200) {
        if (params.success) params.success(params.args, res.data);
      }
      else {
        if (params.fail) params.fail(res.errMsg);
      }
    },
    fail: function (err) {
      wx.hideLoading();
      if (params.fail)
        params.fail(err);
      else
        wx.showToast({
          title: err.errMsg,
          icon: 'none',
          duration: 2000
        });
    }
  });
}

const test = function (a) {
  console.log(a);
}

module.exports = {
  getServerUrl,
  contains,
  isNull,
  isInt,
  formatTime,
  formatNumber,
  formatMoney,
  formatDecimal,
  testAuth,
  getArgs,
  request,
  test
}
