import { FormInput } from "./controller.mini.js";
const util = require('../util.js');
const WxParse = require('../../utils/wxParse/wxParse');

export default class Wxparse extends FormInput {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Wxparse", dataModel, parent);
  }

  initRuntime() {
    if (this.dataModel.loadDataService) {
      this.loadData();
    }else {
      this.bindData(this.dataModel.wxParseContent,1)
    }
  }

  bindData(datas,type) {
    if (datas) {
      var content;
      if(type == 1){
        content = datas;
      }else{
        content = datas[0][this.dataModel.wxParseData];
      }
      this._tfp._page.setData({
        [this.dataModel.id + '_content']:content
      });
      this._tfp._page[this.dataModel.id+'_endThis']();
    }
  }

  loadData() {
    let that = this;
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
    if (!util.contains(serviceCpt.bindCpts, this.dataModel.id)) serviceCpt.bindCpts.push(this.dataModel.id);
    serviceCpt.request({
      "success": function (req, res) {
        var datas = res[that.dataModel.dataBindingMember];
        that.bindData(datas,2);
      }
    })
  }
}