const util = require('../util.js')
import { FormInput } from "../components/controller.mini.js";

export default class videoupload extends FormInput {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "videoupload", dataModel, parent);
  }

  getData() {
    var vs = this._tfp._page.data[this.dataModel.vid + "_uploadVideoList"];
    if (vs) {
      var arrayList = [];
      for (var x = 0; x < vs.length; x++) {
        arrayList.push(vs[x].code);
      }
      return arrayList.join(',');
    }
    else return null;
  }

  setData(value) {
    var listArray = value.split(',');
    var vs = this._tfp._page.data[this.dataModel.vid + "_uploadVideoList"];
    for (var x = 0; x < listArray.length; x++) {
      if (listArray[x].indexOf('http')>=0) {
        vs.push({
          src:listArray[x],
          name:listArray[x],
          code:listArray[x]
        })
      } else {
        vs.push({
          src:util.getServerUrl() + "/Download?fileCode=" + listArray[x],
          name:listArray[x],
          code:listArray[x]
        })
      }
    }
    this._tfp._page.setData({
      [this.dataModel.vid + "_uploadVideoList"]: vs
    });
  }

  returnValue(sourceVal, targetData) {
    var listArray = sourceVal.split(',');
    targetData[this.dataModel.vid + "_uploadVideoList"] = [];
    for (var x = 0; x < listArray.length; x++) {
      if (listArray[x].indexOf('http')>=0) {
        targetData[this.dataModel.vid + "_uploadVideoList"].push({
          src:listArray[x],
          name:listArray[x],
          code:listArray[x]
        })
      } else {
        targetData[this.dataModel.vid + "_uploadVideoList"].push({
          src:util.getServerUrl() + "/Download?fileCode=" + listArray[x],
          name:listArray[x],
          code:listArray[x]
        })
      }
    }
  }

  initRuntime() {
    this.bindData()
  }

  bindData() {
    this._tfp._page.setData({
      [this.dataModel.vid + "_uploadVideoList"]: [],
      [this.dataModel.vid + "_showUploadDel"]: false,
      apiUrl: util.getServerUrl()
    });
  }
}