const util = require('../util.js')
import { FormInput } from "../components/controller.mini.js";

export default class Swiper extends FormInput {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Swiper", dataModel, parent);
  }

  initRuntime() {
    if (this.dataModel.loadDataService) {
      this.loadData();
    }
    else {
      this.bindData()
    }
  }

  bindData(datas) {
    if (datas) {
      for (var i = 0; i < datas.length; i++) {
        let row = datas[i];
        let option = {};
        try {
          option = util.getServerUrl() + '/Download?showImage=true&fileCode=' + row[this.dataModel.srcField];
        } catch (e) {
          console.log(e);
          // return;
        }
        this.addOption(option);
      }
    } else {
      if (this.dataModel.options) {
        var options = this.dataModel.options;
        
        for (var x = 0; x < this.dataModel.options.length; x++) {
          if (this.dataModel.options[x].srcJson.type == "httpurl") {
            options[x] =  this.dataModel.options[x].srcJson.url;
          } else if (this.dataModel.options[x].srcJson.type == "url") {
            options[x] = util.getServerUrl() + this.dataModel.options[x].srcJson.url + '&showImage=true';
          }
        }
        this.dataModel.options = options;
      }
    }
    let swiperHeight = '200';
    if (this.dataModel.aspectRatio) {
      let aspectRatio_array = this.dataModel.aspectRatio.split(':');
      swiperHeight = wx.getSystemInfoSync().windowWidth * aspectRatio_array[1] / aspectRatio_array[0];
    }
    swiperHeight += 'rpx';
    this._tfp._page.setData({
      [this.dataModel.id + "_array"]: this.dataModel.options,
      swiperHeight: swiperHeight
    });
  }

  addOption(option) {
    if (!this.dataModel.options) this.dataModel.options = [];
    this.dataModel.options.push(option);
  }

  loadData() {
    let that = this;
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
    if (!util.contains(serviceCpt.bindCpts, this.dataModel.id)) serviceCpt.bindCpts.push(this.dataModel.id);
    serviceCpt.request({
      "success": function (req, res) {
        var datas = res[that.dataModel.dataBindingMember];
        that.bindData(datas);
      }
    })
  }
}