const util = require('../util.js')
import { InvisibleComponent } from "../components/controller.mini.js";

export default class Service extends InvisibleComponent {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Service", dataModel, parent);

    this.cbFuncs = [];
  }

  request(params, cb) {
    var that = this;
    var args = {};
    if (!params) params = {};
    if (cb) that.cbFuncs.push(cb);
    if (params.args) args = params.args;
    args.service = this.dataModel.path;
    if (this.dataModel.args) {
      for (let p in this.dataModel.args) {
        args[p] = this.dataModel.args[p];
      }
    }
    if (this.dataModel.argSettings) {
      for (var i = 0; i < this.dataModel.argSettings.length; i++) {
        let arg = this.dataModel.argSettings[i];
        if (arg.type == "QueryString") {
          if (arg.value) {
            args[arg.name] = this._tfp._page.data.urlArg[arg.value];
          } else {
            args[arg.name] = this._tfp._page.data.urlArg[arg.name];
          }
        }
        else if (arg.type == "ComponentVal") {
          var vvv;
          if (arg.value) {
            vvv = this._tfp._page.data[arg.value];
          }
          else {
            vvv = this._tfp._page.data[arg.name];
            if(this._tfp._page.data[arg.name+'_array']){
              vvv = this._tfp._page.data[arg.name+'_array'][this._tfp._page.data[arg.name]].value;
            }
          }
          if (vvv) args[arg.name] = vvv;
        }
        else if (arg.type == "Expression") {
          if (args.value) {
            try {
              args[arg.name] = eval(arg.value);
            } catch (err) {
              console.log(err);
            }
          }
        }
        else {
          args[arg.name] = arg.value;
        }
      }
    }

    util.request({
      "args": args,
      "success": function (req, res) {
        if (res.code != 0) {
          // 未登录
          if (res.code == '501') {
            wx.redirectTo({
              url: '../login/login'
            });
            return
          }
          wx.showToast({
            icon: 'error',
            title: res.message
          });
          return
        }
        if (params.success) params.success(req, res);
        that.onResponse(req, res);
      },
      "fail": function (err) {
        if (params.fail) params.fail(err);
        that.onError(req, res);
      }
    })
  }

  onResponse(req, res) {
    if (this.cbFuncs.length > 0) {
      for (var i = 0; i < this.cbFuncs.length; i++) {
        let cb = this.cbFuncs[i];
        if (typeof cb == 'string') {
          this._tfp._page[cb](req, res);
        }
        else {
          cb(req, res);
        }
      }
      this.cbFuncs = [];
    }

    if (this.dataModel.onResponse && typeof (this.dataModel.onResponse) == "string") {
      this._tfp._page[this.dataModel.onResponse](req, res);

      // var responseFuncStr = this.dataModel.onResponse;
      // if (responseFuncStr.indexOf(".") < 0 && responseFuncStr.indexOf(" ") < 0
      //   && responseFuncStr.indexOf("=") < 0 && responseFuncStr.indexOf("(") < 0
      //   && responseFuncStr.indexOf(")") < 0) {
      //     this._tfp._page[responseFuncStr](req, res);
      // } else {
      //   eval(responseFuncStr);
      // }
    }
  }

  onError(err) {
    // if (this.dataModel.autoShowError && typeof (window) != "undefined") {
    //   this._tfp.showMsg(err);
    // }
    this.cbFuncs = [];

    if (this.dataModel.onError && typeof (this.dataModel.onError) == "string") {
      this._tfp._page[this.dataModel.onError](req, res);

      // var errorFuncStr = this.dataModel.onError;
      // if (errorFuncStr.indexOf(".") < 0 && errorFuncStr.indexOf(" ") < 0
      //   && errorFuncStr.indexOf("=") < 0 && errorFuncStr.indexOf("(") < 0
      //   && errorFuncStr.indexOf(")") < 0) {
      //   eval(errorFuncStr + "(err)");
      // } else {
      //   eval(errorFuncStr);
      // }
    }
  }
}