const util = require('../util.js')
import { FormInput } from "../components/controller.mini.js";

export default class Select extends FormInput {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Select", dataModel, parent);
  }

  getData() {
    var vindex = this._tfp._page.data[this.dataModel.vid];
    if (vindex >= 0 && this.dataModel.options && this.dataModel.options.length > vindex) return this.dataModel.options[vindex].value;
    else return null;
  }

  setData(value) {
    var vindex;
    for (var j = 0; j < this.dataModel.options.length; j++) {
      var option = this.dataModel.options[j];
      if (value == option.value) {
        vindex = j;
        break;
      }
    }

    this._tfp._page.setData({
      [this.dataModel.vid]: vindex
    })
  }

  returnValue(sourceVal, targetData) {
    var vindex;
    for (var j = 0; j < this.dataModel.options.length; j++) {
      var option = this.dataModel.options[j];
      if (sourceVal == option.value) {
        vindex = j;
        break;
      }
    }

    targetData[this.dataModel.vid] = vindex;
  }

  addOption(option) {
    if (!this.dataModel.options) this.dataModel.options = [];
    this.dataModel.options.push(option);
  }

  bindData(datas) {
    if (datas) {
      for (var i = 0; i < datas.length; i++) {
        let row = datas[i];
        let option = {};
        try {
          option.value = this._tfp.replaceDataField(row, "{" + this.dataModel.valueField + "}");
        } catch (e) {
          console.log(e);
          // return;
        }

        if (util.isNull(option.value)) continue;
        if (this.dataModel.textField) {
          try {
            option.text = this._tfp.replaceDataField(row, "{" + this.dataModel.textField + "}");
          } catch (e) {
            console.log(e);
            // return;
          }
        }
        this.addOption(option);
      }
    }
    this._tfp._page.setData({
      [this.dataModel.vid + "_array"]: this.dataModel.options
    })
    this.setValue();
  }

  loadData() {
    let that = this;
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
    if (!util.contains(serviceCpt.bindCpts, this.dataModel.id)) serviceCpt.bindCpts.push(this.dataModel.id);
    serviceCpt.request({
      "success": function (req, res) {
        var datas = res[that.dataModel.dataBindingMember];
        that.bindData(datas);
      }
    })
  }

  initRuntime() {
    if (this.dataModel.loadDataService) {
      this.loadData();
    }
    else {
      this.bindData()
    }
  }
}