import { FormInput } from "../components/controller.mini.js";

export default class Radio extends FormInput {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Radio", dataModel, parent);
  }

  getData() {
    return this._tfp._page.data[this.dataModel.vid];
  }

  setData(value) {
    var idata = {};
    idata[this.dataModel.vid] = value;
    for (var i = 0; i < this.dataModel.options.length; i++) {
      if (value == this.dataModel.options[i].value) {
        idata[this.dataModel.vid + "_" + i] = true;
      }
      else {
        idata[this.dataModel.vid + "_" + i] = false;
      }
    }
    this._tfp._page.setData(idata);
  }

  returnValue(sourceVal, targetData) {
    targetData[this.dataModel.vid] = sourceVal;
    for (var i = 0; i < this.dataModel.options.length; i++) {
      if (sourceVal == this.dataModel.options[i].value) {
        targetData[this.dataModel.vid + "_" + i] = true;
      }
      else {
        targetData[this.dataModel.vid + "_" + i] = false;
      }
    }
  }

  initRuntime() {
    this.bindData()
  }
  
  bindData() {
    var idata = {};
    idata[this.dataModel.vid] = this.dataModel.options;
    for (var i = 0; i < this.dataModel.options.length; i++) {
      if (this.dataModel.value == this.dataModel.options[i].value) {
        idata[this.dataModel.vid + "_" + i] = true;
      }
      else {
        idata[this.dataModel.vid + "_" + i] = false;
      }
    }
    this._tfp._page.setData(idata);
  }

}