const util = require('../util.js')
import { InvisibleComponent } from "../components/controller.mini.js";

export default class Pay extends InvisibleComponent {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Pay", dataModel, parent);
    this.cbFuncs = [];
  }

  confirmOrder(params, cb) {
    var that = this;
    if (!params.out_trade_no) {
      wx.showToast({
        icon: 'none',
        title: "商户订单号[out_trade_no]不能为空!"
      });
      return
    }
    if (!params.total_fee) {
      wx.showToast({
        icon: 'none',
        title: "订单金额[total_fee]不能为空!"
      });
      return
    }
    params.pathName = that.dataModel.pathName;
    that._tfp.confirmOrder(params, function (e) {
      // that.request(that.dataModel, cb);
    });
  }


  request(params, cb) {
    var that = this;
    var args = {};
    if (!params) params = {};
    if (cb) that.cbFuncs.push(cb);
    if (params.args) args = params.args;
    args.service = params.path;
    if (params.args) {
      for (let p in params.args) {
        args[p] = params.args[p];
      }
    }
    if (params.argSettings) {
      for (var i = 0; i < params.argSettings.length; i++) {
        let arg = params.argSettings[i];
        if (arg.type == "QueryString") {
          if (arg.value) {
            args[arg.name] = this._tfp._page.data.urlArg[arg.value];
          } else {
            args[arg.name] = this._tfp._page.data.urlArg[arg.name];
          }
        }
        else if (arg.type == "ComponentVal") {
          var vvv;
          if (arg.value) {
            vvv = this._tfp._page.data[arg.value];
          }
          else {
            vvv = this._tfp._page.data[arg.name];
          }
          if (vvv) args[arg.name] = vvv;
        }
        else if (arg.type == "Expression") {
          if (args.value) {
            try {
              args[arg.name] = eval(arg.value);
            } catch (err) {
              console.log(err);
            }
          }
        }
        else {
          args[arg.name] = arg.value;
        }
      }
    }
    util.request({
      "args": args,
      "success": function (req, res) {
        console.log(res)
        if (res.code != 0) {
          wx.showToast({
            icon: 'error',
            title: res.message
          });
          return
        }
        if (params.success) params.success(req, res);
        that.onResponse(req, res, cb);
      },
      "fail": function (err) {
        if (params.fail) params.fail(err);
        that.onError(req, res);
      }
    })
  }

  onResponse(req, res, cb) {
    if (this.cbFuncs.length > 0) {
      for (var i = 0; i < this.cbFuncs.length; i++) {
        let cb = this.cbFuncs[i];
        cb(req, res);
      }
      this.cbFuncs = [];
    }
    if (this.dataModel.onResponse && typeof (this.dataModel.onResponse) == "string") {
      this._tfp._page[this.dataModel.onResponse](req, res, cb);
    }
  }

  onError(err) {
    this.cbFuncs = [];
    if (this.dataModel.onError && typeof (this.dataModel.onError) == "string") {
      this._tfp._page[this.dataModel.onError](req, res);
    }
  }
}