const util = require('../util.js')
import { FormInput } from "../components/controller.mini.js";

export default class Image extends FormInput {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Image", dataModel, parent);
  }

  getData() {
    var vs = this._tfp._page.data[this.dataModel.vid];
    if (vs) {
      return this._tfp._page.data[this.dataModel.vid];
    }
    else return null;
  }

  setData(value) {
    this.dataModel.src = value;
    this.setSrc();
  }

  returnValue(sourceVal, targetData) {
    targetData[this.dataModel.vid] = sourceVal;
  }


  setSrc() {
    var src = this.dataModel.src;
    if(src.indexOf("http")>=0){
      this._tfp._page.setData({
        [this.dataModel.vid]: this.dataModel.src
      })
    }else{
      this._tfp._page.setData({
        [this.dataModel.vid]: util.getServerUrl() + this.dataModel.src
      })
    }
  }

  initRuntime() {
    if (this.dataModel.src && this.setSrc) this.setSrc();
  }
}