const util = require('../util.js')
import { VisibleComponent } from "../components/controller.mini.js";

export default class Grid extends VisibleComponent {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Grid", dataModel, parent);

    this.pageSize = 10;
    this.curPage = 0;
    this.pageCount = 0;
    this.rowsCount = 0;
  }

  getValue() {
    this.dataModel.data = this._tfp._page.data[this.dataModel.vid];
    this.rowsCount = this._tfp._page.data[this.dataModel.vid + "_rowsCount"];
  }

  setValue() {
    this._tfp._page.setData({
      [this.dataModel.vid]: this.dataModel.data,
      [this.dataModel.vid + "_rowsCount"]: this.rowsCount
    })
  }

  // getData() {
  //   return this._tfp._page.data[this.dataModel.vid];
  // }

  // setData(data, rowsCount) {
  //   this._tfp._page.setData({
  //     [this.dataModel.vid]: data,
  //     [this.dataModel.vid + "_rowsCount"]: rowsCount
  //   })
  // }

  getKey(obj) {
    var l = this._tfp._page.data[this.dataModel.vid];
    if (obj && obj.dataset && obj.dataset.index != null) {
      return l[obj.dataset.index].grid1_key;
    }
    else if (obj && obj.index != null) {
      return l[obj.index].grid1_key;
    }
    else if (obj && obj.id != null) {
      var iii = obj.id.substr(obj.id.lastIndexOf("_") + 1)
      return l[iii].grid1_key;
    }
    else if (obj != null) {
      return l[obj].grid1_key;
    }
  }

  deleteRow(keyValue) {
    // if (!this.dataModel.delDataService) {
    //   alert("请设置删除数据的服务！");
    //   return;
    // }
    // if (!this.dataModel.dataBindingKey) {
    //   alert("请设置数据主键字段名！");
    //   return;
    // }
    let that = this;
    wx.showModal({
      "content": "确定删除？",
      "showCancel": true,
      "success": function (res) {
        if (res.confirm) {
          let serviceCpt = that._tfp.get(that.dataModel.delDataService);

          let args = {};
          if (that.dataModel.dataBindingKey.indexOf(",") < 0) {
            args[that.dataModel.dataBindingKey] = keyValue;
          }
          else {
            let dataKeys = that.dataModel.dataBindingKey.split(",");
            for (var i = 0; i < dataKeys.length; i++) {
              if (keyValue.length < (i + 2)) break;
              args[dataKeys[i]] = keyValue[i + 1];
            }
          }

          serviceCpt.request({
            "args": args,
            "success": function (req, res) {
              if (res.code != 0) {
                return;
              }
              that.loadData(1);
            }
          });
        }
      }
    })
  }

  bindData(rows) {
    if (!this.dataModel.components) return;
    var list = [];
    for (var i = 0; i < rows.length; i++) {
      var data = {};
      if (this.dataModel.dataBindingKey)
        data[this.dataModel.vid + "_key"] = rows[i][this.dataModel.dataBindingKey];
      list.push(data);
    }

    for (var i = 0; i < this.dataModel.components.length; i++) {
      this._tfp.bindCptData(this.dataModel.components[i], rows, list);
    }

    if (this.dataModel.allowPaging && this.curPage > 1) {
      for (var i = 0; i < list.length; i++) {
        this.dataModel.data.push(list[i]);
      }
    }
    else {
      this.dataModel.data = list;
    }

    this.setValue();
  }

  loadData(toPage) {
    let that = this;
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);

    if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
    if (!util.contains(serviceCpt.bindCpts, this.dataModel.id)) serviceCpt.bindCpts.push(this.dataModel.id);

    var args = {};
    if (that.dataModel.allowPaging) {
      args = {
        pageSize: this.pageSize,
        toPage: toPage
      };
    }

    serviceCpt.request({
      "args": args,
      "success": function (req, res) {
        var data;
        if (that.dataModel.dataBindingMember) data = res[that.dataModel.dataBindingMember];
        if(!data) return
        if (that.dataModel.allowPaging) {
          that.curPage = data.toPage;
          that.rowsCount = data.rowsCount;
          that.pageCount = data.pageCount;
          that.pageSize = data.pageSize;
          // that.dataModel.data = data.rows;
          // that.setValue();
          that.bindData(data.rows);
        }
        else {
          that.curPage = 1;
          that.rowsCount = data.length;
          // that.pageCount = 1;
          // that.pageSize = data.length;
          // that.dataModel.data = data;
          // that.setValue();
          that.bindData(data);
        }
      }
    })
  }

  loadDataTo(relativePage) {
    if (!this.dataModel.allowPaging) return;
    if (this.curPage + relativePage > this.pageCount || this.curPage + relativePage < 0) return;
    this.loadData(this.curPage + relativePage);
  }

  initRuntime() {
    if (!this.dataModel.loadDataService) return;
    this.loadData(1);
  }
}