const util = require('../util.js')
import { ContainerComponent } from "../components/controller.mini.js";

export default class Form extends ContainerComponent {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Form", dataModel, parent);
  }

  loadData() {
    let that = this;
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
    if (!util.contains(serviceCpt.bindCpts, this.dataModel.id)) serviceCpt.bindCpts.push(this.dataModel.id);

    serviceCpt.request({
      "success": function (req, res) {
        var data;
        if (that.dataModel.dataBindingMember) data = res[that.dataModel.dataBindingMember];
        that.dataModel.data = data;
        that.bindData(data);
      }
    });
  }

  bindData(data) {
    if (!this.dataModel.components) return;
    var targetData = {};
    for (var i = 0; i < this.dataModel.components.length; i++) {
      this._tfp.bindCptData(this.dataModel.components[i], data, targetData);
    }
    if (targetData) this._tfp._page.setData(targetData);
  }

  submit() {
    let that = this;
    let args = {};
    let isOK = true;
    if (this.dataModel.components) {
      for (var i = 0; i < this.dataModel.components.length; i++) {
        isOK = this.checkInputData(this.dataModel.components[i], args);
        if(this.dataModel.components[i].type == '"Select"'){
          args[this.dataModel.components[i].vid] = this.dataModel.components[i].options[args[this.dataModel.components[i].vid]].value;
        }
        if (!isOK) return;
      }
    }
    var b = true;
    if (this.dataModel.beforeSubmit)
      b = this._tfp._page[this.dataModel.beforeSubmit](args);
    if (!b) return;
    let serviceCpt = this._tfp.get(this.dataModel.submitService);
    serviceCpt.request({
      "args": args
      // "success":function(req,res){
      // }
    });
  }

  checkInputData(cdm, args) {
    let cpt = this._tfp.get(cdm.id);
    if (cpt.isFormInput) {
      var v = cpt.getData();
      if (cpt.required && util.isNull(v)) {
        wx.showToast({
          title: '必填项',
          icon: 'error',
          duration: 2000
        });
        return false;
      }

      if (!util.isNull(v)) {
        args[cpt.dataModel.id] = v;
      }
    }
    else if (cpt.type == "DataSet") {
      // let rows = cpt.getRows({ checkRequired: true });
      // if (!rows) return false;
      // args[cpt.id] = rows;
    }

    let isOK = true;
    if (cdm.components) {
      for (var i = 0; i < cdm.components.length; i++) {
        isOK = this.checkInputData(cdm.components[i], args);
        if (!isOK) return false;
      }
    }
    return isOK;
  }

  initRuntime() {
    if (!this.dataModel.loadDataService) return true;
    this.loadData();
  }
}