const util = require('../util.js')
import { FormInput } from "../components/controller.mini.js";

export default class CheckBox extends FormInput {
  constructor(__tfp, dataModel, parent) {
    super(__tfp, "CheckBox", dataModel, parent);
  }

  getData() {
    var vs = this._tfp._page.data[this.dataModel.vid];
    if (vs) return vs.join(',');
    else return null;
  }

  setData(value) {
    var ivalue = value.split(',');
    var idata = {};
    idata[this.dataModel.vid] = ivalue;
    for (var i = 0; i < this.dataModel.options.length; i++) {
      if (util.contains(ivalue, this.dataModel.options[i].value)) {
        idata[this.dataModel.vid + "_" + i] = true;
      }
      else {
        idata[this.dataModel.vid + "_" + i] = false;
      }
    }
    this._tfp._page.setData(idata);
  }

  transValue(value) {
    if (Array.isArray(value))
      return value.join(',')
    else
      return value;
  }

  returnValue(sourceVal, targetData) {
    var ivalue = sourceVal.split(',');
    targetData[this.dataModel.vid] = ivalue;
    for (var i = 0; i < this.dataModel.options.length; i++) {
      if (util.contains(ivalue, this.dataModel.options[i].value)) {
        targetData[this.dataModel.vid + "_" + i] = true;
      }
      else {
        targetData[this.dataModel.vid + "_" + i] = false;
      }
    }
  }

  initRuntime() {
    this.bindData()
  }
  
  bindData() {
    var ivalue = this.dataModel.value.split(',');
    var idata = {};
    idata[this.dataModel.vid] = ivalue;
    for (var i = 0; i < this.dataModel.options.length; i++) {
      if (util.contains(ivalue, this.dataModel.options[i].value)) {
        idata[this.dataModel.vid + "_" + i] = true;
      }
      else {
        idata[this.dataModel.vid + "_" + i] = false;
      }
    }
    this._tfp._page.setData(idata);
  }
}