

/**
 * 引用ES6模块文件
 * @param  {[type]}   files [description]
 * @param  {Function} cb    [description]
 * @return {[type]}         [description]
 */
async function importModules(files, cb) {
  let arrIn = files;
  let arrOut = [];
  if (typeof (arrIn) == "string") arrIn = [arrIn];
  for (let i = 0; i < arrIn.length; i++) {
    arrOut.push(await import(arrIn[i]));
  }
  if (cb) cb(arrOut);
}

export default class TaskFrontPage {

  constructor() {
    this.metaDatas = {};    //当前页面注册的组件定义信息
    this.controllers = {};      //当前页面注册的组件类
    this.renders = {};      //当前页面注册的组件渲染器类
    this.curPage = null;    //当前页面对象
    this.components = {};   //当前页面的组件集合
    this.cbOpenDialog = null;
    this.rootPath = "/node_modules/tfp";

    this.metaDatas_combo = {};
  }

  /**
   * 扩展系统对象
   * @return {[type]} [description]
   */
  extendSysObj() {

    if (typeof (String.prototype.startsWith) == "undefined") {
      /**
       * 判断字符串是否以指定的子字符串开头
       * @param  {[type]} prefix [description]
       * @return {[type]}        [description]
       */
      String.prototype.startWith = String.prototype.startsWith = function (prefix) {
        return this.indexOf(prefix) === 0;
      }
    }

    if (typeof (String.prototype.endsWith) == "undefined") {
      /**
       * 判断字符串是否以指定的子字符串结尾
       * @param  {[type]} suffix [description]
       * @return {[type]}        [description]
       */
      String.prototype.endWith = String.prototype.endsWith = function (suffix) {
        return this.match(suffix + "$") == suffix;
      }
    }

    if (typeof (String.prototype.replaceAll) == "undefined") {
      /**
       * 全部替换
       * @param  {[type]} s1 [description]
       * @param  {[type]} s2 [description]
       * @return {[type]}    [description]
       */
      String.prototype.replaceAll = function (s1, s2) {
        // return this.replace(new RegExp(s1, "gm"), s2);
        var s1 = s1.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
        return this.replace(new RegExp(s1, 'g'), s2);
      }
    }

    if (typeof (String.prototype.trim) == "undefined") {
      /**
       * 删除字符串两端的空格
       * @return {[type]} [description]
       */
      String.prototype.trim = function () {
        return this.replace(/(^\s*)|(\s*$)/g, "");
      }
    }

    if (typeof (String.prototype.toDate) == "undefined") {
      /**
       * 将字符串转换为日期
       * @return {[type]} [description]
       */
      String.prototype.toDate = function () {
        return new Date(this.replace(/-/g, '/'));
      }
    }

    /**
     * 计算字符串长度，英文字母算一个，汉字算两个
     * @return {[type]} [description]
     */
    String.prototype.gblen = function () {
      var len = 0;
      for (var i = 0; i < this.length; i++) {
        if (this.charCodeAt(i) > 127 || this.charCodeAt(i) == 94) {
          len += 2;
        } else {
          len++;
        }
      }
      return len;
    }

    // if (typeof (Date.prototype.format) == "undefined") {
    /**
    * 将日期格式化为字符串
    * @param  {[type]} style [description]
    * @return {[type]}       [description]
    */
    Date.prototype.format = function (style) {
      var y = this.getFullYear();
      var M = "0" + (this.getMonth() + 1);
      M = M.substring(M.length - 2);
      var d = "0" + this.getDate();
      d = d.substring(d.length - 2);
      var H = "0" + this.getHours();
      H = H.substring(H.length - 2);
      var h = this.getHours();
      if (h >= 12) h = h - 12;
      h = "0" + h;
      h = h.substring(h.length - 2);
      var m = "0" + this.getMinutes();
      m = m.substring(m.length - 2);
      var s = "0" + this.getSeconds();
      s = s.substring(s.length - 2);
      var ms = "00" + this.getMilliseconds();
      ms = ms.substring(ms.length - 3);
      var ret = (style + "").replaceAll('yyyy', y);
      ret = ret.replaceAll('yy', (y + '').substring(2));
      ret = ret.replaceAll('MM', M);
      ret = ret.replaceAll('dd', d);
      ret = ret.replaceAll('HH', H);
      ret = ret.replaceAll('hh', h);
      ret = ret.replaceAll('mm', m);
      ret = ret.replaceAll('ss', s);
      ret = ret.replaceAll('SSS', ms);
      return ret;
    }
    // }


    if (typeof (Date.prototype.toJSON) == "undefined") {
      /**
      * 日期对象转换为JSON值
      * @return {[type]} [description]
      */
      Date.prototype.toJSON = function () {
        return this.format('yyyy-MM-dd HH:mm:ss');
      }
    }

    if (typeof (Array.prototype.remove) == "undefined") {
      /**
      * 删除数组中指定的元素
      * @param  {[type]} obj [description]
      * @return {[type]}     [description]
      */
      Array.prototype.remove = function (obj) {
        for (var i = 0; i < this.length; i++) {
          if (this[i] === obj) {
            this.splice(i, 1);
            return;
          }
        }
      }
    }

    if (typeof (Array.prototype.contains) == "undefined") {
      /**
       * 判断数组中是否存在指定的元素
       * @param  {[type]} obj [description]
       * @return {[type]}     [description]
       */
      Array.prototype.contains = function (obj) {
        var i = this.length;
        while (i--) {
          if (this[i] === obj) {
            return true;
          }
        }
        return false;
      }
    }

    if (typeof (Array.prototype.orderBy) == "undefined") {
      /**
       * 对数组元素进行排序
       * @param  {[type]} order [description]
       * @param  {[type]} prop [description]
       * @return {[type]}     [description]
       */
      Array.prototype.orderBy = function (order, prop) {
        let ret = null;
        if (this.length == 0) return;
        if (prop) {
          if (order == "desc") {
            this.sort(function (a, b) { return b[prop] - a[prop] });
          } else {
            this.sort(function (a, b) { return a[prop] - b[prop] });
          }
          return;
        }
        //如果不是数字
        if (isNaN(this[0])) {
          this.sort();
          if (order == "desc") {
            this.reverse();
          }
        } else {
          if (order == "desc") {
            this.sort(function (a, b) { return b - a });
          } else {
            this.sort(function (a, b) { return a - b });
          }
        }
      }
    }

    if (typeof (window.isNull) == "undefined") {
      /**
       * 是否为空值
       * @param  {[type]}  val [description]
       * @return {Boolean}     [description]
       */
      window.isNull = function (val) {
        return val == null || val == undefined || (typeof val == "string" && val.trim() == "");
      }
    }

    if (typeof (window.isInt) == "undefined") {
      /**
       * 判断是否是整数
       * @param  {[type]}  i [description]
       * @return {Boolean}   [description]
       */
      window.isInt = function (i) {
        return i == parseInt(i);
      }
    }

    if (typeof (window.isObj) == "undefined") {
      /**
       * 是否是对象
       * @param  {[type]}  obj [description]
       * @return {Boolean}     [description]
       */
      window.isObj = function (obj) {
        return typeof (obj) == "object" && Object.prototype.toString.call(obj).toLowerCase() == "[object object]" && !obj.length;
      }
    }
  }

  /**
   * 是否是设计时
   * @return {Boolean} [description]
   */
  get isDesigning() {
    //为了防止嵌入到第三方系统时发生跨域错误，需要将对window.parent的访问放在try catch里
    let isDesigning = false;
    try {
      isDesigning = (window.parent && typeof window.parent.uiDesigner != "undefined")
        || (window.parent && typeof window.parent.formDesigner != "undefined")
        || (window.parent && typeof window.parent.queryDesigner != "undefined");
    } catch (err) { }
    return typeof window != "undefined" && isDesigning;
  }

  get designerType() {
    let designerType = "";
    try {
      if (window.parent && typeof window.parent.uiDesigner != "undefined") designerType = "uiDesigner";
      else if (window.parent && typeof window.parent.formDesigner != "undefined") designerType = "formDesigner";
      else if (window.parent && typeof window.parent.queryDesigner != "undefined") designerType = "queryDesigner";
    } catch (err) { }
    return designerType;
  }

  /**
   * 是否是在前端浏览器内运行时
   * @return {Boolean} [description]
   */
  get isRuntime() {
    return typeof window != "undefined" && !this.isDesigning;
  }

  /**
   * 是否为空，包括null、undefined、空字符串
   * @param  {[type]}  val [description]
   * @return {Boolean}     [description]
   */
  isNull(val) {
    return val == null || val == undefined || (typeof val == "string" && val.trim() == "");
  }

  /**
   * 是否是对象，不包括null、数组
   * @param {*} obj 
   * @returns 
   */
  isObj(obj) {
    return typeof (obj) == "object" && Object.prototype.toString.call(obj).toLowerCase() == "[object object]" && !obj.length;
  }

  /**
   * 是否是整数
   * @param  {[type]}  i [description]
   * @return {Boolean}   [description]
   */
  isInt(i) {
    return i == parseInt(i);
  }

  /**
   * 是否是日期
   * @param {*} data 
   * @returns 
   */
  isDate(data) {
    return isNaN(data) && !isNaN(Date.parse(data));
  }

  /**
   * 是否是移动端
   * @return {Boolean} [description]
   */
  isMobile() {
    return /Android|webOS|iPhone|iPad|Windows Phone|iPod|BlackBerry|SymbianOS|Nokia|Mobile/i.test(navigator.userAgent);
  }

  /**
   * 数字前面补零
   * @param  {[type]} num [description]
   * @param  {[type]} n   [description]
   * @return {[type]}     [description]
   */
  prefixInteger(num, n) {
    return (Array(n).join(0) + num).slice(-n);
  }

  /**
   * 解析日期格式的值
   * @param {*} data 
   * @returns 
   */
  parseDate(data) {
    if (!data) return null;
    if (this.isDate(data)) return data;
    if (typeof (data) == "string") {
      //处理2022-03-29T02:00:00+08:00这种格式
      if (data.indexOf('+08:00') > 0) data = data.replace("T", " ").replace("+08:00", " ").replace(/-/g, "/");
      if (data.indexOf(":") > 0) {
        return new Date(data);
      } else if (data.indexOf("-") > 0 || data.indexOf("/") > 0) {
        return new Date(data + " 0:00:00");
      } else {
        return null;
      }
    } else if (typeof value === 'number' && !isNaN(value)) {
      var date_num = parseInt(data);
      var time_num = data - date_num;
      var date = new Date(1900, 0, 0, 0, 0, 0);
      date.setDate(date_num - 1);
      date.setMonth(date.getMonth() + 1);
      date.setSeconds(time_num * 60 * 60 * 12 * 2);
      date.setSeconds(0);
      return date;
    } else {
      return null;
    }
  }

  /**
   * 格式化金额
   * @param  {[type]} s 输入值
   * @param  {[type]} n 小数点位数
   * @param  {[type]} t 是否显示千分位
   * @return {[type]}   返回值
   */
  formatMoney(s, n, t) {
    if ((s + "").trim() == "") return "";
    n = n > 0 && n <= 20 ? n : 2;
    s = parseFloat((s + "").replace(/[^\d\.-]/g, "")).toFixed(n) + "";
    if (!t) return s;
    var l = s.split(".")[0].split("").reverse();
    var r = s.split(".")[1];
    var t = "";
    for (var i = 0; i < l.length; i++) {
      t += l[i] + ((i + 1) % 3 === 0 && i + 1 != l.length ? "," : "");
    }
    let ret = t.split("").reverse().join("") + "." + r;
    if (ret.startsWith("-,")) ret = "-" + ret.substring(2);
    return ret;
  }

  /**
   * 格式化小数
   * @param  {[type]} val  [description]
   * @param  {[type]} type [description]
   * @param  {[type]} len  [description]
   * @return {[type]}      [description]
   */
  formatDecimal(val, type, len) {
    if (!val && val != 0) return val;
    let decVal = parseFloat(val);
    if (!len && len != 0) return decVal;
    let decLen = parseInt(len);
    if (decLen == 0) return parseInt(decVal);
    if (type == "trunc") {
      decVal = Math.trunc(decVal);
    } else if (type == "toFixed") {
      decVal = decVal.toFixed(decLen);
    } else if (type == "toPrecision") {
      decVal = decVal.toPrecision(decLen);
    } else if (type == "ceil") {
      decVal = Math.ceil(decVal);
    } else if (type == "floor") {
      decVal = Math.floor(decVal);
    } else if (type == "abs") {
      decVal = Math.abs(decVal);
    } else if (type == "round") {
      let numPow = Math.pow(10, decLen);
      decVal = decVal * numPow;
      decVal = Math.round(decVal);
      decVal = decVal / numPow;
      decVal = decVal.toFixed(decLen);
    }
    return decVal;
  }

  /**
   * 格式化日期
   * @param  {[type]} d 输入值
   * @param  {[type]} f 格式
   * @return {[type]}   返回值
   */
  formatDate(d, f) {
    if (!d || d == "null" || d == "undefined") return "";
    if (typeof d == "number") return new Date(d).format(f);
    if (typeof (d) == "string" && d.indexOf('+08:00') > 0) d = d.replace("T", " ").replace("+08:00", " ").replace(/-/g, "/");
    return new Date(Date.parse(d)).format(f);
  }

  /**
   * 获得星期几
   * @param {*} d 
   * @returns 
   */
  getWeekDay(d, addWeek) {
    let dd = d;
    if (!this.isDate(d)) dd = new Date(d);
    return (addWeek ? "星期" : "") + "日一二三四五六".charAt(dd.getDay());
  }

  /**
   * 获得两个日期之间的间隔
   * @param {*} date1 
   * @param {*} date2 
   * @param {*} type 
   * @returns 
   */
  getIntervalBetweenDates(date1, date2, type) {
    let d1 = typeof (date1) == "string" ? new Date(date1) : date1;
    let d2 = typeof (date2) == "string" ? new Date(date2) : date2;
    const milliseconds1 = d1.getTime();
    const milliseconds2 = d2.getTime();
    const interval = Math.abs(milliseconds1 - milliseconds2);
    let days = null;
    if (type == "hour") {
      days = Math.floor(interval / (1000 * 60 * 60));
    } else if (type == "minute") {
      days = Math.floor(interval / (1000 * 60));
    } else if (type == "second") {
      days = Math.floor(interval / 1000);
    } else {
      days = Math.floor(interval / (1000 * 60 * 60 * 24));
    }
    return days;
  }

  /**
   * 日期加减
   * @param {*} d 日期
   * @param {*} t 类型
   * @param {*} n 数量
   */
  addDate(d, t, n) {
    var d2 = new Date(d);
    if (t == "year") {
      d2.setFullYear(d2.getFullYear() + n);
    } else if (t == "month") {
      d2.setMonth(d2.getMonth() + n);
    } else if (t == "date") {
      d2.setDate(d2.getDate() + n);
    } else if (t == "week") {
      d2.setDate(d2.getDate() + n * 7);
    } else if (t == "hour") {
      d2.setHours(d2.getHours() + n);
    } else if (t == "minute") {
      d2.setMinutes(d2.getMinutes() + n);
    } else if (t == "second") {
      d2.setSeconds(d2.getSeconds() + n);
    }
    return d2;
  }

  /**
   * 格式化文件大小
   * @param  {[type]} bytes [description]
   * @return {[type]}       [description]
   */
  formatFileSize(bytes) {
    if (bytes === 0) return '0 B';
    var k = 1000,
      // or 1024
      sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
      i = Math.floor(Math.log(bytes) / Math.log(k));
    return (bytes / Math.pow(k, i)).toPrecision(3) + ' ' + sizes[i];
  }

  /**
   * 格式化像素值，如果没有px，则自动添加
   * @param  {[type]} value [description]
   * @return {[type]}       [description]
   */
  formatPx(value) {
    if (this.isNull(value)) return "";
    return (value + "").indexOf("px") < 0 ? value + "px" : value;
  }

  /**
   * 获得样式中的像素值，将px字母删掉，转换为整数
   * @param  {[type]} value [description]
   * @return {[type]}       [description]
   */
  getPixel(value) {
    return this.getPx(value);
  }

  getPx(value) {
    if (this.isNull(value)) return 0;
    return parseInt(new String(value + "").replace("px", ""));
  }

  /**
   * 格式化RGB颜色值
   * @param  {[type]} color [description]
   * @return {[type]}       [description]
   */
  rgbToHex(color) {
    let arr = color.split(',');
    let r = +arr[0].split('(')[1];
    let g = +arr[1];
    let b = +arr[2].split(')')[0];
    let value = (1 << 24) + r * (1 << 16) + g * (1 << 8) + b;
    value = value.toString(16);
    return '#' + value.slice(1);
  }

  /**
   * 获得URL中的所有参数
   * @param  {[type]} url [description]
   * @return {[type]}     [description]
   */
  getUrlArgs(url) {
    var args = {};
    let u = url;
    if (!u) u = window.location.search;
    var start = u.indexOf("?");
    if (start < 0) return args;
    var str = u.substr(start + 1);
    var strArr = str.split("&");
    for (var i = 0; i < strArr.length; i++) {
      var argName = strArr[i].substr(0, strArr[i].indexOf("="));
      var argValue = strArr[i].substr(strArr[i].indexOf("=") + 1);
      args[argName] = argValue;
    }
    return args;
  }

  /**
   * 获得URL中的指定参数的值
   * @param  {[type]} argName [description]
   * @return {[type]}         [description]
   */
  getUrlArg(argName) {
    var url = window.location.search;
    var start = url.indexOf("?");
    if (start < 0) return null;
    var str = url.substr(start + 1);
    var strArr = str.split("&");
    for (var i = 0; i < strArr.length; i++) {
      var aname = strArr[i].substr(0, strArr[i].indexOf("="));
      if (aname == argName) return decodeURIComponent(strArr[i].substr(strArr[i].indexOf("=") + 1));
    }
    return null;
  }

  /**
   * 在URL里追加参数，并根据URL里目前有没有其他参数动态决定参数前面是加？号还是&
   * @param {*} url 
   * @param {*} argName 
   * @param {*} argVal 
   */
  addUrlArg(url, argName, argVal) {
    let u = url + "";
    if (u.indexOf("?") < 0) {
      u += "?";
    } else {
      u += "&";
    }
    u += argName + "=" + argVal;
    return u;
  }

  /**
   * 对比两个JSON对象指定属性的值
   * @param 属性名 
   * @returns 
   */
  compareObjPropValue(propertyName) {
    return function (object1, object2) {
      var value1 = object1[propertyName];
      var value2 = object2[propertyName];
      if (value2 < value1) {
        return 1;
      }
      else if (value2 > value1) {
        return -1;
      }
      else {
        return 0;
      }
    }
  }

  /**
   * 替换数据绑定字段
   * @param  {[type]} obj [description]
   * @param  {[type]} str [description]
   * @return {[type]}     [description]
   */
  replaceDataField(obj, str, defaultVal) {
    if (!obj || (!str && str != 0)) return "";

    //MSSQLServer默认是不区分大小写的，而且在查询时，返回的字段名都会转换为小写
    //因此，在绑定数据时，需要将数据对象的属性名变成小写
    let objTmp = {};
    for (let p in obj) {
      objTmp[p.toLowerCase()] = obj[p];
    }

    var patt = new RegExp("{([\\w|\.|,|\\u4E00-\\u9FA5]*)}", "ig");
    var result = patt.exec(str);
    while (result != null) {
      let fieldStr = result[0];
      fieldStr = fieldStr.substring(1, fieldStr.length - 1);
      var fieldName = fieldStr;
      var format = "";
      if (fieldStr.indexOf(",") > 0) {
        format = fieldStr.substr(fieldStr.indexOf(",") + 1).trim();
        fieldName = fieldStr.substr(0, fieldStr.indexOf(","));
      }
      fieldName = fieldName.replace(/ /g, "").toLowerCase();
      let fieldVal = objTmp[fieldName];
      if (fieldVal || fieldVal == 0) {
        if (typeof (fieldVal) == "object") {
          if (str == "{" + fieldName + "}") {
            return fieldVal;
          } else {
            str = str.replace("{" + fieldStr + "}", JSON.stringify(fieldVal));
          }
        } else if (format == "datetime") {
          str = str.replace("{" + fieldStr + "}", new Date(fieldVal).format("yyyy-MM-dd HH:mm:ss"));
        } else if (format == "date") {
          str = str.replace("{" + fieldStr + "}", new Date(fieldVal).format("yyyy-MM-dd"));
        } else if (format == "time") {
          str = str.replace("{" + fieldStr + "}", new Date(fieldVal).format("HH:mm:ss"));
        } else if ((format.indexOf("\"") >= 0 || format.indexOf("'") >= 0)
          && (format.indexOf("yy") >= 0 || format.indexOf("MM") >= 0
            || format.indexOf("dd") >= 0 || format.indexOf("HH") >= 0
            || format.indexOf("hh") >= 0 || format.indexOf("ss") >= 0)) {
          format = format.replace(/"/g, "").replace(/'/g, "");
          var dateStr = fieldVal + '';
          //if (dateStr.indexOf("T") < 0) dateStr = dateStr.replace(/-/g, '/');
          str = str.replace("{" + fieldStr + "}", new Date(dateStr).format(format));
        } else if (format == "money") {
          str = str.replace("{" + fieldStr + "}", this.formatMoney(fieldVal, 2));
        } else if (format == "filesize") {
          str = str.replace("{" + fieldStr + "}", this.formatFileSize(fieldVal));
        } else {
          str = str.replace("{" + fieldStr + "}", (fieldVal + "").replace(/\{/g, "`(`").replace(/\}/g, "`)`"));
        }
      } else {
        if (defaultVal || defaultVal == 0) {
          str = str.replace("{" + fieldStr + "}", "" + defaultVal);
        } else {
          str = str.replace("{" + fieldStr + "}", "");
        }
      }
      patt = new RegExp("{([\\w|\.|\\u4E00-\\u9FA5]*)}", "ig");
      result = patt.exec(str);
    }

    return str;
  }

  /**
   * 执行表达式
   * @param  {[type]} str [description]
   * @return {[type]}     [description]
   */
  exeExpress(str) {
    if (isNull(str) || typeof (str) != "string") return str;
    var start = str.indexOf("#[");
    if (start < 0) return str.replace(/\`\(\`/g, "{").replace(/\`\)\`/g, "}");
    var end = str.indexOf("]", start);
    if (end < 0) return str;
    var express = str.substr(start + 2, end - start - 2);
    var val = "";
    try {
      val = eval(express);
    } catch (err) { }
    var newStr = "";
    if (start > 0) newStr += str.substr(0, start);
    newStr += val;
    if (end < str.length - 1) newStr += str.substr(end + 1);
    return this.exeExpress(newStr);
  }

  /**
   * 在iframe页面内获得顶部窗口对象
   * @return {[type]} [description]
   */
  get topWin() {
    let topWin = window;
    //在嵌入第三方系统时，调用top和window.parent都会产生跨域错误，需要捕获一下
    try {
      if ("undefined" != typeof top && top.location.href != location.href) {
        topWin = top;
      }
    } catch (err) {
      try {
        if (window.parent) {
          topWin = window.parent;
        }
      } catch (err2) { }
    }
    return topWin;
  }

  /**
   * 显示提示消息，3秒后自动关闭
   * @param  {[type]} msg [description]
   * @return {[type]}     [description]
   */
  showToast(msg) {
    if (typeof window != "undefined") {
      if (this.topWin.showToast) {
        this.topWin.showToast(msg);
      } else {
        alert(msg);
      }
    } else {
      console.log(msg);
    }
  }

  /**
   * 显示提示消息
   * @param  {[type]} msg [description]
   * @return {[type]}     [description]
   */
  showMsg(msg, cb) {
    if (typeof window != "undefined") {
      if (this.topWin.showMsg) {
        this.topWin.showMsg(msg, cb);
      } else {
        alert(msg);
      }
    } else {
      console.log(msg);
    }
  }

  /**
   * 显示确认消息
   * @param  {[type]} msg [description]
   * @return {[type]}     [description]
   */
  showConfirm(msg, cb) {
    if (typeof window != "undefined") {
      if (this.topWin.showConfirm) {
        this.topWin.showConfirm(msg, cb);
      } else {
        cb(confirm(msg));
      }
    } else {
      console.log(msg);
    }
  }

  /**
   * 跳转到系统首页
   * @return {[type]} [description]
   */
  gotoHome() {
    if (typeof (this.topWin.gotoHome) != "undefined") {
      this.topWin.gotoHome();
    } else {
      location = "/app/sys/console/home.tfp";
    }
  }

  /**
   * 获得相对父窗口的URL路径
   */
  getUrlByOpener(opener, url) {
    if (!url) return null;
    if (url.indexOf(":/") > 0 || url.indexOf("/") == 0) return url;

    //下面这行代码是为了兼容一些老的系统，原来只支持绝对路径，不是/开头会自动加/
    //将来可能不再支持这种方式
    if (url.indexOf("app/") == 0) return "/" + url;

    let openerPath = opener.location.pathname;
    //如果是TaskBuilder内打开页面
    if (openerPath.indexOf("/resources/app/node_modules/") > 0) return url;
    openerPath = openerPath.substr(0, openerPath.lastIndexOf("/"));
    if (url.indexOf("../") == 0) {
      let arrPath = openerPath.substr(1).split("/");
      let urlTmp = url;
      let pathIndex = 0;
      while (urlTmp.indexOf("../") == 0) {
        if (arrPath.length == 0) break;
        arrPath.length = arrPath.length - 1;
        if (urlTmp.length == 3) break;
        urlTmp = urlTmp.substr(3);
      }
      let urlDest = "/";
      if (arrPath.length > 0) urlDest += arrPath.join("/");
      urlDest += "/" + urlTmp;
      url = urlDest;
    } else {
      url = openerPath + "/" + url;
    }
    return url;
  }

  /**
   * 跳转到指定页面
   * @param  {[type]} url [description]
   * @return {[type]}     [description]
   */
  gotoPage(url) {
    location = url;
  }

  /**
   * 打开指定页面
   * @param  {[type]} title [description]
   * @param  {[type]} url   [description]
   * @return {[type]}       [description]
   */
  openPage(title, url) {
    let u = this.getUrlByOpener(window, url);
    if (typeof (this.topWin.openTabPage) != "undefined") {
      return this.topWin.openTabPage(title, u, null, window);
    } else if (typeof (this.topWin.openPage) != "undefined") {
      return this.topWin.openPage(title, u, null, window);
    } else if (typeof (window.tmClient) != "undefined") {
      tmClient.openWebPage({
        title: title,
        url: url
      });
    } else {
      location = u;
      return null;
    }
  }

  /**
   * 打开网页回调函数，配合invokeOpenerCallbackFunc扩展使用
   * @callback openWebPageCallback
   * @param {Any} arg 数据
   */
  /**
   * 打开网页
   * @param {Object} args 参数
   * @param {String} args.url 地址
   * @param {String} args.title 页面标题
   * @param {String} [args.leftNavButtonTitle] 左侧按钮文本
   * @param {Boolean} [args.isRemotePath] 是否加载本地url
   * @param {String | openWebPageCallback} [args.callback] 执行当前页面回调，
   * @param {Boolean} [args.hideNavBar] 是否隐藏标题栏
   * @param {Boolean} [args.noAuth] 是否拼接身份验证参数
   * @example
   * tmClient.openPageMobile({ url: '127.0.0.1', title: '首页' });
   */
  openPageMobile(args) {
    if (!args) return this.showMsg('请提供打开网页参数');
    if (!args.url) return this.showMsg('请提供网页路径');
    //args.title = args.title || this.curPage?.dataModel?.title || '新标签页';

    if (this.curPage && this.curPage.dataModel && this.curPage.dataModel.title)
      args.title = this.curPage.dataModel.title;
    if (!args.title) args.title = '新标签页';

    (top.tmClient || tmClient).openWebPage(args);
  }

  /**
   * 调用openWebPage的回调函数
   * @param  {any} arg 数据
   * @example
   * tfp.invokeOpenerFuncMobile(res);
   */
  invokeOpenerFuncMobile(arg) {
    (top.tmClient || tmClient).invokeOpenerCallbackFunc(arg);
  }


  /**
   * 获得指定页面
   * @param  {[type]} id [description]
   * @return {[type]}    [description]
   */
  getPage(id) {
    if (typeof (this.topWin.getTabPage) != "undefined") {
      return this.topWin.getTabPage(id);
    } else if (typeof (this.topWin.getPage) != "undefined") {
      return this.topWin.getPage(id);
    }
    return null;
  }

  /**
   * 获得所有页面列表
   * @param  {[type]} id [description]
   * @return {[type]}    [description]
   */
  getPageList() {
    var arr = [];
    if (typeof (this.topWin.tabPageList) != "undefined") {
      for (url in tabPageList) {
        var tabPage = tabPageList[url];
        arr.push(tabPage);
      }
    }
    return arr;
  }

  /**
   * 显示指定页面
   * @param  {[type]} id [description]
   * @return {[type]}    [description]
   */
  showPage(id) {
    if (typeof (this.topWin.showTabPage) != "undefined") {
      this.topWin.showTabPage(id);
    } else if (typeof (this.topWin.showPage) != "undefined") {
      this.topWin.showPage(id);
    }
  }

  /**
   * 隐藏指定页面
   * @param  {[type]} id [description]
   * @return {[type]}    [description]
   */
  hidePage(id) {
    if (typeof (this.topWin.hideTabPage) != "undefined") {
      this.topWin.hideTabPage(id);
    } else if (typeof (this.topWin.hidePage) != "undefined") {
      this.topWin.hidePage(id);
    }
  }

  /**
   * 获得当前页面
   * @return {[type]} [description]
   */
  getCurPage() {
    if (typeof (this.topWin.getCurTabPage) != "undefined") {
      return this.topWin.getCurTabPage();
    } else if (typeof (this.topWin.getCurPage) != "undefined") {
      return this.topWin.getCurPage();
    }
  }

  /**
   * 关闭指定页面
   * @param  {[type]} id [description]
   * @return {[type]}    [description]
   */
  closePage(id) {
    if (typeof (this.topWin.closeTabPage) != "undefined") {
      this.topWin.hideTabPage(id);
    } else if (typeof (this.topWin.closePage) != "undefined") {
      this.topWin.hidePage(id);
    }
  }

  /**
   * 关闭当前窗口
   * @example
   * tfp.closePageMobile();
   */
  closePageMobile() {
    (top.tmClient || tmClient).close();
  }

  /**
   * 关闭除了当前页面以及首页以外的其他所有页面
   * @return {[type]} [description]
   */
  closeAllOtherPage() {
    if (typeof (this.topWin.closeOtherTabPage) != "undefined") {
      this.topWin.closeOtherTabPage();
    } else if (typeof (this.topWin.closeOtherPage) != "undefined") {
      this.topWin.closeOtherPage();
    }
  }

  /**
   * 关闭所有页面
   * @return {[type]} [description]
   */
  closeAllPage() {
    if (typeof (this.topWin.closeAllTabPage) != "undefined") {
      this.topWin.closeAllTabPage();
    } else if (typeof (this.topWin.closeAllPage) != "undefined") {
      this.topWin.closeAllPage();
    }
  }

  /**
   * 关闭当前页面
   * @return {[type]} [description]
   */
  closeCurPage() {
    if (typeof (this.topWin.closeCurTabPage) != "undefined") {
      this.topWin.closeCurTabPage();
    } else if (typeof (this.topWin.closeCurPage) != "undefined") {
      this.topWin.closeCurPage();
    } else if (typeof (window.tmClient) != "undefined") {
      tmClient.close();
    }
  }

  /**
   * 打开弹出对话框
   * @param  {[type]} title      [description]
   * @param  {[type]} url        [description]
   * @param  {[type]} icon       [description]
   * @param  {[type]} width      [description]
   * @param  {[type]} height     [description]
   * @param  {[type]} args       [description]
   * @param  {[type]} cb         [description]
   * @return {[type]}            [description]
   */
  openDialog(title, url, width, height, args, cb) {
    if (arguments.length == 0) {
      this.showToast("请提供必要的参数！");
      return;
    }
    if (typeof (this.topWin.openDialog) != "undefined") {
      let srcElement = null;
      if (window.event) srcElement = window.event.srcElement;
      if (isObj(arguments[0])) {
        var options = arguments[0];
        options.srcElement = srcElement;
        options.opener = window;
        if (arguments.length == 2) options.cb = cb;
        this.topWin.openDialog(options);
      } else {
        this.topWin.openDialog(title, url, width, height, srcElement, window, args, cb);
      }
    } else if (typeof (window.tmClient) != "undefined") {
      tmClient.openWebPage({
        title: title,
        url: url,
        callback: cb
      });
    } else {
      location = url;
    }
  }

  /**
   * 关闭对话框
   * @return {[type]} [description]
   */
  closeDialog(id) {
    if (typeof (this.topWin.closeDialog) != "undefined") {
      this.topWin.closeDialog(id);
    }
  }

  /**
   * 关闭当前对话框
   * @return {[type]} [description]
   */
  closeCurDialog(ret) {
    if (typeof (this.topWin.closeCurDialog) != "undefined") {
      let curDialog = this.getCurDialog();
      if (!curDialog) return;
      if (ret && curDialog.cb) curDialog.cb(ret);
      if (curDialog.id) {
        this.topWin.closeDialog(curDialog.id);
      } else {
        this.topWin.closeCurDialog();
      }
    } else if (typeof (window.tmClient) != "undefined") {
      if (ret || ret == 0) {
        try {
          tmClient.invokeOpenerCallbackFunc(ret);
        } catch (err) { }
      }
      tmClient.close();
    }
  }

  /**
   * 关闭所有对话框
   * @returns 
   */
  closeAllDialogs() {
    let dialogs = this.getDialogs();
    if (!dialogs) return;
    let arr = [];
    for (let id in dialogs) {
      arr.push(id);
    }
    for (var i = 0; i < arr.length; i++) {
      this.topWin.closeDialog(arr[i]);
    }
    arr = null;
  }

  /**
   * 获得指定id的对话框
   * @return {[type]} [description]
   */
  getDialog(id) {
    let dialogs = this.getDialogs();
    if (!dialogs) return null;
    return dialogs[id];
  }

  /**
   * 获得显示在最顶层的对话框
   * @returns 
   */
  getTopDialog() {
    let dialogs = this.getDialogs();
    if (!dialogs) return null;
    let maxDialogId = "";
    let maxZIndex = 0;
    for (id in dialogs) {
      let zIndex = $("#" + id).css("z-index");
      if (zIndex > maxZIndex) {
        maxZIndex = zIndex;
        maxDialogId = id;
      }
    }
    if (maxDialogId != "") return dialogs[maxDialogId];
    return null;
  }

  /**
   * 获得当前对话框
   * @return {[type]} [description]
   */
  getCurDialog() {
    let curDialogId = this.getCurDialogId();
    if (!curDialogId) return null;
    return this.getDialog(curDialogId);
  }

  /**
   * 获得所有对话框字典
   * @returns 
   */
  getDialogs() {
    if (typeof (this.topWin.dialogDic) != "undefined") {
      return this.topWin.dialogDic;
    } else if (typeof (this.topWin.dialogList) != "undefined") {
      return this.topWin.dialogList;
    }
    return null;
  }

  /**
   * 获得所有对话框数组
   * @returns 
   */
  getDialogList() {
    let arr = [];
    let dialogs = this.getDialogs();
    if (!dialogs) return [];
    for (let dialogId in dialogs) {
      arr.push(dialogs[dialogId]);
    }
    return arr;
  }

  /**
   * 获得当前对话框ID
   * @return {[type]} [description]
   */
  getCurDialogId() {
    if (this.getUrlArg("_curDialogId")) return this.getUrlArg("_curDialogId");
    if (typeof (this.topWin.getCurDialogId) != "undefined") {
      return this.topWin.getCurDialogId();
    }
    return null;
  }

  /**
   * 获得对话框请求参数
   * @return {[type]} [description]
   */
  getDialogArgs() {
    let dialog = this.getCurDialog();
    if (!dialog) return "";
    if (dialog.args) {
      //if (!isObj(dialog.args)) return JSON.parse(dialog.args);
      return dialog.args;
    }
    //以下代码是为了兼容tb开发工具的Electron浏览器
    return sessionStorage.getItem("_OpenDialogArgs");
  }

  /**
   * 点击对话框确定按钮后
   * @param  {[type]} ret [description]
   * @return {[type]}     [description]
   */
  onDialogOK(ret) {
    if (typeof (this.topWin.onDialogOK) != "undefined") {
      this.topWin.onDialogOK(ret);
    }
  }

  /**
   * 打开抽屉式对话框
   * @param  {[type]} title      [description]
   * @param  {[type]} url        [description]
   * @param  {[type]} args       [description]
   * @param  {[type]} cb         [description]
   * @return {[type]}            [description]
   */
  openDrawer(title, url, args, cb) {
    if (typeof (this.topWin.openDrawer) != "undefined") {
      if (arguments.length == 0) {
        this.showToast("请提供必要的参数！");
        return;
      }
      let srcElement = null;
      if (window.event) srcElement = window.event.srcElement;
      if (isObj(arguments[0])) {
        var options = arguments[0];
        options.srcElement = srcElement;
        options.opener = window;
        if (arguments.length == 2) options.cb = arguments[1];
        this.topWin.openDrawer(options);
      } else {
        this.topWin.openDrawer(title, url, srcElement, window, args, cb);
      }
    } else {
      location = url;
    }
  }

  getCurDrawer() {
    if (typeof (this.topWin.curDrawer) != "undefined") return this.topWin.curDrawer;
    return null;
  }

  /**
   * 关闭当前抽屉式对话框
   * @return {[type]} [description]
   */
  closeDrawer() {
    if (typeof (this.topWin.closeDrawer) != "undefined") {
      this.topWin.closeDrawer();
    }
  }

  /**
   * 获得打开当前页面的父页面或前置页面
   * @return {[type]} [description]
   */
  getOpener() {
    if (this.curPage.pageType == "dialog") {
      return this.getCurDialog().opener;
    } else {
      return this.topWin.getCurTabPageOpener();
    }
  }

  /**
   * 打开图片查看器
   * @param  {[type]} url [description]
   * @return {[type]}     [description]
   */
  openImage(url, index) {
    let u = url;
    if (!u) return;
    u += "";
    if (u.indexOf("/Download?") == 0 && u.indexOf("showImage") < 0) u += "&showImage=true";
    try {
      top.showImageViewer("/app/sys/tool/imageViewer.tfp?url=" + u + "&index=" + index);
    } catch (err) {
      this.openPage("查看图片", "/app/sys/tool/imageViewer.tfp?url=" + u + "&index=" + index);
    }
  }

  /**
   * 打开PDF查看器
   * @param {*} url 
   */
  openPdfViewer(url) {
    window.open("/inc/pdfjs/web/viewer.html?file=" + url);
  }

  /**
   * 打开指定报表
   * @param  {[type]} title [description]
   * @param  {[type]} url   [description]
   * @return {[type]}       [description]
   */
  openReport(url) {
    if (!url) return;
    url = url.replace("?", "&");
    if (url.indexOf(".tfp") > 0) {
      window.open("/node_modules/taskreport/index.html?url=" + url);
    } else {
      window.open("/node_modules/task-print-report/index.html?url=" + url);
    }
  }

  print(el, options) {
    if (!el) return;
    let headDom = document.getElementsByTagName("head")[0];
    let iframe = document.createElement("iframe");
    iframe.setAttribute("id", "tfp-print-box");
    iframe.setAttribute("style", "position:absolute;width:0px;height:0px;left:-500px;top:-500px;");
    document.body.appendChild(iframe);
    let doc = iframe.contentWindow.document;

    //附加样式
    let styleDom = document.createElement("style");
    styleDom.innerHTML = $(headDom).children("style").get(0).innerHTML;
    doc.getElementsByTagName("head")[0].appendChild(styleDom);

    if (options) {
      let styleOptions = document.createElement("style");
      styleOptions.innerHTML = `@page { 
        size: ${options.pageWidth}in ${options.pageHeight}in ${options.orientation}; 
        margin: 0;
      };`;
      doc.getElementsByTagName("head")[0].appendChild(styleOptions);
    }

    let imageCount = $(el).find("img").length;
    let imageLoaded = 0;

    let printDiv = document.createElement("div");
    printDiv.setAttribute("id", "tfp-print-box");
    printDiv.innerHTML = el.innerHTML;
    doc.body.appendChild(printDiv);

    let curDoc = document;
    if (imageCount == 0) {
      iframe.contentWindow.focus();
      iframe.contentWindow.print();
      curDoc.body.removeChild(iframe);
    } else {
      $(doc.body).find("img").on('load', function () {
        imageLoaded++;
        if (imageLoaded >= imageCount) {
          iframe.contentWindow.focus();
          iframe.contentWindow.print();
          curDoc.body.removeChild(iframe);
        }
      });
    }
    doc.close();
  }

  /**
   * 获得URL的实际路径
   * @param  {[type]} url [description]
   * @return {[type]}     [description]
   */
  getUrlRealPath(url) {
    if (!url) return "";
    var realPath = "";
    if (this.curPage && this.curPage.client == "tb") {
      realPath = url;
      if (realPath.indexOf("/") == 0) realPath = ".." + realPath;
    } else {
      if (this.isDesigning && url.indexOf("http:") != 0 && url.indexOf("https:") != 0
        && window.parent.tfpDesigner.curTFPFilePath.indexOf(":\\") < 0) {
        var curServer = top.taskBuilder.getCurServer();
        realPath = "http://";
        if (curServer.userHttps) realPath = "https://";
        if (curServer.address) realPath += curServer.address;
        if (curServer.port) realPath += ":" + curServer.port;
        if (url.indexOf("/") == 0) {
          if (realPath == "http://") {
            realPath = url;
          } else {
            realPath += url;
          }
        } else {
          var curPath = window.parent.tfpDesigner.curTFPFilePath.substring(
            window.parent.tfpDesigner.curTFPFilePath.indexOf("/web/") + 4,
            window.parent.tfpDesigner.curTFPFilePath.lastIndexOf("/") + 1);
          if (url.indexOf("../") == 0) {
            while (url.indexOf("../") == 0) {
              url = url.substring(3);
              if (curPath != "/") curPath = curPath.substring(0,
                curPath.lastIndexOf("/", curPath.length - 2) + 1);
            }
            realPath += curPath + url;
          } else if (url.indexOf("./") == 0) {
            realPath += curPath + url.substring(2);
          } else {
            realPath += curPath + url;
          }
        }
      } else {
        realPath = url;
      }
    }
    return realPath;
  }

  replaceStyleUrl(styleVal) {
    if (!this.isDesigning || !styleVal || (styleVal + '').indexOf("url(") < 0) return styleVal;
    //如果样式内有url路径，且目前是设计时，则需要为url路径添加服务器地址信息
    let url = styleVal.substring(styleVal.indexOf("url(") + 4);
    url = url.substring(0, url.indexOf(")"));
    url = styleVal.substring(0, styleVal.indexOf("url(") + 4)
      + this.getUrlRealPath(url) + styleVal.substr(styleVal.lastIndexOf(")"));
    return url;
  }

  appendPath = function (srcPath, addPath) {
    var splitChar = '/';
    srcPath = srcPath.replace(/\\/g, '/');
    addPath = addPath.replace(/\\/g, '/');
    if (srcPath.endWith("/")) srcPath = srcPath.substr(0, srcPath.length - 1);
    if (addPath.startWith("/")) addPath = addPath.substr(1);
    return srcPath + splitChar + addPath;
  };

  parseTBPath = function (path, projName) {
    var args = {};
    var tmp = "";
    var temp = "";

    if (path.startWith("/app/")) path = path.substr(5);
    else if (path.startWith("/dist/")) path = path.substr(6);
    else if (path.startWith("/")) path = path.substr(1);

    if (path.endWith('.tdf') || path.indexOf(".tdf.") > 0) {
      tmp = path.substr(0, path.indexOf("/tdf/"));
      args.projName = tmp.substr(tmp.indexOf("/") + 1);
      tmp = path.substr(path.indexOf("/tdf/") + 5);
      if (path.indexOf(".tdf.") > 0) tmp = tmp.substr(0, tmp.lastIndexOf("."));
      args.dataPath = tmp.substr(0, tmp.lastIndexOf("/"));
      tmp = tmp.substr(tmp.lastIndexOf("/") + 1);
      var tmps = tmp.substr(0, tmp.lastIndexOf(".")).split('.');
      args.dataName = tmps[0];
      args.opType = tmps[1];
      args.opName = tmps[2];
      args.isTDF = true;
    }
    else if (path.indexOf("/service/") > 0) {
      tmp = path.substr(0, path.indexOf("/service/"));
      args.projName = tmp.substr(tmp.indexOf("/") + 1);
      tmp = path.substr(path.indexOf("/service/") + 9);
      temp = tmp.substr(0, tmp.lastIndexOf("/"));
      args.dataPath = temp.substr(0, temp.lastIndexOf("/"));
      args.dataName = temp.substr(temp.lastIndexOf("/") + 1);
      tmp = tmp.substr(tmp.lastIndexOf("/") + 1);
      if (path.indexOf(".tbs.") > 0) tmp = tmp.substr(0, tmp.lastIndexOf("."));
      if (path.indexOf(".tes.") > 0) tmp = tmp.substr(0, tmp.lastIndexOf("."));
      args.opType = "service";
      if (tmp.indexOf(".") > 0) args.opName = tmp.substr(0, tmp.lastIndexOf("."));
      else args.opName = tmp;
    }
    else if (path.indexOf("/model/") > 0) {
      tmp = path.substr(0, path.indexOf("/model/"));
      args.projName = tmp.substr(tmp.indexOf("/") + 1);
      tmp = path.substr(path.indexOf("/model/") + 7);
      temp = tmp.substr(0, tmp.lastIndexOf("/"));
      args.dataPath = temp.substr(0, temp.lastIndexOf("/"));
      args.dataName = temp.substr(temp.lastIndexOf("/") + 1);
      tmp = tmp.substr(tmp.lastIndexOf("/") + 1);
      if (path.indexOf(".tdm.") > 0) tmp = tmp.substr(0, tmp.lastIndexOf("."));
      args.opType = "model";
      args.opName = tmp.substr(0, tmp.lastIndexOf("."));
    }
    else {
      args.projName = projName;
      tmp = path.substr(path.indexOf(projName) + projName.length + 1);
      temp = tmp.substr(0, tmp.lastIndexOf("/"));
      args.dataPath = temp.substr(0, temp.lastIndexOf("/"));
      args.dataName = temp.substr(temp.lastIndexOf("/") + 1);
      tmp = tmp.substr(tmp.lastIndexOf("/") + 1);
      if (path.indexOf(".tfp.") > 0) tmp = tmp.substr(0, tmp.lastIndexOf("."));
      args.opType = "view";
      args.opName = tmp.substr(0, tmp.lastIndexOf("."));
    }

    return args;
  };

  replaceTBPath = function (args0, args1) {
    var args = Object.assign({}, args0, args1);
    var opTypes = {
      "view": "tfp",
      "service": "tbs",
      "model": "tdm"
    }

    var path = "";
    //"/taskmsg/test/tdf/abc/bcd/xyz.view.index0.tdf",
    //"/taskmsg/test/tdf/abc/bcd/xyz.service.list0.tdf",
    //"/taskmsg/test/tdf/abc/bcd/xyz.model.abc_bcd_xyz.tdf",
    if (args.isTDF) {
      path += args.projName;
      if (path.lastIndexOf("/") != path.length - 1) path += "/";
      path += "tdf/";
      if (args.dataPath) path += args.dataPath;
      if (path.lastIndexOf("/") != path.length - 1) path += "/";
      path += args.dataName;
      path += "." + args.opType;
      path += "." + args.opName;
      path += ".tdf";
    }
    //"/taskmsg/test/abc/bcd/xyz/list0.tfp",
    //"/taskmsg/test/service/abc/bcd/xyz/list0.tbs",
    //"/taskmsg/test/model/abc/bcd/xyz/abc_bcd_xyz.tdm",
    else {
      path += args.projName;
      if (path.lastIndexOf("/") != path.length - 1) path += "/";
      if (args.opType != "view") path += args.opType;
      if (path.lastIndexOf("/") != path.length - 1) path += "/";
      if (args.dataPath) path += args.dataPath;
      if (path.lastIndexOf("/") != path.length - 1) path += "/";
      path += args.dataName;
      if (path.lastIndexOf("/") != path.length - 1) path += "/";
      path += args.opName;
      path += "." + opTypes[args.opType];
    }
    return path;
  };

  getTBPath = function (curPath, pathArgs, tarPath) {
    var path = "";
    if (tarPath) {
      if (tarPath.startWith("/app/")) path = tarPath.substr(5);
      else if (tarPath.startWith("/dist/")) path = tarPath.substr(6);
      else if (tarPath.startWith("/")) path = tarPath.substr(1);
    }
    else {
      var tmpPath = curPath;
      if (tmpPath.startWith("/app/")) tmpPath = tmpPath.substr(5);
      else if (tmpPath.startWith("/dist/")) tmpPath = tmpPath.substr(6);
      else if (tmpPath.startWith("/")) tmpPath = tmpPath.substr(1);

      if (typeof (pathArgs) == "string") pathArgs = JSON.parse(pathArgs);
      path = this.replaceTBPath(this.parseTBPath(tmpPath, pathArgs.projName), pathArgs);
    }

    // path = this.appendPath("/app", path);
    return path;
  };

  getCptIncludeFile(_filePath, cptTypeName, pageDataModel) {
    let tfpPath = this.rootPath + "/src/components";
    let filePath = _filePath;
    let pageDM = pageDataModel;
    if (this.curPage) pageDM = this.curPage.dataModel;

    if (filePath.indexOf("http://") != 0 && filePath.indexOf("https://") != 0) {
      if (filePath.indexOf("/") == 0) {
        if (this.isDesigning || (pageDM && pageDM.client == "tb")) {
          if (filePath.startsWith("/node_modules/")) {
            filePath = filePath.substr(13);
          }
          filePath = ".." + filePath;
        }
      } else if (filePath.indexOf("/") < 0) {
        filePath = tfpPath + "/" + cptTypeName.toLowerCase() + "/" + filePath;
      } else if (filePath.indexOf("../") == 0) {
        filePath = tfpPath + "/" + filePath.replaceAll("../", "");
      }
    }
    return filePath;
  }

  /**
   * 为URL设置身份验证信息
   * @param {[type]} url [description]
   */
  setUrlAuthData(url) {
    if (!url) return;
    try {
      if (typeof top != "undefined" && top.taskMsgAuthObj) {
        return top.taskMsgAuthObj.getAuthUrl(url);
      }
    } catch (err) {
      try {
        if (typeof window.parent != "undefined" && window.parent.taskMsgAuthObj) {
          return window.parent.taskMsgAuthObj.getAuthUrl(url);
        }
      } catch (err2) {
        var _auth_org = void 0;
        var _auth_ts = void 0;
        var _auth_data = void 0;
        if (typeof tmClient != "undefined" && (tmClient.clientOSType == "iOS"
          && typeof TMiOSClient != "undefined" || tmClient.clientOSType == "Android"
          && typeof TMAndroidClient != "undefined")) {
          var authData = JSON.parse(tmClient.getAuthData());
          _auth_org = authData._auth_org;
          _auth_ts = authData._auth_ts;
          _auth_data = authData._auth_data;
        } else {
          if (this.getUrlArg("_auth_org")) _auth_org = this.getUrlArg("_auth_org");
          if (this.getUrlArg("_auth_ts")) _auth_ts = this.getUrlArg("_auth_ts");
          if (this.getUrlArg("_auth_data")) _auth_data = this.getUrlArg("_auth_data");
        }
        if (!_auth_org && !_auth_ts && !_auth_data) return url;
        var ret = url;
        if (ret.indexOf('?') < 0) ret += "?";
        if (_auth_org) {
          if (!ret.endsWith("?")) ret += "&";
          ret += "_auth_org=" + _auth_org;
        }
        if (_auth_ts) {
          if (!ret.endsWith("?")) ret += "&";
          ret += "_auth_ts=" + _auth_ts;
        }
        if (_auth_data) {
          if (!ret.endsWith("?")) ret += "&";
          ret += "_auth_data=" + _auth_data;
        }
        return ret;
      }
    }

    return url;
  }

  /**
   * 获得指定id的组件
   * @param  {[type]} cptId [description]
   * @return {[type]}       [description]
   */
  get(cptId) {
    return this.components[cptId];
  }

  /**
  * 获得指定类型组件的新ID
  * @param  {[type]} ctype [description]
  * @return {[type]}       [description]
  */
  getNewCptIndex(ctype) {
    var index = 1;
    while (this.components[ctype.substr(0, 1).toLowerCase() + ctype.substr(1) + index]) {
      index++;
    }
    return index;
  }

  getMaxCptIndex(ctype) {
    var m = 0;
    var tid = ctype.substr(0, 1).toLowerCase() + ctype.substr(1);
    for (var id in this.components) {
      if (this.components[id].type == ctype) {
        var n = parseInt(id.replace(tid, ""));
        if (n > m) m = n;
      }
    }
    m++;
    return m;
  }

  /**
   * 使用默认属性和样式创建新的组件
   * @param  {[type]} typeName  [description]
   * @param  {[type]} parent    [description]
   * @return {[type]}           [description]
   */
  new(typeName, parent, target, direction) {
    if (!typeName) {
      throw new Error("请提供组件类型！");
      return null;
    }
    var cptTypeInfo = this.type(typeName);
    if (!cptTypeInfo) {
      throw new Error("未找到名为[" + typeName + "]的组件类型定义信息！");
      return null;
    }

    var cptClass = this.controllers[typeName];
    if (!cptClass) {
      throw new Error("未找到名为[" + typeName + "]的组件类！");
      return null;
    }
    var cpt = new cptClass(this, null, parent);
    if (parent) cpt.render(target, direction);
    return cpt;
  }

  /**
   * 根据指定的数据模型创建并渲染组件
   * @param  {[type]} dataModel [description]
   * @param  {[type]} parent    [description]
   * @return {[type]}           [description]
   */
  render(dataModel, parent, target, direction) {
    if (!dataModel) {
      console.error("请提供组件的数据模型！");
      return null;
    }
    if (!dataModel.type) {
      console.error("请提供组件类型！");
      return null;
    }
    if (!parent && dataModel.type != "Page") {
      console.error("请提供父组件！");
      return null;
    }
    var cptTypeInfo = this.type(dataModel.type);
    if (!cptTypeInfo) {
      throw new Error("未找到名为[" + dataModel.type + "]的组件类型定义信息！");
      return null;
    }
    var cptClass = this.controllers[dataModel.type];
    if (!cptClass) {
      throw new Error("未找到名为[" + dataModel.type + "]的组件控制器！");
      return null;
    }

    var cpt = new cptClass(this, dataModel, parent);
    cpt.render(target, direction);
    return cpt;
  }

  renderByTarget(dataModel, target, targetParent, direction) {
    if (!dataModel) {
      console.error("请提供组件的数据模型！");
      return null;
    }
    if (!dataModel.type) {
      console.error("请提供组件类型！");
      return null;
    }
    if (!parent && dataModel.type != "Page") {
      console.error("请提供父组件！");
      return null;
    }
    var cptTypeInfo = this.type(dataModel.type);
    if (!cptTypeInfo) {
      throw new Error("未找到名为[" + dataModel.type + "]的组件类型定义信息！");
      return null;
    }
    var cptClass = this.controllers[dataModel.type];
    if (!cptClass) {
      throw new Error("未找到名为[" + dataModel.type + "]的组件控制器！");
      return null;
    }

    var cpt = new cptClass(this, dataModel);
    cpt.renderByTarget(target, targetParent, direction);
    return cpt;
  }

  moveTarget(id, targetId, targetParentId, direction) {
    var source = this.components[id];
    var sourceParent = source.parent;
    var target = null;
    var targetParent = this.components[targetParentId];

    // if (source.parent.id == targetParent.id) {
    for (var i = 0; i < sourceParent.dataModel.components.length; i++) {
      if (sourceParent.dataModel.components[i].id == id) {
        sourceParent.dataModel.components.splice(i, 1);
        break;
      }
    }

    var index = 0;
    if (!targetId) {
      if (direction == "before" || direction == "prepend" || direction == "left" || direction == "top") {
        index = 0;
        targetParent._jqObj.prepend(source._jqObj);
      }
      else if (direction == "after" || direction == "append" || direction == "right" || direction == "bottom") {
        index = targetParent.dataModel.components.length - 1;
        if (index < 0) {
          index = 0;
          targetParent._jqObj.prepend(source._jqObj);
        }
        else {
          target = this.components[targetParent.dataModel.components[index].id];
          target._jqObj.after(source._jqObj);
          index = index + 1;
        }
      }
    }
    else {
      target = this.components[targetId];
      var b = false;
      for (var j = 0; j < targetParent.dataModel.components.length; j++) {
        if (targetParent.dataModel.components[j].id == targetId) {
          if (direction == "before" || direction == "prepend" || direction == "left" || direction == "top") {
            b = true;
            index = j;
            target._jqObj.before(source._jqObj);
          }
          else if (direction == "after" || direction == "append" || direction == "right" || direction == "bottom") {
            b = true;
            index = j + 1;
            target._jqObj.after(source._jqObj);
          }
          break;
        }
      }

      if (!b) {
        targetParent._jqObj.prepend(source._jqObj);
      }
    }
    targetParent.dataModel.components.splice(index, 0, source.dataModel);
    // }

    source.setParentOnly(targetParent);
  }

  removeTarget(id) {
    // var source = this.components[id];
    var cpt = this.components[id];
    var sourceParent = cpt.parent;

    for (var i = 0; i < sourceParent.dataModel.components.length; i++) {
      if (sourceParent.dataModel.components[i].id == id) {
        sourceParent.dataModel.components.splice(i, 1);
        break;
      }
    }

    if (cpt._jqObj) cpt._jqObj.remove();
    delete this.components[cpt.id];
    cpt.dataModel = null;
    cpt = null;
  }

  remove(_cpt, handleParent) {
    if (!_cpt) return;
    let cpt;
    if (typeof (_cpt) == "string") {
      cpt = this.components[_cpt];
    } else if (_cpt.dataModel) {
      cpt = _cpt;
    } else {
      cpt = this.components[_cpt.id];
    }
    if (cpt.dataModel.components) {
      for (var i = 0; i < cpt.dataModel.components.length; i++) {
        let cdmChild = cpt.dataModel.components[i];
        if (!cdmChild) {
          continue;
        }
        this.remove(cdmChild.id);
      }
      cpt.dataModel.components = null;
    }

    if (handleParent) {
      var sourceParent = cpt.parent;
      for (var i = 0; i < sourceParent.dataModel.components.length; i++) {
        if (sourceParent.dataModel.components[i].id == cpt.id) {
          sourceParent.dataModel.components.splice(i, 1);
          break;
        }
      }
    }

    if (cpt._jqObj) cpt._jqObj.remove();
    delete this.components[cpt.id];
    cpt.dataModel = null;
    cpt = null;
  }

  /**
   * 获得组件属性定义
   * @param  {[type]} cptType [description]
   * @param  {[type]} attrName   [description]
   * @return {[type]}          [description]
   */
  attrType(cptType, attrName) {
    if (!cptType.attrs) return null;
    for (var i = 0; i < cptType.attrs.length; i++) {
      if (cptType.attrs[i].name == attrName) return cptType.attrs[i];
    }
    return null;
  }

  /**
   * 获得为组件设置的事件处理函数的名称
   * @param  {[type]} eventSetting [description]
   * @return {[type]}              [description]
   */
  getCptEventFuncName(eventSetting) {
    var eventName = eventSetting;
    if (eventName.indexOf("(") > 0) eventName = eventName.substr(0, eventName.indexOf("("));
    return eventName;
  }

  /**
   * 获得Html标签样式属性名，删掉-号，并把-号后面的一个字母转换为大写
   * @param  {[type]} styleName [description]
   * @return {[type]}           [description]
   */
  getStyleAttrName(styleName) {
    var saName = styleName;
    while (saName.indexOf("-") > 0) {
      saName = saName.substr(0, saName.indexOf("-")) + saName.substr(saName.indexOf("-") + 1, 1).toUpperCase() + saName.substr(saName.indexOf("-") + 2);
    }
    return saName;
  }

  loadComponents(pageData, cb) {
    let that = this;
    that.loadComponentCategorys(pageData, function (categorys) {
      if (that.isDesigning && that.designerType == "formDesigner") {
        that.loadComponentCategorys_combo(pageData, function (categorys_combo) {
          cb(categorys_combo);
        });
      }
      else {
        cb(categorys);
      }
    });
  }

  /**
   * 加载组件分类
   * @param  {[type]} pageData [description]
   * @param  {[type]} cb       [description]
   * @return {[type]}          [description]
   */
  loadComponentCategorys(pageData, cb) {
    let that = this;
    let clientType = pageData.client;
    if (clientType == "tb") clientType = "pc";
    let componentsFilePath = "components." + clientType + ".js";
    if (pageData.pageType == "print-report") componentsFilePath = "components.print.js";
    //如果是设计时，或者是在IDE内加载，则使用tb本地的tfp文件（不包括预览）
    if (this.isDesigning || navigator.userAgent.indexOf('TaskBuilder') > 0 || pageData.pageType == "print-report") {
      componentsFilePath = "./" + componentsFilePath;
    } else if (window) {
      if (this.isWebDesigner) {  //如果是在Web浏览器里打开tb
        componentsFilePath = "/node_modules/tfp/src/" + componentsFilePath;
      } else {
        componentsFilePath = this.rootPath + "/lib/" + componentsFilePath;
      }
    }
    importModules(componentsFilePath, function (modules) {
      let categorys = modules[0].default;
      that.setComponentMetaDatas(categorys);
      /*for(let i=0;i<categorys.length;i++) {
       let category = categorys[i];
       for(let j=0;j<category.components.length;j++) {
        let cptMetaData = category.components[j];
        cptMetaData.isLoaded = false;
        that.metaDatas[cptMetaData.name] = cptMetaData;
       }
      }*/
      if (cb) cb(categorys);
    });
  }

  setComponentMetaDatas(categorys) {
    for (let i = 0; i < categorys.length; i++) {
      let category = categorys[i];
      for (let j = 0; j < category.components.length; j++) {
        let cptMetaData = category.components[j];
        cptMetaData.isLoaded = false;
        this.metaDatas[cptMetaData.name] = cptMetaData;
      }
    }
  }

  loadComponentCategorys_combo(pageData, cb) {
    let that = this;
    let componentsFilePath = "components.combo.js";
    //如果是设计时，或者是在IDE内加载，则使用tb本地的tfp文件（不包括预览）
    if (this.isDesigning || (window.parent && window.parent.taskBuilder)) {
      componentsFilePath = "./" + componentsFilePath;
    } else if (window) {
      componentsFilePath = this.rootPath + "/lib/" + componentsFilePath;
    }
    importModules(componentsFilePath, function (modules) {
      let categorys = modules[0].default;
      that.setComponentMetaDatas_combo(categorys);

      if (cb) cb(categorys);
    });
  }

  setComponentMetaDatas_combo(categorys) {
    for (let i = 0; i < categorys.length; i++) {
      let category = categorys[i];
      for (let j = 0; j < category.components.length; j++) {
        let cptMetaData = category.components[j];
        cptMetaData.isLoaded = false;
        this.metaDatas_combo[cptMetaData.name] = cptMetaData;
      }
    }
  }

  /**
   * 添加组件相关文件的引用
   * @param  {[type]}   cptTypes [description]
   * @param  {Function} cb       [description]
   * @return {[type]}            [description]
   */
  use(cptTypes, cb) {
    let arrTypes = cptTypes;
    if (typeof (arrTypes) == "string") arrTypes = [arrTypes];
    importCptFiles(this, this.curPage.dataModel, arrTypes, function () {
      if (cb) cb();
    });
  }

  /**
   * 解析数据模型中的组件类型
   * @param  {[type]} dataModel [description]
   * @param  {[type]} cptTypes  [description]
   * @return {[type]}           [description]
   */
  parseCptTypes(dataModel, cptTypes, userComponents) {
    if (dataModel.type != "Page" && !this.metaDatas[dataModel.type]) return;
    if (dataModel.type != "Page" && !cptTypes.includes(dataModel.type)) cptTypes.push(dataModel.type);
    if (dataModel.type == "UserComponent" && dataModel.path) userComponents.push({ id: dataModel.id, path: dataModel.path });
    if (dataModel.components) {
      for (let i = 0; i < dataModel.components.length; i++) {
        this.parseCptTypes(dataModel.components[i], cptTypes, userComponents);
      }
    }
  }

  /**
   * 解析组件数据模型
   * @param  {[type]} dataModel [description]
   * @param  {[type]} parent    [description]
   * @return {[type]}           [description]
   */
  parseCpt(dataModel, parent) {
    if (!dataModel) {
      console.error("请提供组件的数据模型！");
      return null;
    }
    if (!dataModel.type) {
      console.error("请提供组件类型！");
      return null;
    }
    if (!parent && dataModel.type != "Page") {
      console.error("请提供父组件！");
      return null;
    }
    var cptClass = this.controllers[dataModel.type];
    if (!cptClass) {
      throw new Error("未找到名为[" + dataModel.type + "]的组件控制器！");
      return null;
    }

    var cpt = new cptClass(this, dataModel, parent);
    if (dataModel.type == "Page") {
      this.curPage = cpt;
      try {
        this.curUser = top.curUser; //
      } catch (err) {
        console.log(err);
      }
    }

    //如果不是TaskBuilder的本地页面，则需要绑定组件的html元素
    //因为TaskBuilder的本地页面在渲染时已经绑定，不需要再绑定
    //而普通tfp页面的HTML代码是由服务器事先编译好的，需要在运行时绑定
    if (this.curPage.client != "tb") {
      //将组件id设置为全局变量并指向组件，以便在代码中访问
      window[cpt.id] = cpt;
      //如果是可视组件，则设置组件的jQuery对象
      if (!cpt.isInvisible) {
        if (cpt.type == "Page") {
          cpt._jqObj = $("body");
        } else {
          cpt._jqObj = $("#" + cpt.id);
        }
        if (cpt._jqObj.length > 0) cpt.el = cpt._jqObj[0];
      }
    }

    if (dataModel.components) {
      for (let i = 0; i < dataModel.components.length; i++) {
        let cdmChild = dataModel.components[i];
        this.parseCpt(cdmChild, cpt);
      }
    }
  }

  /**
   * 输入项值改变时
   * @param  {[type]} iptSrc [description]
   * @param  {[type]} col [description]
   * @param  {[type]} rowIndex [description]
   * @return {[type]}        [description]
   */
  iptValueOnChange(iptSrc, col, rowIndex) {
    //判断有没有组件设置了计算表达式并关联了当前组件
    if (!(!iptSrc.formulaIpts || iptSrc.formulaIpts.length == 0)) {
      for (let i = 0; i < iptSrc.formulaIpts.length; i++) {
        let iptF = this.components[iptSrc.formulaIpts[i]];
        if (!iptF) continue;
        //如果是关联的后台服务组件，则重新发起请求，并重载相关组件的数据
        if (iptF.type == "Service") {
          if (iptF.bindCpts && iptF.bindCpts.length > 0) {
            for (let j = 0; j < iptF.bindCpts.length; j++) {
              let cptBind = this.components[iptF.bindCpts[j]];
              if (!cptBind) continue;
              if (cptBind.loadData) cptBind.loadData();
            }
          } else if (iptF.dataModel.onResponse) {
            iptF.request();
          }
        } else {
          if (!iptF.dataModel.formula) continue;
          iptF.exeFormula();
        }
      }
    }

    // 运行校验规则
    this.runVerify(iptSrc);
    // 运行页面计算公式
    this.runFormulas(iptSrc, col, rowIndex);
    // 运行业务规则
    this.runRules(iptSrc);
  }

  /**
   * 初始化组件运行时
   * @param  {[type]} cpt [description]
   * @return {[type]}     [description]
   */
  initCptRuntime(cpt) {
    let that = this;

    if (cpt.dataModel["onBeforeInitRuntime"]) {
      let beforeinit = cpt.dataModel["onBeforeInitRuntime"];
      if (beforeinit.indexOf("()") > 0) beforeinit = beforeinit.replace("()", "");
      if (beforeinit.indexOf("(cb)") > 0) beforeinit = beforeinit.replace("(cb)", "");
      eval(beforeinit)(function (b) {
        if (b) {
          that.goonInitCptRuntime(cpt);
        }
      })
    }
    else {
      that.goonInitCptRuntime(cpt);
    }
  }

  goonInitCptRuntime(cpt) {
    //如果组件定义了初始化运行时的方法，则在此执行
    if (cpt["initRuntime"]) cpt.initRuntime();

    //如果组件设置了计算表达式，则在关联的组件控制器上注册事件钩子
    if (cpt.dataModel.formula) {
      let ipts = cpt.dataModel.formula.match(/\$\{[\w]+\}/g);
      for (let i = 0; i < ipts.length; i++) {
        let iptId = ipts[i].substr(2, ipts[i].length - 3);
        let cptMatched = this.components[iptId];
        if (!cptMatched) continue;
        if (!cptMatched.formulaIpts) cptMatched.formulaIpts = [];
        if (!cptMatched.formulaIpts.contains(cpt.id))
          cptMatched.formulaIpts.push(cpt.id);
      }
    }
    if (cpt.dataModel.components) {
      for (let i = 0; i < cpt.dataModel.components.length; i++) {
        let cdmChild = cpt.dataModel.components[i];
        this.initCptRuntime(this.components[cdmChild.id]);
      }
    }

    //如果组件设置了初始化完成的事件
    if (cpt.dataModel["onAfterInitRuntime"]) {
      try {
        eval(cpt.dataModel.onAfterInitRuntime);
      } catch (err) {
        console.log(err);
      }
    }
  }

  /**
   * 运行时解析页面
   * @param  {[type]} pageData [description]
   * @return {[type]}          [description]
   */
  parsePage(pageData) {
    //先解析所有组件并绑定其HTML元素
    this.parseCpt(pageData);
    //再执行各个组件的初始化
    //不能在解析组件时直接执行初始化
    //因为关联的组件可能还未解析，会导致初始化出错
    //例如Grid组件初始化时需要调用关联的Service组件
    //如果该Service组件未解析，则就会出错
    this.initCptRuntime(this.curPage);
  }

  /**
   * 设计时或编译时加载页面
   * @param  {[type]} pageData [description]
   * @return {[type]}          [description]
   */
  loadPage(pageData, cb) {
    if (!pageData) return;
    pageData.type = "Page";
    let that = this;
    this.isLoadingPage = true;
    this.components = {};

    this.loadComponents(pageData, function (categorys) {
      if (that.isDesigning) {
        if (that.designerType == "uiDesigner") {
          window.parent.uiDesigner.createCptLib(categorys, pageData);
        }
        else if (that.designerType == "formDesigner") {
          window.parent.formDesigner.createCptLib(categorys, pageData);
        }
      }

      //先解析当前页面都有哪些类型的组件
      let cptTypes = [];
      let userComponents = [];  //用户组件
      that.parseCptTypes(pageData, cptTypes, userComponents);
      //加载TFP页面通用CSS
      $("head").append("<link rel=\"stylesheet\" type=\"text/css\" href=\""
        + that.rootPath + "/src/tfp." + pageData.bgColorMode + ".css\"><\/link>");

      if (pageData.client == "mini") {
        $("head").append("<link rel=\"stylesheet\" type=\"text/css\" href=\""
          + that.rootPath + "/src/wxfpfont.css\"></link>");
        $("head").append("<link rel=\"stylesheet\" type=\"text/css\" href=\""
          + that.rootPath + "/src/wx.css\"></link>");
      }
      //然后动态加载这些组件的元数据和类
      importCptFiles(that, pageData, cptTypes, function () {
        //加载页面引用的CSS
        if (pageData.cssFiles) {
          let cssFiles = pageData.cssFiles;
          if (typeof (cssFiles) == "string") cssFiles = [cssFiles];
          for (let i = 0; i < cssFiles.length; i++) {
            let cssFilePath = cssFiles[i];
            if (that.isDesigning) cssFilePath = that.getUrlRealPath(cssFilePath);
            $("head").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + cssFilePath + "\"><\/link>");
          }
        }
        that.render(pageData);
        if (that.isDesigning) {
          if (that.designerType == "uiDesigner") {
            //如果有用户组件，需要异步加载组件编译后的html
            for (let i = 0; i < userComponents.length; i++) {
              window.parent.uiDesigner.renderTUC(userComponents[i]);
            }
            window.parent.uiDesigner.selectCpt(tfp.curPage.id);
          }
          else if (that.designerType == "formDesigner") {
            window.parent.formDesigner.selectCpt(tfp.curPage.id);
          }
        }
        that.isLoadingPage = false;
        if (cb) cb();
      });
    });
  }

  /**
   * 绑定输入项数据
   * @param  {[type]} cdm  [description]
   * @param  {[type]} data [description]
   * @return {[type]}      [description]
   */
  bindCptData(cdm, data) {
    var cpt = this.get(cdm.id);
    //判断组件的各个属性，如果属性值是字符串类型，且属性值中有{}或#[]，则进行数据绑定
    for (let attrId in cpt.dataModel) {
      if (attrId == "id" || attrId == "type" || attrId == "formula") continue;
      let attrVal = cpt.dataModel[attrId];
      if (attrVal && typeof (attrVal) == "string"
        && ((attrVal.indexOf("{") >= 0 && attrVal.indexOf("}") > 0)
          || (attrVal.indexOf("#[") >= 0 && attrVal.indexOf("]") > 0))) {
        let val = null;
        try {
          val = this.replaceDataField(data, attrVal);
          if (!isNull(val)) val = this.exeExpress(val);
        } catch (e) {
          console.log(e);
        }
        if (!isNull(val)) {
          //如果是数据绑定表达式，则设置组件的值
          if (attrId == "dataBindingFormat") {
            cpt.value = val;
          } else if (attrId == "class") {
            val = val + "";
            let arrClass = val.split(" ");
            for (let i = 0; i < arrClass.length; i++) {
              let strClass = arrClass[i];
              if (strClass.trim() == "") continue;
              cpt._jqObj.addClass(strClass.trim());
            }
          } else if (attrId == "style") {
            val = val + "";
            let arrStyles = val.split(";");
            for (let i = 0; i < arrStyles.length; i++) {
              let strStyle = arrStyles[i];
              if (strStyle.trim() == "" || strStyle.indexOf(":") < 0) continue;
              let arrStyle = strStyle.split(":");
              cpt._jqObj.css(arrStyle[0].trim(), arrStyle[1].trim());
            }
          } else if (attrId == "value") {
            cpt.value = val;
          } else {
            cpt.dataModel[attrId] = val;
            cpt[attrId] = val;
          }
        } else {
          cpt.dataModel[attrId] = "";
          cpt[attrId] = "";
        }
      }
    }
    if (cpt.dataModel.components) {
      for (var i = 0; i < cpt.dataModel.components.length; i++) {
        this.bindCptData(cpt.dataModel.components[i], data);
      }
    }
    //如果组件定义了绑定数据后的方法
    if (cpt["onAfterBindData"]) cpt.onAfterBindData(data);
  }

  /**
   * 获得组件类型定义信息（元数据）
   * @param  {[type]} typeName [description]
   * @return {[type]}          [description]
   */
  type(typeName) {
    return this.metaDatas[typeName];
  }

  type_combo(typeName) {
    return this.metaDatas_combo[typeName];
  }

  /**
   * 初始化组件设计时相关设置
   * 1、组件列表中添加组件节点
   * 2、为组件设置点击事件处理器
   * 3、禁止选中
   * 4、设置鼠标按下和经过事件处理器
   * @param  {[type]} cpt [description]
   * @return {[type]}     [description]
   */
  initCptDesignSetting(cpt) {
    if (window.parent.uiDesigner) {
      var node = window.parent.$("#cptTreeNode_" + cpt.id);
      if (node.length == 0) window.parent.uiDesigner.addCptTreeNode(cpt);

      cpt._jqObj.click(function () {
        if (cpt.isInvisible) {
          window.parent.uiDesigner.cptOnClick(window.parent.event, cpt.id);
        } else {
          window.parent.uiDesigner.cptOnClick(window.event, cpt.id);
        }
      });

      cpt._jqObj.bind('selectstart', function () { return false; });

      if (!cpt.isInvisible) {
        //鼠标按下时，准备移动组件
        cpt._jqObj.mousedown(function () {
          window.parent.uiDesigner.cptOnMouseDown(cpt, window.event);
        });

        cpt._jqObj.mouseover(function () {
          window.parent.uiDesigner.cptOnMouseOver(cpt, window.event);
        });
      }
    }
  }

  getRequestArgs(args, argsSettings) {
    if (!args || !argsSettings || argsSettings.length == 0) return;
    for (var i = 0; i < argsSettings.length; i++) {
      let arg = argsSettings[i];
      if (arg.type == "QueryString") {
        if (arg.value) {
          args[arg.name] = this.getUrlArg(arg.value);
        } else {
          args[arg.name] = this.getUrlArg(arg.name);
        }
      } else if (arg.type == "ComponentVal") {
        let cpt = null;
        let cptId = "";
        if (arg.value) {
          cptId = arg.value;
        } else {
          cptId = arg.name;
        }
        cpt = this.get(cptId);
        if (cpt) {
          args[arg.name] = cpt.value;
        } else if ($("#" + cptId).length > 0) {  //如果不是TFP组件，但是是HTML输入项，也可以获取值
          args[arg.name] = $("#" + cptId).val();
        }
        if (cpt) args[arg.name] = cpt.value;
      } else if (arg.type == "ComponentAttr") {
        if (arg.value && arg.value.indexOf(".") > 0) {
          let cptInfo = arg.value.split(".");
          let cpt = this.get(cptInfo[0]);
          if (cpt && cptInfo[1] != "") args[arg.name] = cpt[cptInfo[1]];
        }
      } else if (arg.type == "DialogArg") {
        let dialogArgs = this.getDialogArgs();
        if (typeof (dialogArgs) == "string") dialogArgs = JSON.parse(dialogArgs);
        if (dialogArgs) {
          if (arg.value) {
            args[arg.name] = dialogArgs[arg.value];
          } else {
            args[arg.name] = dialogArgs[arg.name];
          }
        }
      } else if (arg.type == "DrawerArg") {
        let drawerArgs = this.getCurDrawer().args;
        if (drawerArgs) {
          if (arg.value) {
            args[arg.name] = drawerArgs[arg.value];
          } else {
            args[arg.name] = drawerArgs[arg.name];
          }
        }
      } else if (arg.type == "Expression") {
        if (arg.value) {
          try {
            args[arg.name] = eval(arg.value);
          } catch (err) {
            console.log(err);
          }
        }
      } else {
        args[arg.name] = arg.value;
      }
    }
  }

  request(options, cb) {
    if (!options || !options.servicePath) {
      this.showMsg("请提供请求参数！");
      return;
    }
    var that = this;
    this.use("Service", function () {
      let service = that.new("Service");
      service.path = options.servicePath;
      if (options.autoReload) service.autoReload = true;
      if (options.autoShowError) service.autoShowError = true;
      if (options.showLoading) service.showLoading = true;

      if (options.encryptRequestArgs) service.encryptRequestArgs = options.encryptRequestArgs;
      if (options.encryptResponseArgs) service.encryptResponseArgs = options.encryptResponseArgs;

      if (options.argSettings && options.argSettings.length > 0) {
        service.argSettings = options.argSettings;
      }

      if (options.cptId) {
        let cpt = that.get(options.cptId);
        if (cpt) {
          //加载过一次数据后，将动态生成的后台服务组件绑定到组件上，以便实现请求参数变化时自动重载
          cpt.dataModel.loadDataService = service.id;
          //与后台服务组件建立绑定
          if (!service.bindCpts) service.bindCpts = [];
          if (!service.bindCpts.contains(options.cptId)) service.bindCpts.push(options.cptId);
        }
      }

      service.initRuntime();

      //如果组件禁用了自动加载，则只需要初始化Service对象，不需要实际请求数据
      if (options.disableAutoLoad) return;

      service.request(options.args, function (req, res) {
        if (cb) cb(req, res, service);
      });
    });
  }

  /**
   * 运行组件中的业务规则
   * @param {Object} cpt 组件对象
   */
  runRules(cpt) {
    if (!this.curPage.rulesDict) return;
    const rules = this.curPage.rulesDict[cpt.id];
    if (!rules || !Array.isArray(rules)) return;

    rules.forEach(rule => { this.runRule(cpt, rule); });
  }

  /**
   * 运行全部业务规则
   */
  runRuleAll() {
    const rules = this.curPage.dataModel.rules;
    rules.forEach(rule => {
      this.runRule(this.curPage, rule);
    });
  }

  /**
   * 运行业务规则
   * @param {Object} cpt  触发组件对象
   * @param {Object} rule 业务规则对象
   * @returns {Boolean} 是否执行成功
   */
  runRule(cpt, rule) {
    if (Object.prototype.toString.call(rule) !== '[object Object]') return throwErr(`业务规则参数错误。${rule.toString()}`);
    if (!rule.conditions || !Array.isArray(rule.conditions)) return throwErr(`业务规则中条件部分参数错误。${JSON.stringify(rule)}`);
    if (!rule.actions || !Array.isArray(rule.actions)) return throwErr(`业务规则中动作部分参数错误。${JSON.stringify(rule)}`);

    // 条件对象
    const conditions = rule.conditions;
    // 动作对象
    const actions = rule.actions;
    // 运行条件
    let success = true;
    // 条件语句
    var conditionEvalJs = '';
    // 正则，去除${}
    const offMarkReg = /\$\{(.*?)\}/g;

    // 执行条件
    conditions.forEach(function (condition, i) {
      if (i != 0) conditionEvalJs += condition.logic;

      if (condition.control) {
        conditionEvalJs += `${condition.control.replace(offMarkReg, '$1')}.value`;
      } else return false;

      if (condition.operator) conditionEvalJs += condition.operator;
      else return false;

      if (condition.valueType == 'fixed') conditionEvalJs += `'${condition.value}'`;

      if (condition.valueType == 'control' && condition.value) {
        conditionEvalJs += `${condition.value.replace(offMarkReg, '$1')}.value`;
      } else return false;
    });

    // 执行条件语句
    if (conditionEvalJs) success = executeJs(conditionEvalJs, `执行条件部分错误：${conditionEvalJs}`);
    // 如果条件不正确直接返回
    if (!success) return false;

    // 运行动作
    actions.forEach(function (action, i) {
      if (!action.type) return false;
      if (action.type == 'custom' && action.evalJs) executeJs(action.evalJs, `执行动作部分错误：${action.evalJs}`);
      else if (Array.isArray(action.controls)) {
        action.controls.forEach(function (control, i) {
          control = control.replace(offMarkReg, '$1');
          let actionEvalJs = '';
          switch (action.type) {
            case 'show':
              actionEvalJs = `if(typeof ${control}.show == 'function') ${control}.show()`;
              break;
            case 'hide':
              actionEvalJs = `if(typeof ${control}.hide == 'function') ${control}.hide()`;
              break;
            case 'readonly':
              actionEvalJs = `if(${control}.readonly != undefined) ${control}.readonly = true`;
              break;
            case 'unreadonly':
              actionEvalJs = `if(${control}.readonly != undefined) ${control}.readonly = false`;
              break;
            case 'required':
              actionEvalJs = `if(${control}.required != undefined) ${control}.required = true`;
              break;
            case 'unrequired':
              actionEvalJs = `if(${control}.required != undefined) ${control}.required = false`;
              break;
            default:
              break;
          }
          executeJs(actionEvalJs, `执行动作部分错误：${actionEvalJs}`);
        });
      }
    });

    return true;

    // 执行js
    function executeJs(evalJs, msg) {
      try {
        return eval(evalJs);
      } catch (error) {
        throwErr(msg || evalJs);
      }
    }

    // 抛出异常
    function throwErr(msg) {
      throw new Error(msg);
    }
  }

  /**
   * 运行组件中的计算公式
   * @param {Object} cpt 组件对象
   * @param {Object} col 可编辑表格列对象
   * @param {Number} [rowIndex] 行数
   * @returns 
   */
  runFormulas(cpt, col, rowIndex) {
    const formulasDict = this.curPage.formulasDict;
    if (!formulasDict || !formulasDict[cpt.id]) return;
    let formulas = null;
    if (cpt.type == 'DataSet') formulas = formulasDict[cpt.id][col.id];
    else formulas = formulasDict[cpt.id];
    if (!formulas || !Array.isArray(formulas)) return;
    formulas.forEach(formula => { this.runFormula(cpt, formula, rowIndex) });
  }

  /**
   * 运行全部计算公式
   */
  runFormulaAll() {
    const formulas = this.curPage.dataModel.formulas;
    formulas.forEach(formula => {
      this.runFormula(this.curPage, formula, null);
    });
  }

  /**
   * 运行计算公式
   * @param {Object} cpt 触发组件对象
   * @param {Object} formulaObj 计算公式对象
   * @param {Number} rowIndex 行数
   * @returns {Boolean} 是否执行成功
   */
  runFormula(cpt, formulaObj, rowIndex) {
    if (Object.prototype.toString.call(formulaObj) !== '[object Object]') return throwErr(`公式参数错误。${formulaObj.toString()}`);
    if (!formulaObj.conditions || !Array.isArray(formulaObj.conditions)) return throwErr(`公式中条件部分参数错误。${JSON.stringify(formulaObj)}`);
    if (!formulaObj.actions || !Array.isArray(formulaObj.actions)) return throwErr(`公式中动作部分参数错误。${JSON.stringify(formulaObj)}`);
    // 组件组
    const components = this.components;
    // 条件对象
    const conditions = formulaObj.conditions;
    // 动作对象
    const actions = formulaObj.actions;
    // 运行条件
    let success = true;
    // 条件语句
    let conditionEvalJs = '';
    // 公式中出现的子表id，判断是否跨表时使用
    let datasetCptId = null;
    // 正则，去除${}
    const offMarkReg = /\$\{(.*?)\}/g;

    // 执行条件
    conditions.forEach((condition, i) => {
      if (
        !condition.control ||
        !condition.operator ||
        (condition.valueType == 'control' && !condition.value)
      ) return false;
      let { logic, control, operator, valueType, value } = condition;

      // 修改各参数为可执行的语句
      logic = i == 0 ? '' : (' ' + (condition.logic || '&&'));

      const [dataset, field] = getDatasetAndField(condition.control);
      if (field) control = `${dataset}.getRowData(${rowIndex}).row['${field}']`;
      else control = `${dataset}.value`;

      if (valueType == 'control') {
        const [dataset, field] = getDatasetAndField(value);
        if (field) value = `${dataset}.getRowData(${rowIndex}).row['${field}']`;
        else value = `${dataset}.value`;
      }
      else value = `'${value}'`;

      conditionEvalJs += [logic, control, operator, value].join(' ');
    });

    // 执行条件语句
    if (conditionEvalJs) success = executeJs(conditionEvalJs, `执行条件部分错误：${conditionEvalJs}`);
    // 如果条件不正确直接返回
    if (!success) return false;

    // 轮询动作条件
    actions.forEach((action, i) => {
      if (!action.control || !action.formula) return false;
      let { control, formula } = action;

      const fControls = formula.match(offMarkReg);
      (fControls || []).forEach(fControl => {
        const [dataset, field] = getDatasetAndField(fControl);
        let getDataEvalJs = '';
        if (field) getDataEvalJs = `${dataset}.getRowData(${rowIndex}).row['${field}']`;
        else getDataEvalJs = `${dataset}.value`;
        formula = formula.replaceAll(fControl, parseNumber(executeJs(getDataEvalJs, `执行获取数据时错误：${getDataEvalJs}`)));
      });

      const value = parseNumber(executeJs(formula, `执行公式部分错误：${action.formula}`));

      let assignEvalJs = '';
      const [dataset, field] = getDatasetAndField(control);
      if (field) {
        // 如果触发组件为不可编辑表格中的组件，则循环计算赋值组件所在可编辑表格
        if (cpt.dataModel.type != 'DataSet') {
          components[dataset].getRowsData(null, rows => {
            rows.forEach((row, index) => { this.runFormula(components[dataset], formulaObj, index); });
          });
        }
        else {
          assignEvalJs = `${dataset}.getRowData(${rowIndex}).row`;
          const rowData = executeJs(assignEvalJs, `执行获取行数据时错误：${dataset}`);
          rowData[field] = value;
          assignEvalJs = `${dataset}.setRowData(${rowIndex}, JSON.parse('${JSON.stringify(rowData)}'))`;
        }
      }
      else assignEvalJs = `${dataset}.value = ${value}`;

      executeJs(assignEvalJs, `执行公式赋值错误：${action.formula}`);
    });

    return true;

    // 获取组件及其字段，${}中带.为子表组件
    function getDatasetAndField(str) {
      str = str.replace(offMarkReg, '$1');
      const [dataset, field] = str.split('.');
      if (!components[dataset]) throwErr(`执行公式时组件不存在：${dataset}`);
      if (field) {
        if (!datasetCptId) datasetCptId = dataset;
        if (datasetCptId != dataset) throwErr(`公式中不允许出现不同子表的组件：${dataset}`);
        return [dataset, field];
      }
      else return [dataset, null];
    }

    // 转换为number类型的数据
    function parseNumber(str) {
      const temp = parseFloat(str);
      if (isNaN(temp)) return 0;
      else return temp;
    }

    // 执行js
    function executeJs(evalJs, msg) {
      try {
        return eval(evalJs);
      } catch (error) {
        throwErr(msg || evalJs);
      }
    }

    // 抛出异常
    function throwErr(msg) {
      throw new Error(msg);
    }
  }

  /**
   * 运行校验规则
   * @param {Object} cpt 触发组件对象
   * @returns {Boolean} 是否执行成功
   */
  runVerify(cpt) {
    const type = cpt.dataModel.type;
    let verifyObj = cpt.dataModel.verify;

    // 文本验证
    if (['Text', 'TextArea'].includes(type)) {
      let { verify, verifyMsg } = verifyObj || {};

      if (cpt.dataModel.dataType == 'text' && cpt.dataModel.subDataType) {
        switch (cpt.dataModel.subDataType) {
          case 'phone':
            verify = '^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\\d{8}$';
            verifyMsg = `请输入手机号`;
            break;
          case 'telephone':
            verify = '^(\\(\\d{3,4}\\)|\\d{3,4}-)?\\d{7,8}$';
            verifyMsg = `请输入座机号`;
            break;
          case 'postalCode':
            verify = '^(0[1-7]|1[0-356]|2[0-7]|3[0-6]|4[0-7]|5[1-7]|6[1-7]|7[0-5]|8[013-6])\\d{4}$';
            verifyMsg = `请输入邮政编码`;
            break;
          case 'idCard':
            verify = '(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$)';
            verifyMsg = `请输入身份证`;
            break;
          case 'email':
            verify = '^([A-Za-z0-9_\\-\\.])+\\@([A-Za-z0-9_\\-\\.])+\\.([A-Za-z]{2,4})$';
            verifyMsg = `请输入邮箱`;
            break;
          case 'licensePlate':
            verify = '^[京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领 A-Z]{1}[A-HJ-NP-Z]{1}[A-Z0-9]{4}[A-Z0-9挂学警港澳]{1}$';
            verifyMsg = `请输入车牌号`;
            break;
        }
      }
      if (verify && verifyMsg) {
        const reg = new RegExp(verify);
        if (!cpt.value || reg.test(cpt.value)) this.hideBubble(cpt, { changeBorder: false });
        else {
          if (cpt.focus) cpt.focus();
          return this.showBubble(cpt, verifyMsg, { changeBorder: false });
        }
      }
    }

    // // 时间验证
    // if (['Date', 'DateTime', 'Time'].includes(type)) {
    //   if (!verifyObj) return false;
    // }

    return true;
  }

  /**
   * 显示气泡框
   * @param {Object} cpt 触发组件对象
   * @param {String} msg 显示提示
   * @param {Object} [option] 配置
   * @param {Boolean} option.changeBorder 改变表框为红色
   * @returns {false} 
   */
  showBubble(cpt, msg, option = {}) {
    const bubbleId = 'tb-bubble-' + cpt.dataModel.id;
    const jqObj = cpt._jqObj;
    const el = jqObj[0];

    // 找到上一个浮动元素
    const parentEl = $(el.offsetParent);
    if (parentEl.css('position') == 'static' || !parentEl.css('position')) parentEl.css('position', 'relative');
    if ($('#' + bubbleId).length > 0) $('#' + bubbleId).remove();
    // 创建提示框元素
    const bubble = $('<div>', { 'id': bubbleId, 'class': 'tb-bubble' }).html(msg);
    // 将元素先添加到body中用于计算宽度
    $('body').append(bubble.css('top', '-10000px').show());
    // 计算出提示框元素应在的位置
    const bubblePos = [el.offsetTop - 40, el.offsetLeft + el.offsetWidth - bubble[0].offsetWidth];
    if (bubblePos[0] < 0) {
      bubblePos[0] += (jqObj.height() + 55);
      bubble.attr('data-postion', 'bottom');
    }
    bubble.css({
      'top': bubblePos[0] + 'px',
      'left': bubblePos[1] + 'px',
    }).hide();
    // 将提示框渐显
    parentEl.append(bubble.fadeIn(300, 'linear'));
    // 设置提示框定时关闭
    setTimeout(function () {
      bubble.fadeOut(300, 'linear', function () { $(this).remove(); });
    }, 2000);

    // 将文本控件添加红色边框
    if (option.changeBorder && !el.dataset.inputerror) {
      jqObj.attr('data-bordercolor', jqObj.css('border-color'));
      jqObj.css('border-color', '#f56c6c');
    }

    jqObj.attr('data-inputerror', 'true');
    return false;
  }

  /**
   * 隐藏气泡框
   * @param {Object} cpt 触发组件对象
   * @param {Object} [option] 配置
   * @param {Boolean} option.changeBorder 改变表框为红色
   * @returns {true} 
   */
  hideBubble(cpt, option = {}) {
    const bubbleId = 'tb-bubble-' + cpt.dataModel.id;
    const jqObj = cpt._jqObj;
    const el = jqObj[0];

    // 删除气泡框
    if ($('#' + bubbleId).length > 0) $('#' + bubbleId).remove();

    // 删除控件红色边框
    if (option.changeBorder && el.dataset.inputerror) {
      jqObj.css('border-color', el.dataset.bordercolor).removeAttr('data-bordercolor');
    }

    jqObj.removeAttr('data-inputerror');
    return true;
  }

  /**
   * 动态加载JS
   * @param {string} url 脚本地址
   * @param {function} callback  回调函数
   */
  dynamicLoadJs(url, callback) {
    var head = document.getElementsByTagName('head')[0];
    var script = document.createElement('script');
    script.type = 'text/javascript';
    script.src = url;
    if (typeof (callback) == 'function') {
      script.onload = script.onreadystatechange = function () {
        if (!this.readyState || this.readyState === "loaded" || this.readyState === "complete") {
          callback();
          script.onload = script.onreadystatechange = null;
        }
      };
    }
    head.appendChild(script);
  }

  /**
    * 动态加载CSS
    * @param {string} url 样式地址
    */
  dynamicLoadCss(url) {
    var head = document.getElementsByTagName('head')[0];
    var link = document.createElement('link');
    link.type = 'text/css';
    link.rel = 'stylesheet';
    link.href = url;
    head.appendChild(link);
  }

  /**
   * 设置更多菜单
   * @param {String} text 按钮
   * @param {String} jsStatement 运行脚本
   * @example
   * tfp.setToolBtnMobile('按钮''test()');
   */
  setToolBtnMobile(text, jsStatement) {
    (top.tmClient || tmClient).setMoreMenu([{ text, jsStatement }]);
  }

  /**
   * 设置更多菜单
   * @param {Object[]} menuInfo 菜单列表
   * @param {String} menuInfo[].text 按钮
   * @param {String} menuInfo[].jsStatement 运行脚本
   * @example
   * tfp.setMoreMenuMobile([{'text':'按钮', 'jsStatement':'test()'}]);
   */
  setMoreMenuMobile(menu) {
    (top.tmClient || tmClient).setMoreMenu(menu);
  }

  /**
   * 设置窗口标题
   * @param {String} title 标题
   * @example
   * tfp.setTitleMobile('标题');
   */
  setTitleMobile(title) {
    (top.tmClient || tmClient).setTitle(title || '');
  }

  /**
   * 设置组件设置缓存
   * @param {*} key 
   * @param {*} value 
   */
  setCptSettingCache(cptId, settingName, value) {
    try {
      if (top.curUser) {
        let fullPath = top.curUser.orgId + "/" + top.curUser.id + location.pathname + "/" + cptId + "/" + settingName;
        let val = value;
        if (this.isNull(val)) val = "";
        if (typeof (val) == "object" || Array.isArray(val)) val = JSON.stringify(val);
        localStorage.setItem(fullPath, val);
      }
    } catch (err) {
      console.log(err);
    }
  }

  /**
   * 获得组件设置缓存
   * @param {*} key 
   * @param {*} value 
   */
  getCptSettingCache(cptId, settingName) {
    try {
      if (top.curUser) {
        let fullPath = top.curUser.orgId + "/" + top.curUser.id + location.pathname + "/" + cptId + "/" + settingName;
        return localStorage.getItem(fullPath);
      }
    } catch (err) {
      console.log(err);
    }
    return null;
  }

  /**
   * 添加JS文件的引用
   * @param {*} filePath 
   */
  includeJsFile(filePath, cb) {
    importJsFile(filePath)
      .then(() => {
        if (cb) cb();
      })
      .catch((err) => {
        if (cb) cb(err);
      });
  }
}