/**
 * 动态引用js文件
 * @param  {[type]} url [description]
 * @return {[type]}     [description]
 */
function importJsFile(url) {
	return new Promise((resolve, reject) => {
		var script = document.createElement("script");
		script.type = "text/javascript";
		if (script.readyState) {
			script.onreadystatechange = function () {
				if (script.readyState == "loaded" || script.readyState == "complete") {
					script.onreadystatechange = null;
					resolve();
				}
			};
		} else {
			script.onload = function () {
				resolve();
			};
		}
		script.src = url;
		document.body.appendChild(script);
	});
}

/**
 * 动态引入CSS文件
 * @param {*} filePath 
 * @returns 
 */
function importCssFile(filePath) {
	return new Promise((resolve, reject) => {
		var xhr = new XMLHttpRequest();
		xhr.onreadystatechange = function () {
			if (xhr.readyState === 4 && xhr.status === 200) {
				var style = document.createElement("style");
				style.type = "text/css";
				style.innerHTML = xhr.responseText;
				style.setAttribute("filePath", filePath);
				document.head.appendChild(style);
				resolve();
			}
		};
		xhr.open("GET", filePath, true);
		xhr.send();
	});
}

/**
 * 获得需要导入的组件类型
 * @return {[type]} [description]
 */
function getNeedImportCptType(tfp, cptTypeName, needImportCptTypes) {
	let metadata = tfp.metaDatas[cptTypeName];
	if (!metadata) return;

	//如果有依赖项，则需要优先加载
	let dependencies = [];
	if (metadata.dependencies) {
		if (typeof (metadata.dependencies) == "string") {
			dependencies.push(metadata.dependencies);
		} else if (Array.isArray(metadata.dependencies)) {
			dependencies.push.apply(dependencies, metadata.dependencies);
		}
	}
	if (dependencies.length > 0) {
		for (let i = 0; i < dependencies.length; i++) {
			getNeedImportCptType(tfp, dependencies[i], needImportCptTypes);
		}
	}

	if (!needImportCptTypes.includes(cptTypeName)) needImportCptTypes.push(cptTypeName);
}

/**
 * 添加组件相关文件的引用
 * @param  {[type]}   tfp           [description]
 * @param  {[type]}   pageDataModel [description]
 * @param  {[type]}   cptTypes      [description]
 * @param  {Function} cb            [description]
 * @return {[type]}                 [description]
 */
async function importCptFiles(tfp, pageDataModel, cptTypes, cb) {
	//获得所有需要导入的组件类型，包括相关依赖组件
	let needImportCptTypes = [];
	for (let i = 0; i < cptTypes.length; i++) {
		getNeedImportCptType(tfp, cptTypes[i], needImportCptTypes);
	}

	for (let i = 0; i < needImportCptTypes.length; i++) {
		let cptTypeName = needImportCptTypes[i];
		let metadata = tfp.metaDatas[cptTypeName];
		if (!metadata) continue;
		let metadataFile = "./components/" + cptTypeName.toLowerCase() + "/metadata";
		let controllerFile = "./components/" + cptTypeName.toLowerCase() + "/controller";
		let renderFile = "./components/" + cptTypeName.toLowerCase() + "/render";
		let clientType = pageDataModel.client;
		if (clientType == "tb") clientType = "pc";
		if (!metadata.matchAllClient) {
			if (clientType == "pc" && pageDataModel.pageType == "print-report"
				&& (cptTypeName == "Page" || cptTypeName == "GridView")) {
				metadataFile += ".print";
			} else {
				metadataFile += "." + clientType;
			}
			controllerFile += "." + clientType;
			renderFile += "." + clientType;
		}
		metadataFile += ".js";
		controllerFile += ".js";
		renderFile += ".js";
		if (!metadata.isLoaded) {
			let matchAllClient = metadata.matchAllClient;
			let isInvisible = metadata.isInvisible;
			let dependencies = null;
			if (metadata.dependencies) dependencies = metadata.dependencies;
			let metaModule = await import(metadataFile);

			metadata = metaModule.default;
			metadata.isLoaded = true;
			if (matchAllClient) metadata.matchAllClient = matchAllClient;
			if (isInvisible) metadata.isInvisible = isInvisible;
			if (dependencies) metadata.dependencies = dependencies;
			tfp.metaDatas[cptTypeName] = metadata;
		}
		if (!tfp.controllers[cptTypeName]) {
			let controllerModule = await import(controllerFile);
			tfp.controllers[cptTypeName] = controllerModule.default;
		}
		if (!tfp.renders[cptTypeName]) {
			let renderModule = await import(renderFile);
			tfp.renders[cptTypeName] = renderModule.default;
		}
		if (typeof (window) != "undefined") {
			let tfpPath = tfp.rootPath + "/src/components/";
			if (!tfp.isDesigning) {
				let cssFiles = [];
				if (metadata.cssFiles) {
					if (typeof (metadata.cssFiles) == "string") {
						cssFiles = [metadata.cssFiles];
					} else if (Array.isArray(metadata.cssFiles)) {
						cssFiles = metadata.cssFiles;
					}
				}
				let bgColorMode = "light";
				if (pageDataModel.bgColorMode == "dark") bgColorMode = "dark";
				for (let j = 0; j < cssFiles.length; j++) {
					let styleFile = cssFiles[j];
					if (styleFile.onlyRuntime) {
						if (tfp.isDesigning || pageDataModel.client == "tb") continue;
						styleFile = styleFile.src;
					}
					if (styleFile.onlyDesigning) {
						if (tfp.isRuntime && pageDataModel.client != "tb") continue;
						styleFile = styleFile.src;
					}
					styleFile = styleFile.replace("{client}", clientType);
					styleFile = styleFile.replace("{bgColorMode}", bgColorMode);
					styleFile = tfp.getCptIncludeFile(styleFile, cptTypeName, pageDataModel);
					if ($("style[filePath='" + styleFile + "']").length == 0) {
						await importCssFile(styleFile);
					}
					/*
					下面这种加载CSS文件的方式，如果CSS文件比较大，则会出现组件拖拽到页面上时出现变形，因为CSS文件还没加载完
					if ($("link[href='" + styleFile + "']").length == 0) {
						if (styleFile.endsWith(".less")) {
							$("head").append("<link href=\"" + styleFile + "\" rel=\"stylesheet/less\" type=\"text/css\" />");
						} else {
							$("head").append("<link href=\"" + styleFile + "\" rel=\"stylesheet\" type=\"text/css\" />");
						}
					}*/
				}
			}
			let jsFiles = [];
			if (metadata.jsFiles) {
				if (typeof (metadata.jsFiles) == "string") {
					jsFiles = [metadata.jsFiles];
				} else if (Array.isArray(metadata.jsFiles)) {
					jsFiles = metadata.jsFiles;
				}
			}
			for (let j = 0; j < jsFiles.length; j++) {
				let jsFile = jsFiles[j];
				if (jsFile.onlyRuntime) {
					if (tfp.isDesigning || pageDataModel.client == "tb") continue;
					jsFile = jsFile.src;
				}
				if (jsFile.onlyDesigning) {
					if (tfp.isRuntime && pageDataModel.client != "tb") continue;
					jsFile = jsFile.src;
				}
				jsFile = tfp.getCptIncludeFile(jsFile, cptTypeName, pageDataModel);
				if ($("script[src='" + jsFile + "']").length == 0) {
					await importJsFile(jsFile);
				}
			}
		}
	}
	if (cb) cb();
}

