import TFPComponentRender from '../render.js'

export default class WxParseRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html += indent;
    if (this.dataModel.wxParseContent) {
      html += this.dataModel.wxParseContent;
    }
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "";
    bodyHtml += `<import src="../../utils/wxParse/wxParse.wxml" />
        <template is="wxParse" data="{{wxParseData:`+ this.dataModel.id + `_courseDetail.nodes}}" />\r\n`;
    cpt_wx.wxml = bodyHtml + indent;
    cpt_wx.wxjs += `
`+ this.dataModel.id + `_endThis() {
  this.`+ this.dataModel.id + `_toWxParse(this.data.` + this.dataModel.id + `_content);
},
  /**
   * WxParse.wxParse(bindName , type, data, target,imagePadding)
   * 1.bindName绑定的数据名(必填)
   * 2.type可以为html或者md(必填)
   * 3.data为传入的具体数据(必填)
   * 4.target为Page对象,一般为this(必填)
   * 5.imagePadding为当图片自适应是左右的单一padding(默认为0,可选)
   */
  `+ this.dataModel.id + `_toWxParse(content) {
    var that = this;
    var article = content;
    const WxParse =  require('../../utils/wxParse/wxParse.js')
    WxParse.wxParse('`+ this.dataModel.id + `_courseDetail', 'html', article, that, 0);
  },\r`;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}