import { VisibleComponent } from "../controller.js";

/**
 * 富文本展组件
 * @param {[type]} dataModel [description]
 */
export default class WxParse extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "WxParse", dataModel, parent);
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get wxParseData() { return this.dataModel.wxParseData }
  set wxParseData(value) { this.dataModel.wxParseData = value }

  //富文本内容
  get wxParseContent() { return this.dataModel.wxParseContent }
  set wxParseContent(value) {
    this.dataModel.wxParseContent = value;
    if (this._jqObj) {
      if(!this.dataModel.loadDataService){
        this._jqObj.html(value);
      }
    }
  }

  loadData() {
    if (!this.dataModel.loadDataService) {
      alert("请为[" + this.id + "]设置加载数据服务！");
      return;
    }
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if (!serviceCpt) {
      alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
      return;
    }
    if (!this.dataModel.dataBindingMember) {
      alert("请为[" + this.id + "]设置数据绑定成员！");
      return;
    }
    if (!this.dataModel.wxParseData) {
      alert("请为[" + this.id + "]设置富文本绑定字段！");
      return;
    }

    let that = this;
    serviceCpt.request(null, function (req, res) {
      var data = res[that.dataModel.dataBindingMember];
      that.bindData(data);
    });
  }

  initRuntime() {
    if (this.dataModel.loadDataService) {
      this.loadData();
    } else {
      if (this._jqObj) {
        this._jqObj.empty();
      }
    }
  }

  

}