import FileUploadRender from '../fileupload/render.js'

export default class VideoUploadRender extends FileUploadRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html += indent + `\r\n<div class="wx-panel" style="width: 100%;padding-left: 1%;padding-top: 1%;cursor: pointer;display: flex;align-items: center;flex-wrap: wrap;">`
    html += `
      <div class="video_box addvideo_box" style="width: `+ this.dataModel.videoWidth + `%;height: ` + this.dataModel.videoHeight + `px;display:` + (this.dataModel.allowAdd ? 'none' : 'flex') + `;align-items: center;justify-content: center;margin-bottom: 1%;background: #F7F7F7;margin-right: 1%;">
        <view class="wx-videoupload-add"></view>
      </div>
      <div class="video_box delvideo_box" style="width: `+ this.dataModel.videoWidth + `%;height:` + this.dataModel.videoHeight + `px;display:` + (this.dataModel.allowAdd ? 'none' : 'flex') + `;
      align-items: center;justify-content: center;margin-bottom: 1%;background: #F7F7F7;margin-right: 1%;">
        <view class="wx-videoupload-minus"></view>
      </div>`;
    html += `
    </div>`;
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var vid = escape(this.dataModel.id).replaceAll("%", "");
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "";
    bodyHtml += `  <view class="wx-videoupload-outbox" style="padding:` + this.dataModel.videoMargin + `% ` + this.dataModel.videoMargin + `% 0 0;background:white;">
      <view class="wx-videoupload-innerbox" style="width:`+ this.dataModel.videoWidth + `%;height:` + this.dataModel.videoHeight * 2 + `rpx;margin-left:` + this.dataModel.videoMargin + `%;margin-bottom:` + this.dataModel.videoMargin + `%;" wx:for="{{` + vid + `_uploadVideoList}}" wx:for-item="items" wx:key="id">
        <view class="wx-videoupload-videobox" style="height:`+ this.dataModel.videoHeight * 2 + `rpx;">
          <video src="{{items.src}}" id="`+ vid + `_myVideo{{index}}"	show-fullscreen-btn="{{false}}" object-fit="cover"></video>
        </view>`;
    if (!this.dataModel.allowDelete) {
      bodyHtml += `
        <view class="wx-videoupload-closebox" bindtap="bindclick_delFile" data-index="{{index}}" wx:if="{{` + vid + `_showUploadDel}}" data-array="` + vid + `_uploadVideoList" data-type="video">
          <view>
            <view class="wx-videoupload-delete"></view>
          </view>
        </view>`;
    }
    bodyHtml += `\n</view>\n`;
    if (!this.dataModel.allowAdd) {
      bodyHtml += `<view class="wx-videoupload-innerbox" style="width:` + this.dataModel.videoWidth + `%;height:` + this.dataModel.videoHeight * 2 + `rpx;margin-left:` + this.dataModel.videoMargin + `%;margin-bottom:` + this.dataModel.videoMargin + `%;">
      <view class="wx-videoupload-imagebox" style="height:`+ this.dataModel.videoHeight * 2 + `rpx;" bindtap="bindclick_uploadFile" data-type="video" data-array="` + vid + `_uploadVideoList" data-number="` + this.dataModel.size + `" data-appCode="` + this.dataModel.appCode + `">
        <view class="wx-videoupload-add"></view>
      </view>
    </view>`;
    }
    if (!this.dataModel.allowDelete) {
      bodyHtml += `<view wx:if="{{`+ vid +`_uploadVideoList.length>0}}" class="wx-videoupload-innerbox" style="width:` + this.dataModel.videoWidth + `%;height:` + this.dataModel.videoHeight * 2 + `rpx;margin-left:` + this.dataModel.videoMargin + `%;margin-bottom:` + this.dataModel.videoMargin + `%;" bindtap="bindclick_switchDel" data-type="video" data-array="` + vid + `_uploadVideoList" data-delname="` + vid + `_showUploadDel">
      <view class="wx-videoupload-imagebox" style="height:`+ this.dataModel.videoHeight * 2 + `rpx;">
        <view class="wx-videoupload-minus"></view>
      </view>
    </view>`;
    }
    bodyHtml += `</view>\r`;
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}