export default {
  "name": "VideoUpload",
  "comment": "视频上传",
  "attrs": [
    {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    },
    {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    },
    {
      "name": "appCode",
      "comment": "应用代码",
      "type": "String"
    },
    {
      "name": "appDataId",
      "comment": "应用数据ID",
      "type": "String"
    },
    {
      "name": "onlyOne",
      "comment": "保持唯一",
      "type": "Switch"
    },
    {
      "name": "size",
      "comment": "文件总数",
      "type": "Number",
      "default": 5
    },
    {
      "name": "videoWidth",
      "comment": "视频宽度(%)",
      "type": "Select",
      "options": [
        {
          "value": "24",
          "text": "1/4"
        },
        {
          "value": "32",
          "text": "1/3"
        },
        {
          "value": "49",
          "text": "1/2"
        },
        {
          "value": "99",
          "text": "1"
        }
      ],
      "default": "32",
    },
    {
      "name": "videoHeight",
      "comment": "视频高度(px)",
      "type": "Number",
      "required": true,
      "default": "115"
    },
    {
      "name": "videoMargin",
      "comment": "视频边距(%)",
      "type": "Number",
      "required": true,
      "default": "1"
    },
    {
      "name": "allowDelete",
      "comment": "隐藏删除",
      "type": "Switch",
      "default": false
    },
    {
      "name": "allowAdd",
      "comment": "隐藏添加",
      "type": "Switch",
      "default": false
    }
  ],
  "defaultStyles": {
    "background": "white",
    "min-height":'90px'
  },
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "events": [
    {
      "name": "bindchange",
      "args": [{ 'name': 'e' }],
      "eventArgs": "",
      "comment": "值发生变化时"
    },{
      "name": "onBeforeUpload",
      "comment": "上传前",
      "isNotHtmlEvent": true
    }, {
      "name": "onAfterUpload",
      "comment": "上传后",
      "isNotHtmlEvent": true
    }]
}