import FileUpload from "../fileupload/controller.js";

/**
 * 视频上传组件
 * @param {[type]} dataModel [description]
 */
export default class VideoUpload extends FileUpload {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, dataModel, parent, "VideoUpload");
  }

  //保持唯一
  get onlyOne() { return this.dataModel.onlyOne }
  set onlyOne(value) {
    this.dataModel.onlyOne = value;
    this.dataModel.size = 1;
    if(this._tfp.isDesigning && this.dataModel.onlyOne) {
      uiDesigner.setCurCptAttrSettingVal("size", "1");
    }
  }

  //是否只读
  get readonly() { return this.dataModel.readonly }
  set readonly(value) {
    this.dataModel.readonly = value ? true : false;
    if(!this.dataModel.readonly) delete this.dataModel.readonly;
  }

  // 视频宽度
  get videoWidth() { return this.dataModel.videoWidth }
  set videoWidth(value) { 
    this.dataModel.videoWidth = value;
    if(this._jqObj) {
      if(value == '24'){
        this._jqObj.find(".video_box").css("height", "90px");
        this.dataModel.videoHeight = 90;
      }else  if(value == '32'){
        this._jqObj.find(".video_box").css("height", "115px");
        this.dataModel.videoHeight = 115;
      }else  if(value == '49'){
        this._jqObj.find(".video_box").css("height", "175px");
        this.dataModel.videoHeight = 175;
      }else  if(value == '99'){
        this._jqObj.find(".video_box").css("height", "175px");
        this.dataModel.videoHeight = 175;
      }
      this._jqObj.find(".video_box").css("width", value+"%");
    }
  }

  // 视频高度
  get videoHeight() { return this.dataModel.videoHeight }
  set videoHeight(value) { 
    this.dataModel.videoHeight = value;
    if(this._jqObj) {
      this._jqObj.find(".video_box").css("height", value+"px");
    }
  }

  // 视频边距
  get videoMargin() { return this.dataModel.videoMargin }
  set videoMargin(value) { 
    this.dataModel.videoMargin = value;
    if(this._jqObj) {
      this._jqObj.find(".video_box").css("margin-bottom", value+"%");
      this._jqObj.find(".video_box").css("margin-right", value+"%");
    }
  }

  // 隐藏允许删除
  get allowDelete() { return this.dataModel.allowDelete }
  set allowDelete(value) { 
    this.dataModel.allowDelete = value;
    if(this._jqObj) {
      if(value){
        this._jqObj.find(".video_box.delvideo_box").css("display", 'none');
      }else{
        this._jqObj.find(".video_box.delvideo_box").css("display", 'flex');
      }
    }
  }

  // 隐藏允许添加
  get allowAdd() { return this.dataModel.allowAdd }
  set allowAdd(value) {
    this.dataModel.allowAdd = value;
    if (this._jqObj) {
      if (value) {
        this._jqObj.find(".video_box.addvideo_box").css("display", 'none');
      } else {
        this._jqObj.find(".video_box.addvideo_box").css("display", 'flex');
      }
    }
  }

  initRuntime() {
    let that = this;
    that.dataModel.videoWidth = '32';
  }
}