import TFPComponentRender from '../render.js'

export default class VideoCodeRender extends TFPComponentRender {
  // 生成组件HTML

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }
  
  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html += indent + "<video  src=\"" + this.dataModel.src + "\"";
    html += " width=\""+this.dataModel.width+"%\"";
    html += " height=\""+this.dataModel.height+"px\"";
    html += "style=\" object-fit:cover;\"";
    if (this.dataModel.controls == true) {
      html += " controls=\"{{" + this.dataModel.controls + "}}\"";
    }
    if (this.dataModel.loop == true) {
      html += " loop";
    }
    if (this.dataModel.muted == true) {
      html += " muted";
    }
    if (this.dataModel.autoplay == true) {
      html += " autoplay";
    }
    if (this.dataModel.poster) {
      html += " poster=\"" + this.dataModel.poster + "\"";
    }
    html += " ></video>";
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "";
    bodyHtml += `  <video src="`+this.dataModel.src+`"`;
    if (this.dataModel.poster) {
      bodyHtml +=`poster="`+this.dataModel.poster+`"`;
    }
    if (this.dataModel.controls == false) {
      bodyHtml += " controls=\"{{" + this.dataModel.controls + "}}\"";
    }

    if (this.dataModel.loop == true) {
      bodyHtml += " loop";
    }
    if (this.dataModel.muted == true) {
      bodyHtml += " muted";
    }
    if (this.dataModel.autoplay == true) {
      bodyHtml += " autoplay";
    }
    bodyHtml +=` show-center-play-btn='{{false}}' show-mute-btn style="width: `+this.dataModel.width+`%;height: `+this.dataModel.height*2+`rpx;"></video>\r`;
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml (getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
    // 最外层节点   是否传给上层   父组件前面空格缩进    是否保留属性
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}