import TFPComponentRender from '../render.js'

export default class AudioCodeRender extends TFPComponentRender {
  // 生成组件HTML

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml (retainStyleAttr) {
    let attrHtml = super.getAttrHtml(retainStyleAttr);
    attrHtml += " src=\"" + this.dataModel.src + "\"";
    if(this.dataModel.width) attrHtml += " width=\"" + this.dataModel.width + "px\"";
    if(this.dataModel.height) attrHtml += " height=\"" + this.dataModel.height + "px\"";
    let style = "";
    if(this.dataModel.style) style = this.dataModel.style;
    if(style.indexOf("object-fit")<0) style += "object-fit:cover;"
    attrHtml += " style=\""+style+"\"";
    if (this.dataModel.controls == true) {
      attrHtml += " controls=\"" + this.dataModel.controls + "\"";
    }

    if (this.dataModel.loop == true) {
      attrHtml += " loop";
    }
    if (this.dataModel.muted == true) {
      attrHtml += " muted";
    }
    if (this.dataModel.autoplay == true) {
      attrHtml += " autoplay";
    }
    if (this.dataModel.poster) {
      attrHtml += " poster=\"" + this.dataModel.poster + "\"";
    }
    return attrHtml;
  }

  getBodyHtml() {
    return "";
  }

  getHtml (getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("video", false, parentIndent, retainStyleAttr);
    // 最外层节点   是否传给上层   父组件前面空格缩进    是否保留属性
  }
}