export default {
  "name": "Video",
  "comment": "视频组件",

  "attrs": [
    {
      "name": "src",
      "comment": "视频文件路径",
      "type": "String"
    },
    {
      "name": "width",
      "comment": "宽度(%)",
      "type": "Int",
      "default": 100
    },
    {
      "name": "height",
      "comment": "高度(px)",
      "type": "Int",
      "default": 500
    },
    {
      "name": "controls",
      "comment": "是否显示控件",
      "type": "Switch",
      "default": true,

    },
    {
      "name": "loop",
      "comment": "循环播放",
      "type": "Switch",
      "default": false,

    },
    {
      "name": "muted",
      "comment": "静音播放",
      "type": "Switch",
      "default": false,

    },
    {
      "name": "autoplay",
      "comment": "自动播放",
      "type": "Switch",
      "default": false,

    },
    {
      "name": "poster",
      "comment": "封面图",
      "type": "String",
      "default": "http://www.taskbuilder.org/tbsite/images/loadpage.png",
    },

  ],
  "styles": ["position", "margin", "border", "other"],
  "defaultStyles": { //默认拖拽出来的大小样式

  },
  "events": [{
    "name": "bindtap",
    "args": [{ 'name': 'e' }],
    "eventArgs": "",
    "comment": "点击时"
  }],
  "methods": [
    {
      "name": "play",
      "comment": "播放"
    },
    {
      "name": "pause",
      "comment": "暂停"
    }
  ]
}