export default {
  "name": "Tree",
  "comment": "树型",
  "cssFiles": "style.{bgColorMode}.pc.css",
  "attrs": [
    {
      "name": "nodeDataBindSetting",
      "comment": "节点数据绑定设置",
      "type": "group",
      "items": [
        {
          "name": "nodeDataQuerySetting",
          "comment": "节点数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px",
          "isDataBindSetting": true
        },
        {
          "name": "nodeDataDeleteSetting",
          "comment": "节点数据删除设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataDeleteSetting.tfp",
          "width": "700px",
          "height": "640px",
          "isDataBindSetting": true
        },
        {
          "name": "rootNodeParentId",
          "comment": "根节点父节点ID",
          "type": "String",
          "default": "0"
        },
        {
          "name": "nodeIdFieldName",
          "comment": "节点ID字段名",
          "type": "String",
          "default": "id",
          "dataBindSetting": "nodeDataQuerySetting",
          "showModelFieldList": true
        },
        {
          "name": "nodeNameFieldName",
          "comment": "节点名称字段名",
          "type": "String",
          "default": "name",
          "dataBindSetting": "nodeDataQuerySetting",
          "showModelFieldList": true
        },
        {
          "name": "nodeParentIdFieldName",
          "comment": "父节点ID字段名",
          "type": "String",
          "default": "parent_id",
          "dataBindSetting": "nodeDataQuerySetting",
          "showModelFieldList": true
        }
      ]
    },
    {
      "name": "leafNodeDataBindSetting",
      "comment": "叶节点数据绑定设置",
      "type": "group",
      "items": [
        {
          "name": "leafNodeDataQuerySetting",
          "comment": "叶节点数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px",
          "isDataBindSetting": true
        },
        {
          "name": "leafNodeDataDeleteSetting",
          "comment": "叶节点数据删除设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataDeleteSetting.tfp",
          "width": "700px",
          "height": "640px",
          "isDataBindSetting": true
        },
        {
          "name": "leafNodeIdFieldName",
          "comment": "叶节点ID字段名",
          "type": "String",
          "default": "id",
          "dataBindSetting": "leafNodeDataQuerySetting",
          "showModelFieldList": true
        },
        {
          "name": "leafNodeNameFieldName",
          "comment": "叶节点名称字段名",
          "type": "String",
          "default": "name",
          "dataBindSetting": "leafNodeDataQuerySetting",
          "showModelFieldList": true
        },
        {
          "name": "leafNodeParentIdFieldName",
          "comment": "叶父节点ID字段名",
          "type": "String",
          "default": "parent_id",
          "dataBindSetting": "leafNodeDataQuerySetting",
          "showModelFieldList": true
        }
      ]
    },
    {
      "name": "treeSetting",
      "comment": "树形组件设置",
      "type": "group",
      "items": [
        {
          "name": "showTitlePanel",
          "comment": "显示标题栏",
          "type": "Switch"
        },
        {
          "name": "title",
          "comment": "标题",
          "type": "String"
        },
        {
          "name": "showAddButton",
          "comment": "显示添加按钮",
          "type": "Switch"
        },
        {
          "name": "showResetButton",
          "comment": "显示重置按钮",
          "type": "Switch"
        },
        {
          "name": "expandAll",
          "comment": "展开所有节点",
          "type": "Switch"
        },
        {
          "name": "showNodeCheckbox",
          "comment": "显示节点选择框",
          "type": "Switch"
        },
        {
          "name": "showNodeEditButton",
          "comment": "显示节点编辑按钮",
          "type": "Switch"
        },
        {
          "name": "showNodeDeleteButton",
          "comment": "显示节点删除按钮",
          "type": "Switch"
        },
        {
          "name": "showLeafNodeCheckbox",
          "comment": "显示叶节点选择框",
          "type": "Switch"
        },
        {
          "name": "showLeafNodeEditButton",
          "comment": "显示叶节点编辑按钮",
          "type": "Switch"
        },
        {
          "name": "showLeafNodeDeleteButton",
          "comment": "显示叶节点删除按钮",
          "type": "Switch"
        },
        {
          "name": "checkParentOnCheckChild",
          "comment": "自动选中父节点",
          "type": "Switch"
        },
        {
          "name": "checkAllChildOnCheckParent",
          "comment": "自动选中子节点",
          "type": "Switch"
        },
        {
          "name": "unCheckAllChildOnUnCheckParent",
          "comment": "自动取消选中子节点",
          "type": "Switch"
        },
        {
          "name": "unCheckParentOnUnCheckAllChild",
          "comment": "自动取消选中父节点",
          "type": "Switch"
        },
        {
          "name": "multiCheck",
          "comment": "允许多选",
          "type": "Switch"
        },
        {
          "name": "deepBackground",
          "comment": "深色背景",
          "type": "Switch"
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "90px"
  },
  "methods": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, 
    {
      "name": "clear",
      "comment": "清空数据"
    },
    {
      "name": "bindData",
      "comment": "绑定数据",
      "args": [
        {
          "name": "data",
          "comment": "数据",
          "type": "Object",
          "required": true
        }
      ]
    },
    {
      "name": "loadData",
      "comment": "加载数据"
    },
    {
      "name": "bindTreeNodes",
      "comment": "绑定树节点",
      "args": [
        {
          "name": "rootNodes",
          "comment": "根节点编号数组",
          "type": "Array",
          "required": true
        },
        {
          "name": "nodes",
          "comment": "节点数组",
          "type": "Array",
          "required": true
        },
        {
          "name": "leafNodes",
          "comment": "页节点数组",
          "type": "Array"
        }
      ]
    },
    {
      "name": "addNode",
      "comment": "添加节点",
      "args": [
        {
          "name": "id",
          "comment": "节点ID",
          "type": "String",
          "required": true
        },
        {
          "name": "name",
          "comment": "节点名称",
          "type": "String",
          "required": true
        },
        {
          "name": "parentId",
          "comment": "父节点编号",
          "type": "String",
          "required": true
        },
        {
          "name": "tag",
          "comment": "节点数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "deleteNode",
      "comment": "删除节点",
      "args": [
        {
          "name": "nodeId",
          "comment": "节点ID",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "checkNode",
      "comment": "勾选节点",
      "args": [
        {
          "name": "nodeId",
          "comment": "节点ID",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "selectNode",
      "comment": "选中节点",
      "args": [
        {
          "name": "nodeId",
          "comment": "节点ID",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "toggleNode",
      "comment": "切换节点展开状态",
      "args": [
        {
          "name": "nodeId",
          "comment": "节点ID",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "updateNode",
      "comment": "修改节点",
      "args": [
        {
          "name": "id",
          "comment": "节点ID",
          "type": "String",
          "required": true
        },
        {
          "name": "name",
          "comment": "节点名称",
          "type": "String",
          "required": true
        },
        {
          "name": "parentId",
          "comment": "父节点编号",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "addLeafNode",
      "comment": "添加叶节点",
      "args": [
        {
          "name": "id",
          "comment": "节点ID",
          "type": "String",
          "required": true
        },
        {
          "name": "name",
          "comment": "节点名称",
          "type": "String",
          "required": true
        },
        {
          "name": "parentId",
          "comment": "父节点编号",
          "type": "String",
          "required": true
        },
        {
          "name": "tag",
          "comment": "节点数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "checkLeafNode",
      "comment": "选中叶节点",
      "args": [
        {
          "name": "nodeId",
          "comment": "节点ID",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "deleteLeafNode",
      "comment": "删除叶节点",
      "args": [
        {
          "name": "nodeId",
          "comment": "节点ID",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "getCheckedNodes",
      "comment": "获得选中的节点",
      "args": [
        {
          "name": "getData",
          "comment": "是否获得节点数据",
          "type": "Switch"
        }
      ]
    },
    {
      "name": "getCheckedLeafNodes",
      "comment": "获得选中的叶节点",
      "args": [
        {
          "name": "getData",
          "comment": "是否获得节点数据",
          "type": "Switch"
        }
      ]
    },
    {
      "name": "getCheckedNodesValue",
      "comment": "获得选中的节点值"
    },
    {
      "name": "getCheckedLeafNodesValue",
      "comment": "获得选中的叶节点值"
    }
  ],
  "events": [{
    "name": "onClickAddButton",
    "comment": "点击添加按钮时",
    "isNotHtmlEvent": true
  },{
    "name": "onClickNode",
    "comment": "单击节点时",
    "isNotHtmlEvent": true,
    "args": [
      {
        "name": "id",
        "comment": "节点ID",
        "type": "String"
      }
    ]
  },{
    "name": "onDblClickNode",
    "comment": "双击节点时",
    "isNotHtmlEvent": true,
    "args": [
      {
        "name": "id",
        "comment": "节点ID",
        "type": "String"
      }
    ]
  }, {
    "name": "onClickLeafNode",
    "comment": "单击叶节点时",
    "isNotHtmlEvent": true,
    "args": [
      {
        "name": "id",
        "comment": "节点ID",
        "type": "String"
      }
    ]
  },{
    "name": "onDblClickLeafNode",
    "comment": "双击叶节点时",
    "isNotHtmlEvent": true,
    "args": [
      {
        "name": "id",
        "comment": "节点ID",
        "type": "String"
      }
    ]
  }, {
    "name": "onClickNodeEditButton",
    "comment": "点击节点的编辑按钮时",
    "isNotHtmlEvent": true,
    "args": [
      {
        "name": "id",
        "comment": "节点ID",
        "type": "String"
      }
    ]
  }, {
    "name": "onClickNodeDeleteButton",
    "comment": "点击节点的删除按钮时",
    "isNotHtmlEvent": true,
    "args": [
      {
        "name": "id",
        "comment": "节点ID",
        "type": "String"
      }
    ]
  }, {
    "name": "onClickLeafNodeEditButton",
    "comment": "点击叶节点的编辑按钮时",
    "isNotHtmlEvent": true,
    "args": [
      {
        "name": "id",
        "comment": "节点ID",
        "type": "String"
      }
    ]
  }, {
    "name": "onClickLeafNodeDeleteButton",
    "comment": "点击叶节点的删除按钮时",
    "isNotHtmlEvent": true,
    "args": [
      {
        "name": "id",
        "comment": "节点ID",
        "type": "String"
      }
    ]
  }]
}