import { VisibleComponent } from "../controller.js";

/**
 * 树型组件
 * @param {[type]} dataModel [description]
 */
export default class Tree extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Tree", dataModel, parent);

    this.nodes = {};
    this.leafNodes = {};
    this.rootNodes = [];
    this.rootLeafNodes = [];

    this.iconPath = this._tfp.rootPath + "/src/components/tree/images/";
    this.iconColor = this._tfp.curPage.contentColorMode;

    this.selectedId = null;
  }

  get value() {
    if (this.dataModel.showNodeCheckbox && !this.dataModel.showLeafNodeCheckbox) {
      return this.getCheckedNodesValue();
    } else if (!this.dataModel.showNodeCheckbox && this.dataModel.showLeafNodeCheckbox) {
      return this.getCheckedLeafNodesValue();
    }
    //如果没有显示选择框，则返回最后一次点击过的节点值
    return this.selectedId;
  }
  set value(val) {
    //
  }

  //属性
  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  //属性
  get deleteNodeService() { return this.dataModel.deleteNodeService }
  set deleteNodeService(value) { this.dataModel.deleteNodeService = value }

  //属性
  get deleteLeafNodeService() { return this.dataModel.deleteLeafNodeService }
  set deleteLeafNodeService(value) { this.dataModel.deleteLeafNodeService = value }

  //属性
  get nodeDataMember() { return this.dataModel.nodeDataMember }
  set nodeDataMember(value) { this.dataModel.nodeDataMember = value }

  //属性
  get rootNodeParentId() { return this.dataModel.rootNodeParentId }
  set rootNodeParentId(value) { this.dataModel.rootNodeParentId = value }

  //属性
  get nodeIdFieldName() { return this.dataModel.nodeIdFieldName }
  set nodeIdFieldName(value) { this.dataModel.nodeIdFieldName = value }

  //属性
  get nodeNameFieldName() { return this.dataModel.nodeNameFieldName }
  set nodeNameFieldName(value) { this.dataModel.nodeNameFieldName = value }

  //属性
  get nodeParentIdFieldName() { return this.dataModel.nodeParentIdFieldName }
  set nodeParentIdFieldName(value) { this.dataModel.nodeParentIdFieldName = value }

  //属性
  get leafNodeDataMember() { return this.dataModel.leafNodeDataMember }
  set leafNodeDataMember(value) { this.dataModel.leafNodeDataMember = value }

  //属性
  get leafNodeIdFieldName() { return this.dataModel.leafNodeIdFieldName }
  set leafNodeIdFieldName(value) { this.dataModel.leafNodeIdFieldName = value }

  //属性
  get leafNodeNameFieldName() { return this.dataModel.leafNodeNameFieldName }
  set leafNodeNameFieldName(value) { this.dataModel.leafNodeNameFieldName = value }

  //属性
  get leafNodeParentIdFieldName() { return this.dataModel.leafNodeParentIdFieldName }
  set leafNodeParentIdFieldName(value) { this.dataModel.leafNodeParentIdFieldName = value }

  //属性
  get title() { return this.dataModel.title }
  set title(value) { this.dataModel.title = value }

  get showTitlePanel() { return this.dataModel.showTitlePanel }
  set showTitlePanel(value) {
    this.dataModel.showTitlePanel = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get showAddButton() { return this.dataModel.showAddButton }
  set showAddButton(value) {
    this.dataModel.showAddButton = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get showResetButton() { return this.dataModel.showResetButton }
  set showResetButton(value) {
    this.dataModel.showResetButton = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get expandAll() { return this.dataModel.expandAll }
  set expandAll(value) {
    this.dataModel.expandAll = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get showNodeCheckbox() { return this.dataModel.showNodeCheckbox }
  set showNodeCheckbox(value) {
    this.dataModel.showNodeCheckbox = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get showNodeEditButton() { return this.dataModel.showNodeEditButton }
  set showNodeEditButton(value) {
    this.dataModel.showNodeEditButton = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get showNodeDeleteButton() { return this.dataModel.showNodeDeleteButton }
  set showNodeDeleteButton(value) {
    this.dataModel.showNodeDeleteButton = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get showLeafNodeCheckbox() { return this.dataModel.showLeafNodeCheckbox }
  set showLeafNodeCheckbox(value) {
    this.dataModel.showLeafNodeCheckbox = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get showLeafNodeEditButton() { return this.dataModel.showLeafNodeEditButton }
  set showLeafNodeEditButton(value) {
    this.dataModel.showLeafNodeEditButton = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get showLeafNodeDeleteButton() { return this.dataModel.showLeafNodeDeleteButton }
  set showLeafNodeDeleteButton(value) {
    this.dataModel.showLeafNodeDeleteButton = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get checkParentOnCheckChild() { return this.dataModel.checkParentOnCheckChild }
  set checkParentOnCheckChild(value) {
    this.dataModel.checkParentOnCheckChild = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get checkAllChildOnCheckParent() { return this.dataModel.checkAllChildOnCheckParent }
  set checkAllChildOnCheckParent(value) {
    this.dataModel.checkAllChildOnCheckParent = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get unCheckAllChildOnUnCheckParent() { return this.dataModel.unCheckAllChildOnUnCheckParent }
  set unCheckAllChildOnUnCheckParent(value) {
    this.dataModel.unCheckAllChildOnUnCheckParent = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get unCheckParentOnUnCheckAllChild() { return this.dataModel.unCheckParentOnUnCheckAllChild }
  set unCheckParentOnUnCheckAllChild(value) {
    this.dataModel.unCheckParentOnUnCheckAllChild = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get multiCheck() { return this.dataModel.multiCheck }
  set multiCheck(value) {
    this.dataModel.multiCheck = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  get deepBackground() { return this.dataModel.deepBackground }
  set deepBackground(value) {
    this.dataModel.deepBackground = value ? true : false;
    if (this._jqObj) {
      //
    }
  }

  clear() {
    this.nodes = {};
    this.leafNodes = {};
    this.rootNodes = [];
    this.rootLeafNodes = [];
    if (this._jqObj) this._jqObj.empty();
    this.addTitlePanel();
  }

  bindData(data) {
    if (!data) {
      this._tfp.showMsg("请提供要绑定的数据！");
      return;
    }

    /*if (!this.dataModel.nodeDataMember && !(this.dataModel.nodeDataQuerySetting && this.dataModel.nodeDataQuerySetting.dataMember)) {
      this._tfp.showMsg("请为组件[" + this.id + "]设置[nodeDataMember]参数！");
      return;
    }*/

    let nodesData = [];
    if (this.dataModel.nodeDataMember) {
      nodesData = data[this.dataModel.nodeDataMember];
    } else if (this.dataModel.nodeDataQuerySetting && this.dataModel.nodeDataQuerySetting.dataMember) {
      nodesData = data[this.dataModel.nodeDataQuerySetting.dataMember];
    } else if(Array.isArray(data)) {
      nodesData = data;
    }
    
    if (!nodesData) {
      //this._tfp.showMsg("服务响应结果中没有名为[" + this.dataModel.nodeDataMember + "]的参数！");
      return;
    }

    this.clear();
    var nodeIdArr = [];

    //将服务器端返回数据转换为节点对象
    if (nodesData instanceof Array) {
      for (var i = 0; i < nodesData.length; i++) {
        var nodeData = nodesData[i];
        var node = {};
        node.id = nodeData[this.dataModel.nodeIdFieldName];
        node.name = nodeData[this.dataModel.nodeNameFieldName];
        node.parentId = nodeData[this.dataModel.nodeParentIdFieldName];
        node.data = nodeData;
        node.childNodes = [];
        node.leafNodes = [];
        this.nodes[node.id] = node;
        nodeIdArr.push(node.id);
      }
    } else {
      for (let objId in nodesData) {
        var nodeData = nodesData[objId];
        var node = {};
        node.id = nodeData[this.dataModel.nodeIdFieldName];
        node.name = nodeData[this.dataModel.nodeNameFieldName];
        node.parentId = nodeData[this.dataModel.nodeParentIdFieldName];
        node.data = nodeData;
        node.childNodes = [];
        node.leafNodes = [];
        this.nodes[node.id] = node;
        nodeIdArr.push(node.id);
      }
    }

    //如果有页节点数据，则生成页节点对象
    if (this.dataModel.leafNodeDataMember && data[this.dataModel.leafNodeDataMember]) {
      var leafNodesData = data[this.dataModel.leafNodeDataMember];
      for (var i = 0; i < leafNodesData.length; i++) {
        var nodeData = leafNodesData[i];
        var node = {};
        node.id = nodeData[this.dataModel.leafNodeIdFieldName];
        node.name = nodeData[this.dataModel.leafNodeNameFieldName];
        node.parentId = nodeData[this.dataModel.leafNodeParentIdFieldName];
        node.data = nodeData;
        this.leafNodes[node.id] = node;
        var parentNode = this.nodes[node.parentId];
        if (parentNode) {
          parentNode.leafNodes.push(node.id);
        }
      }
    }

    //生成节点之间的关系
    for (var i = 0; i < nodeIdArr.length; i++) {
      var nodeId = nodeIdArr[i];
      var node = this.nodes[nodeId];
      if (node.parentId == this.dataModel.rootNodeParentId) {
        this.rootNodes.push(nodeId);
      } else {
        var parentNode = this.nodes[node.parentId];
        if (parentNode) {
          parentNode.childNodes.push(nodeId);
        }
      }
    }

    for (var i = 0; i < this.rootNodes.length; i++) {
      var node = this.nodes[this.rootNodes[i]];
      if (!node.parentId) node.parentId = this.dataModel.rootNodeParentId;
      this.createNode(this._jqObj, node, 5);
    }
    /*if(this.dataModel.onLoaded) {
      eval(this.dataModel.onLoaded+"(req, res)");
    }*/
  }

  bindTreeNodes(rootNodes, nodes, leafNodes) {
    if (!rootNodes) {
      this._tfp.showMsg("请提供根节点数据！");
      return;
    }
    if (!nodes) {
      this._tfp.showMsg("请提供节点数据！");
      return;
    }
    this.clear();
    this.rootNodes = rootNodes;
    this.nodes = nodes;
    if (leafNodes) this.leafNodes = leafNodes;

    for (var i = 0; i < this.rootNodes.length; i++) {
      var node = this.nodes[this.rootNodes[i]];
      if (!node.parentId) node.parentId = this.dataModel.rootNodeParentId;
      this.createNode(this._jqObj, node, 5);
    }
  }

  loadLeafNodes(resNodes) {
    if (this.dataModel.leafNodeDataMember && resNodes[this.dataModel.leafNodeDataMember]) {
      this.bindData(resNodes);
      return;
    }

    if (!this.dataModel.leafNodeDataQuerySetting
      || !(this.dataModel.leafNodeDataQuerySetting.servicePath || this.dataModel.leafNodeDataQuerySetting.serviceCpt)) {
      this.bindData(resNodes);
      return;
    }

    let that = this;

    if (this.dataModel.leafNodeDataQuerySetting && this.dataModel.leafNodeDataQuerySetting.servicePath) {
      let options = {
        servicePath: this.dataModel.leafNodeDataQuerySetting.servicePath,
        autoShowError: true,
        showLoading: true
      };
      if (this.dataModel.leafNodeDataQuerySetting.requestArgs && this.dataModel.leafNodeDataQuerySetting.requestArgs.length > 0) {
        options.argSettings = this.dataModel.leafNodeDataQuerySetting.requestArgs;
      }
      if (that.dataModel.leafNodeDataQuerySetting.encryptRequestArgs) options.encryptRequestArgs = that.dataModel.leafNodeDataQuerySetting.encryptRequestArgs;
      if (that.dataModel.leafNodeDataQuerySetting.encryptResponseArgs) options.encryptResponseArgs = that.dataModel.leafNodeDataQuerySetting.encryptResponseArgs;

      this._tfp.request(options, function (req, res) {
        resNodes["_leafNodes"] = res[that.dataModel.leafNodeDataQuerySetting.dataMember];
        that.dataModel.leafNodeDataMember = "_leafNodes";
        that.bindData(resNodes);
      });
      return;
    }

    let serviceId = serviceId = this.dataModel.leafNodeDataQuerySetting.serviceCpt;
    let serviceCpt = this._tfp.get(serviceId);
    if (!serviceCpt) {
      this._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
      return;
    }

    serviceCpt.status = 0;
    serviceCpt.request(null, function (req, res) {
      resNodes["_leafNodes"] = res[that.dataModel.leafNodeDataQuerySetting.dataMember];
      that.dataModel.leafNodeDataMember = "_leafNodes";
      that.bindData(resNodes);
    });
  }

  loadData() {
    if (!this.dataModel.loadDataService && !(this.dataModel.nodeDataQuerySetting
      && (this.dataModel.nodeDataQuerySetting.servicePath || this.dataModel.nodeDataQuerySetting.serviceCpt))) {
      this._tfp.showMsg("请为[" + this.id + "]设置节点数据加载服务！");
      return;
    }

    let that = this;

    if (this.dataModel.nodeDataQuerySetting && this.dataModel.nodeDataQuerySetting.servicePath) {
      let options = {
        servicePath: this.dataModel.nodeDataQuerySetting.servicePath,
        autoShowError: true,
        showLoading: true
      };
      if (that.dataModel.nodeDataQuerySetting.requestArgs && that.dataModel.nodeDataQuerySetting.requestArgs.length > 0) {
        options.argSettings = that.dataModel.nodeDataQuerySetting.requestArgs;
      }
      if (that.dataModel.nodeDataQuerySetting.encryptRequestArgs) options.encryptRequestArgs = that.dataModel.nodeDataQuerySetting.encryptRequestArgs;
      if (that.dataModel.nodeDataQuerySetting.encryptResponseArgs) options.encryptResponseArgs = that.dataModel.nodeDataQuerySetting.encryptResponseArgs;

      this._tfp.request(options, function (req, res) {
        that.loadLeafNodes(res);
      });
      return;
    }

    let serviceId = this.dataModel.loadDataService;
    if (this.dataModel.nodeDataQuerySetting && this.dataModel.nodeDataQuerySetting.serviceCpt) {
      serviceId = this.dataModel.nodeDataQuerySetting.serviceCpt;
    }
    let serviceCpt = this._tfp.get(serviceId);
    if (!serviceCpt) {
      this._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
      return;
    }

    serviceCpt.status = 0;
    serviceCpt.request(null, function (req, res) {
      that.loadLeafNodes(res);
    });
  }

  reloadData() {
    this.loadData();
  }

  getNodeLevel(node) {
    let level = 1;  //层级默认为1
    let parent = node; //设置父节点默认为当前节点
    while((parent.parent_id+'')!=(this.dataModel.rootNodeParentId+'')) {  //只要父节点编号不是0，就循环查找上级节点
      parent = tree1.nodes[parent.parent_id];
      level++;
    }
    return level;
  }

  getNodeTextDivWidth(marginLeft) {
    //动态计算每个节点内文本框的最大宽度，以便文字过长时能自动出现省略号
    var divWidth = this._jqObj.get(0).offsetWidth;
    var nodeTextWidth = divWidth - marginLeft - 16 - 22;
    if (this.dataModel.showNodeCheckbox) nodeTextWidth -= 25;
    if (this.dataModel.showNodeDeleteButton) nodeTextWidth -= 21;
    if (this.dataModel.showNodeEditButton) nodeTextWidth -= 21;
    return nodeTextWidth;
  }

  /**
   * 清除选中的节点
   */
  clearSelectNode() {
    this._jqObj.find(".tfp-tree-node").removeClass("tfp-tree-node-selected");
    this._jqObj.find(".tfp-tree-leaf-node").removeClass("tfp-tree-node-selected");
    this.selectedId = null;

    if (!this._tfp.isDesigning) {
      this._tfp.iptValueOnChange(this);
      this.exeEventHandler("onChange", null);
    }
  }

  selectNode(nodeId) {
    var nodeDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + nodeId + "]");
    if (!this.dataModel.leafNodeDataMember) {
      this._jqObj.find(".tfp-tree-node").removeClass("tfp-tree-node-selected");
      this._jqObj.find(".tfp-tree-leaf-node").removeClass("tfp-tree-node-selected");
      nodeDiv.addClass("tfp-tree-node-selected");
      this.selectedId = nodeId;

      if (!this._tfp.isDesigning) {
        this._tfp.iptValueOnChange(this);
        this.exeEventHandler("onChange", this.selectedId);
      }
    }

    if (this.dataModel.onClickNode) {
      let eventFucName = this._tfp.getCptEventFuncName(this.dataModel.onClickNode);
      eval(eventFucName + "('" + nodeId + "')");
    }
  }

  /**
   * 创建节点
   * @param  {[type]} parentDiv  [description]
   * @param  {[type]} node       [description]
   * @param  {[type]} marginLeft [description]
   */
  createNode(parentDiv, node, marginLeft) {
    var toggleIcon = "dot";
    var haveChild = false;
    if (node.childNodes.length > 0 || (node.leafNodes && node.leafNodes.length > 0)) haveChild = true;
    if (haveChild) toggleIcon = this.dataModel.expandAll ? "toggle" : "expand";
    var nodeHtml = "<div class=\"tfp-tree-node\" nodeId=\"" + node.id + "\">"
      + "<div class=\"tfp-tree-node-icon\"><img src=\"" + (this.iconPath + toggleIcon
        + "-" + this.iconColor) + ".png\" style=\"margin-left: " + marginLeft + "px;\"></div>";
    if (this.dataModel.showNodeCheckbox) {
      let cbkType = this.dataModel.multiCheck ? "checkbox" : "radio";
      nodeHtml += "<div class=\"tfp-tree-node-checkbox\">"
        + "<input type=\"" + cbkType + "\" value=\"" + node.id + "\"";
      if (cbkType == "radio") nodeHtml += " name=\"" + this.id + "\"";
      nodeHtml += "></div>";
    }
    nodeHtml += "<div class=\"tfp-tree-node-text\" style=\"";
    //+"width:"+this.getNodeTextDivWidth(marginLeft)+"px;"
    if (!this.dataModel.deepBackground) nodeHtml += "color:#333333";
    nodeHtml += "\">" + node.name + "</div>";
    if (this.dataModel.showNodeDeleteButton) {
      nodeHtml += "<div class=\"tfp-tree-node-button\">"
        + "<img src=\"" + (this.iconPath + "del-" + this.iconColor) + ".png\" title=\"删除\" style=\"cursor:pointer\"></div>";
    }
    if (this.dataModel.showNodeEditButton) {
      nodeHtml += "<div class=\"tfp-tree-node-button\">"
        + "<img src=\"" + (this.iconPath + "edit-" + this.iconColor) + ".png\" title=\"修改\" style=\"cursor:pointer\"></div>";
    }
    nodeHtml += "</div>";
    parentDiv.append(nodeHtml);

    let nodeDivNew = parentDiv.children(".tfp-tree-node").last();
    let that = this;
    nodeDivNew.mouseover(function () {
      var bgColor = that.dataModel.deepBackground ? "#444444" : "#EEEEEE";
      //$(this).css("background-color", bgColor);
      $(this).find(".tfp-tree-node-button").show();
    });
    nodeDivNew.mouseout(function () {
      //$(this).css("background-color", "");
      $(this).find(".tfp-tree-node-button").hide();
    });
    nodeDivNew.find(".tfp-tree-node-text").click(function () {
      that.selectNode(node.id);
    });
    nodeDivNew.find(".tfp-tree-node-text").dblclick(function () {
      if (that.dataModel.onDblClickNode) {
        let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onDblClickNode);
        eval(eventFucName + "('" + node.id + "')");
      }
    });
    nodeDivNew.find(".tfp-tree-node-icon").find("img").click(function () {
      //that.selectNode(node.id);
      that.toggleNode(node.id);
    });
    nodeDivNew.find(".tfp-tree-node-checkbox").find("input").click(function () {
      that.nodeCheckBoxOnClick(node.id);
      if (that.dataModel.onClickNode) {
        let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickNode);
        eval(eventFucName + "('" + node.id + "')");
      }
    });
    nodeDivNew.find(".tfp-tree-node-button").find("img").click(function () {
      if ($(this).attr("title") == "修改") {
        if (that.dataModel.onClickNodeEditButton) {
          let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickNodeEditButton);
          eval(eventFucName + "('" + node.id + "')");
        }
      } else {
        that.onClickDeleteNodeButton(node.id);
      }
    });

    var childDisplay = this.dataModel.expandAll ? "" : "display:none";
    var childNodesDiv = $("<div class=\"tfp-tree-node-childs\" "
      + "nodeId=\"" + node.id + "\" style=\"" + childDisplay + "\"></div>");
    parentDiv.append(childNodesDiv);
    if (haveChild) {
      for (var i = 0; i < node.childNodes.length; i++) {
        var childNode = this.nodes[node.childNodes[i]];
        //如果子节点没有设置父节点编号属性，则在此设置一下
        //目前在选择部门和人员时需要这么做
        if (!childNode.parentId) childNode.parentId = node.id;
        this.createNode(childNodesDiv, childNode, marginLeft + 20);
      }
      if (node.leafNodes && node.leafNodes.length > 0) {
        for (var i = 0; i < node.leafNodes.length; i++) {
          var leafNode = this.leafNodes[node.leafNodes[i]];
          if (!leafNode) continue;
          if (!leafNode.parentId) leafNode.parentId = node.id;
          this.createLeafNode(childNodesDiv, leafNode, marginLeft + 20);
        }
      }
    }
  }

  /**
   * 处理节点删除按钮点击事件
   * @param  {[type]} nodeId     [description]
   */
  onClickDeleteNodeButton(nodeId) {
    var that = this;
    this._tfp.showConfirm("确定删除？", function (ret) {
      if (!ret) return;

      if (that.dataModel.onBeforeDeleteNode) {
        try {
          eval(that.dataModel.onBeforeDeleteNode);
        } catch (err) {
          console.log(err);
        }
      }

      var args = {};
      args[that.dataModel.nodeIdFieldName] = nodeId;
      args.childs = "";
      var childNodesDiv = $("#" + that.id).find(".tfp-tree-node-childs[nodeId=" + nodeId + "]");
      childNodesDiv.find(".tfp-tree-node").each(function () {
        if (args.childs != "") args.childs += ",";
        args.childs += $(this).attr("nodeId");
      });
      if (that.dataModel.onClickNodeDeleteButton) {
        let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickNodeDeleteButton);
        eval(eventFucName + "('" + nodeId + "')");
      } else if (that.dataModel.deleteNodeService
        || (that.dataModel.nodeDataDeleteSetting && that.dataModel.nodeDataDeleteSetting.serviceCpt)) {
        let serviceId = that.dataModel.deleteNodeService;
        if (that.dataModel.nodeDataDeleteSetting && that.dataModel.nodeDataDeleteSetting.serviceCpt)
          serviceId = that.dataModel.nodeDataDeleteSetting.serviceCpt;
        let serviceCpt = that._tfp.components[serviceId];
        if (!serviceCpt) {
          that._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
          return;
        }
        serviceCpt.request(args, function (req, res) {
          if (res.code != 0) {
            that._tfp.showMsg(res.message);
            return;
          }

          if (that.dataModel.onAfterDeleteNode) {
            try {
              eval(that.dataModel.onAfterDeleteNode);
            } catch (err) {
              console.log(err);
            }
          }

          that.deleteNode(nodeId);
        });
      } else if (that.dataModel.nodeDataDeleteSetting && that.dataModel.nodeDataDeleteSetting.servicePath) {
        that._tfp.use("Service", function () {
          let service = that._tfp.new("Service");
          service.path = that.dataModel.nodeDataDeleteSetting.servicePath;
          if (that.dataModel.nodeDataDeleteSetting.requestArgs && that.dataModel.nodeDataDeleteSetting.requestArgs.length > 0) {
            service.argSettings = that.dataModel.nodeDataDeleteSetting.requestArgs;
          }
          service.request(args, function (req, res) {
            if (res.code != 0) {
              that._tfp.showMsg(res.message);
              return;
            }

            if (that.dataModel.onAfterDeleteNode) {
              try {
                eval(that.dataModel.onAfterDeleteNode);
              } catch (err) {
                console.log(err);
              }
            }

            that.deleteNode(nodeId);
          });
        });
      }
    });
  }

  /**
   * 删除节点
   * @param  {[type]} nodeId [description]
   * @return {[type]}        [description]
   */
  deleteNode(nodeId) {
    if (!(nodeId in this.nodes)) return;
    //删除节点对应的html元素
    var nodeDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + nodeId + "]");
    nodeDiv.remove();
    var childNodesDiv = this._jqObj.find(".tfp-tree-node-childs[nodeId=" + nodeId + "]");
    childNodesDiv.remove();
    var node = this.nodes[nodeId];
    //删除子节点
    this.deleteChildNode(node);
    //解除与父节点的关联
    if (node.parentId != this.dataModel.rootNodeParentId) {
      var parentNode = this.nodes[node.parentId];
      parentNode.childNodes.remove(node.id);
      //如果父节点没有其他子节点了，则应该修改父节点的图标为无法收起或展开
      if (parentNode.childNodes.length == 0 && (!parentNode.leafNodes || parentNode.leafNodes.length == 0)) {
        let iconColor = this.dataModel.deepBackground ? "" : "-dark";
        var parentDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + node.parentId + "]");
        parentDiv.find(".tfp-tree-node-icon").find("img").get(0).src =
          this.iconPath + "dot-" + this.iconColor + ".png";
      }
    }
    //删除自己
    delete this.nodes[nodeId];
    node = null;
  }

  /**
   * 删除子节点
   * @param  {[type]} node [description]
   * @return {[type]}      [description]
   */
  deleteChildNode(node) {
    for (var i = 0; i < node.childNodes.length; i++) {
      var childNodeId = node.childNodes[i];
      var childNode = this.nodes[childNodeId];
      if (!childNode) continue;
      this.deleteChildNode(childNode);
      delete this.nodes[childNode.id];
      childNode = null;
    }
    if (!node.leafNodes) return;
    for (var i = 0; i < node.leafNodes.length; i++) {
      var leafNodeId = node.leafNodes[i];
      var leafNode = this.leafNodes[leafNodeId];
      delete this.leafNodes[leafNode.id];
      leafNode = null;
    }
  }

  /**
   * 处理节点选择框点击事件
   * @param  {[type]} nodeId [description]
   */
  nodeCheckBoxOnClick(nodeId) {
    var node = this.nodes[nodeId];
    if (!node) return;
    var nodeDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + nodeId + "]");
    var cbk = nodeDiv.find(".tfp-tree-node-checkbox").find("input").get(0);
    var childNodesDiv = this._jqObj.find(".tfp-tree-node-childs[nodeId=" + nodeId + "]");
    if (cbk.checked) {
      this.checkNode(nodeId);
    } else {
      this.unCheckNode(nodeId);
    }
  }

  checkNode(nodeId) {
    if (!this.showNodeCheckbox) return;
    var node = this.nodes[nodeId];
    if (!node) return;
    var nodeDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + nodeId + "]");
    var cbk = nodeDiv.find(".tfp-tree-node-checkbox").find("input").get(0);
    cbk.checked = true;
    var childNodesDiv = this._jqObj.find(".tfp-tree-node-childs[nodeId=" + nodeId + "]");
    if (this.dataModel.multiCheck) {
      if (this.dataModel.checkAllChildOnCheckParent) {
        childNodesDiv.find(".tfp-tree-node-checkbox").find("input").each(function () {
          $(this).get(0).checked = cbk.checked;
        });
      }
      if (this.dataModel.checkParentOnCheckChild) {
        var parentId = node.parentId;
        while (parentId != this.dataModel.rootNodeParentId) {
          var parentNode = this.nodes[parentId];
          var parentDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + parentId + "]");
          var parentCbk = parentDiv.find(".tfp-tree-node-checkbox").find("input");
          if (parentCbk.length == 0) break;
          parentCbk.get(0).checked = true;
          parentId = parentNode.parentId;
        }
      }
    } else {
      $(":radio").each(function () {
        if ($(this).parent().parent().attr("nodeId") != nodeId) $(this).get(0).checked = false;
      });
    }
  }

  unCheckNode(nodeId) {
    if (!this.showNodeCheckbox) return;
    var node = this.nodes[nodeId];
    if (!node) return;
    var nodeDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + nodeId + "]");
    var cbk = nodeDiv.find(".tfp-tree-node-checkbox").find("input").get(0);
    cbk.checked = false;
    var childNodesDiv = this._jqObj.find(".tfp-tree-node-childs[nodeId=" + nodeId + "]");
    if (this.dataModel.unCheckAllChildOnUnCheckParent) {
      childNodesDiv.find(".tfp-tree-node-checkbox").find("input").each(function () {
        $(this).get(0).checked = false;
      });
    }
    if (this.dataModel.unCheckParentOnUnCheckAllChild) {
      this.unCheckParentNode(node);
    }
  }

  /**
   * 取消选中父节点
   * @param  {[type]} node [description]
   */
  unCheckParentNode(node) {
    var parentId = node.parentId;
    if (parentId == this.dataModel.rootNodeParentId) return;
    var parentNode = this.nodes[parentId];
    if (!parentNode) return;
    for (var i = 0; i < parentNode.childNodes.length; i++) {
      var childId = parentNode.childNodes[i];
      var childDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + childId + "]");
      var childCbk = childDiv.find(".tfp-tree-node-checkbox").find("input");
      if (childCbk.length == 0) continue;
      //如果父节点有其他子节点已选中，则不能取消选中父节点
      if (childCbk.get(0).checked) return;
    }
    if (this.dataModel.showLeafNodeCheckbox && parentNode.leafNodes) {
      for (var i = 0; i < parentNode.leafNodes.length; i++) {
        var childId = parentNode.leafNodes[i];
        var childDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + childId + "]");
        var childCbk = childDiv.find(".tfp-tree-node-checkbox").find("input");
        if (childCbk.length == 0) continue;
        //如果父节点有叶节点已选中，则不能取消选中父节点
        if (childCbk.get(0).checked) return;
      }
    }

    var parentDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + parentId + "]");
    var parentCbk = parentDiv.find(".tfp-tree-node-checkbox").find("input");
    if (parentCbk.length == 0) return;
    parentCbk.get(0).checked = false;
    this.unCheckParentNode(parentNode);
  }

  haveChild(nodeId) {
    return (this.nodes[nodeId].childNodes.length > 0
      || (this.nodes[nodeId].leafNodes
        && this.nodes[nodeId].leafNodes.length > 0));
  }

  /**
   * 处理节点展开收起按钮点击事件
   * @param  {[type]} nodeId [description]
   */
  toggleNode(nodeId) {
    if (!this.haveChild(nodeId)) return;
    var nodeDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + nodeId + "]");
    var childNodesDiv = this._jqObj.find(".tfp-tree-node-childs[nodeId=" + nodeId + "]");
    let img = nodeDiv.find(".tfp-tree-node-icon").find("img").get(0);
    var iconColor = this.dataModel.deepBackground ? "" : "-dark";
    if (img.src.indexOf("images/toggle") >= 0) {
      img.src = this.iconPath + "expand-" + this.iconColor + ".png";
      childNodesDiv.hide();
    } else {
      img.src = this.iconPath + "toggle-" + this.iconColor + ".png";
      childNodesDiv.show();
    }
  }

  getLeafNodeTextDivWidth(marginLeft) {
    //动态计算每个节点内文本框的最大宽度，以便文字过长时能自动出现省略号
    var divWidth = this._jqObj.get(0).offsetWidth;
    var nodeTextWidth = divWidth - marginLeft - 16 - 22;
    if (this.dataModel.showLeafNodeCheckbox) nodeTextWidth -= 25;
    if (this.dataModel.showLeafNodeDeleteButton) nodeTextWidth -= 21;
    if (this.dataModel.showLeafNodeEditButton) nodeTextWidth -= 21;
    return nodeTextWidth;
  }

  /**
   * 创建页节点
   * @param  {[type]} parentDiv  [description]
   * @param  {[type]} node       [description]
   * @param  {[type]} marginLeft [description]
   */
  createLeafNode(parentDiv, node, marginLeft) {
    var nodeHtml = "<div class=\"tfp-tree-leaf-node\" nodeId=\"" + node.id + "\">";
    if (this.dataModel.showLeafNodeCheckbox) {
      var cbkType = this.dataModel.multiCheck ? "checkbox" : "radio";
      nodeHtml += "<div class=\"tfp-tree-node-checkbox\">" + "<input type=\""
        + cbkType + "\" value=\"" + node.id + "\" style=\"margin-left: " + marginLeft + "px;\"";
      if (cbkType == "radio") nodeHtml += " name=\"" + this.id + "\"";
      nodeHtml += "></div>";
    } else {
      nodeHtml += "<div class=\"tfp-tree-node-icon\"><img src=\"" + (this.iconPath + "dot"
        + "-" + this.iconColor) + ".png\" style=\"margin-left: " + marginLeft + "px;\"></div>";
    }

    nodeHtml += "<div class=\"tfp-tree-node-text\" style=\"cursor:pointer;width:"
      + this.getLeafNodeTextDivWidth(marginLeft) + "px;"

    if (!this.dataModel.deepBackground) nodeHtml += "color:#333333";
    nodeHtml += "\">" + node.name + "</div>";
    var iconColor = this.dataModel.deepBackground ? "" : "-dark";
    if (this.dataModel.showLeafNodeDeleteButton) {
      nodeHtml += "<div class=\"tfp-tree-node-button\">"
        + "<img src=\"" + this.iconPath + "del-" + this.iconColor + ".png\" title=\"删除\"></div>";
    }
    if (this.dataModel.showLeafNodeEditButton) {
      nodeHtml += "<div class=\"tfp-tree-node-button\">"
        + "<img src=\"" + this.iconPath + "edit-" + this.iconColor + ".png\" title=\"修改\"></div>";
    }
    nodeHtml += "</div>";
    parentDiv.append(nodeHtml);

    let that = this;
    let nodeDivNew = parentDiv.children(".tfp-tree-leaf-node").last();
    nodeDivNew.mouseover(function () {
      var bgColor = that.dataModel.deepBackground ? "#444444" : "#EEEEEE";
      //$(this).css("background-color", bgColor);
      $(this).find(".tfp-tree-node-button").css("display", "inline-flex");
    });
    nodeDivNew.mouseout(function () {
      //$(this).css("background-color", "");
      $(this).find(".tfp-tree-node-button").hide();
    });
    nodeDivNew.find(".tfp-tree-node-text").click(function () {
      that.selectLeafNode(node.id);
    });
    nodeDivNew.find(".tfp-tree-node-text").dblclick(function () {
      if (that.dataModel.onDblClickLeafNode) {
        let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onDblClickLeafNode);
        eval(eventFucName + "('" + node.id + "')");
      }
    });
    nodeDivNew.find(".tfp-tree-node-checkbox").find("input").click(function () {
      that.checkLeafNode(node.id);
      if (that.dataModel.onClickLeafNode) {
        let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickLeafNode);
        eval(eventFucName + "('" + node.id + "')");
      }
    });
    nodeDivNew.find(".tfp-tree-node-button").find("img").click(function () {
      if ($(this).attr("title") == "修改") {
        if (that.dataModel.onClickLeafNodeEditButton) {
          let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickLeafNodeEditButton);
          eval(eventFucName + "('" + node.id + "')");
        }
      } else {
        that.onClickDeleteLeafNodeButton(node.id);
      }
    });
  }

  selectLeafNode(nodeId) {
    var nodeDiv = this._jqObj.find(".tfp-tree-leaf-node[nodeId=" + nodeId + "]");
    this._jqObj.find(".tfp-tree-node").removeClass("tfp-tree-node-selected");
    this._jqObj.find(".tfp-tree-leaf-node").removeClass("tfp-tree-node-selected");
    nodeDiv.addClass("tfp-tree-node-selected");
    this.selectedId = nodeId;

    if (!this._tfp.isDesigning) {
      this._tfp.iptValueOnChange(this);
      this.exeEventHandler("onChange", this.selectedId);
    }

    if (this.dataModel.onClickLeafNode) {
      let eventFucName = this._tfp.getCptEventFuncName(this.dataModel.onClickLeafNode);
      eval(eventFucName + "('" + nodeId + "')");
    }
  }

  checkLeafNode(nodeId) {
    var node = this.leafNodes[nodeId];
    var nodeDiv = this._jqObj.find(".tfp-tree-leaf-node[nodeId=" + nodeId + "]");
    var cbk = nodeDiv.find(".tfp-tree-node-checkbox").find("input").get(0);
    if (cbk.checked) {
      if (this.dataModel.multiCheck) {
        if (this.dataModel.checkParentOnCheckChild) {
          var parentId = node.parentId;
          while (parentId != this.dataModel.rootNodeParentId) {
            var parentNode = this.nodes[parentId];
            var parentDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + parentId + "]");
            var parentCbk = parentDiv.find(".tfp-tree-node-checkbox").find("input");
            if (parentCbk.length == 0) break;
            parentCbk.get(0).checked = true;
            parentId = parentNode.parentId;
          }
        }
      } else {
        $(":radio").each(function () {
          if ($(this).parent().parent().attr("nodeId") != nodeId) $(this).get(0).checked = false;
        });
      }
    } else {
      if (this.dataModel.unCheckParentOnUnCheckAllChild) {
        this.unCheckParentNode(node);
      }
    }
  }

  onClickDeleteLeafNodeButton(nodeId) {
    let that = this;
    this._tfp.showConfirm("确定删除？", function (ret) {
      if (!ret) return;

      if (that.dataModel.onBeforeDeleteLeafNode) {
        try {
          eval(that.dataModel.onBeforeDeleteLeafNode);
        } catch (err) {
          console.log(err);
        }
      }

      var args = {};
      args[that.dataModel.leafNodeIdFieldName] = nodeId;

      if (that.dataModel.onClickLeafNodeDeleteButton) {
        let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickLeafNodeDeleteButton);
        eval(eventFucName + "('" + nodeId + "')");
      } else if (that.dataModel.deleteLeafNodeService
        || (that.dataModel.leafNodeDataDeleteSetting && that.dataModel.leafNodeDataDeleteSetting.serviceCpt)) {
        let serviceId = that.dataModel.deleteLeafNodeService;
        if (that.dataModel.leafNodeDataDeleteSetting && that.dataModel.leafNodeDataDeleteSetting.serviceCpt)
          serviceId = that.dataModel.leafNodeDataDeleteSetting.serviceCpt;
        let serviceCpt = that._tfp.components[serviceId];
        if (!serviceCpt) {
          that._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
          return;
        }
        serviceCpt.request(args, function (req, res) {
          if (res.code != 0) {
            that._tfp.showMsg(res.message);
            return;
          }
          that.deleteLeafNode(nodeId);
        });
      } else if (that.dataModel.leafNodeDataDeleteSetting && that.dataModel.leafNodeDataDeleteSetting.servicePath) {
        that._tfp.use("Service", function () {
          let service = that._tfp.new("Service");
          service.path = that.dataModel.leafNodeDataDeleteSetting.servicePath;
          if (that.dataModel.leafNodeDataDeleteSetting.requestArgs && that.dataModel.leafNodeDataDeleteSetting.requestArgs.length > 0) {
            service.argSettings = that.dataModel.leafNodeDataDeleteSetting.requestArgs;
          }
          if (that.dataModel.leafNodeDataDeleteSetting.encryptRequestArgs) service.encryptRequestArgs = that.dataModel.leafNodeDataDeleteSetting.encryptRequestArgs;
          if (that.dataModel.leafNodeDataDeleteSetting.encryptResponseArgs) service.encryptResponseArgs = that.dataModel.leafNodeDataDeleteSetting.encryptResponseArgs;

          service.request(args, function (req, res) {
            if (res.code != 0) {
              that._tfp.showMsg(res.message);
              return;
            }

            if (that.dataModel.onAfterDeleteLeafNode) {
              try {
                eval(that.dataModel.onAfterDeleteLeafNode);
              } catch (err) {
                console.log(err);
              }
            }

            that.deleteLeafNode(nodeId);
          });
        });
      }
    });
  }

  /**
   * 删除叶节点
   * @param  {[type]} nodeId [description]
   * @return {[type]}        [description]
   */
  deleteLeafNode(nodeId) {
    if (!(nodeId in this.leafNodes)) return;
    //删除节点对应的html元素
    var nodeDiv = this._jqObj.find(".tfp-tree-leaf-node[nodeId=" + nodeId + "]");
    nodeDiv.remove();
    var node = this.leafNodes[nodeId];
    //解除与父节点的关联
    var parentNode = this.nodes[node.parentId];
    parentNode.leafNodes.remove(node.id);
    //如果父节点没有其他子节点了，则应该修改父节点的图标为无法收起或展开
    if (parentNode.childNodes.length == 0 && parentNode.leafNodes.length == 0) {
      let iconColor = this.dataModel.deepBackground ? "" : "-dark";
      var parentDiv = this._jqObj.find(".tfp-tree-node[nodeId=" + node.parentId + "]");
      parentDiv.find(".tfp-tree-node-icon").find("img").get(0).src =
        this.iconPath + "dot-" + this.iconColor + ".png";
    }
    //删除自己
    delete this.leafNodes[nodeId];
    node = null;
  }

  /**
   * 获得图标颜色
   * @return {[type]} [description]
   */
  getIconColor() {
    return this.dataModel.deepBackground ? "" : "-dark";
  }

  /**
   * 获得节点HTML元素
   * @param  {[type]} nodeId [description]
   * @return {[type]}        [description]
   */
  getNodeEl(nodeId) {
    return this._jqObj.find(".tfp-tree-node[nodeId=" + nodeId + "]");
  }

  /**
   * 获得子节点容器HTML元素
   * @param  {[type]} nodeId [description]
   * @return {[type]}        [description]
   */
  getNodeChildsEl(nodeId) {
    return this._jqObj.find(".tfp-tree-node-childs[nodeId=" + nodeId + "]");
  }

  /**
   * 获得叶节点HTML元素
   * @param  {[type]} nodeId [description]
   * @return {[type]}        [description]
   */
  getLeafNodeEl(nodeId) {
    return this._jqObj.find(".tfp-tree-leaf-node[nodeId=" + nodeId + "]");
  }

  /**
   * 添加节点
   * @param {[type]} id       [description]
   * @param {[type]} name     [description]
   * @param {[type]} parentId [description]
   * @param {[type]} tag      [description]
   */
  addNode(id, name, parentId, tag) {
    var node = {};
    node.id = id;
    node.name = name;
    node.parentId = parentId;
    node.childNodes = [];
    if (this.dataModel.leafNodeDataMember) node.leafNodes = [];
    if (tag) node.tag = tag;
    this.nodes[node.id] = node;
    var marginLeft = 5;
    var parentDiv = $("#" + this.id);
    if (node.parentId != this.dataModel.rootNodeParentId) {
      let parentEl = this.getNodeEl(node.parentId);
      marginLeft = this._tfp.getPixel(parentEl.css("margin-left")) + 20;
      parentDiv = this.getNodeChildsEl(node.parentId);
      if (parentDiv.length == 0) return;
      var parentNode = this.nodes[node.parentId];
      if (!parentNode) return;
      parentNode.childNodes.push(node.id);
      var parentIcon = parentEl.find(".tfp-tree-node-icon").find("img");
      if (parentIcon.get(0).src.indexOf("/dot") > 0) {
        parentIcon.get(0).src = this.iconPath + "expand-" + this.iconColor + ".png";
      }
    }
    this.createNode(parentDiv, node, marginLeft);
  }

  /**
   * 添加叶节点
   * @param {[type]} id       [description]
   * @param {[type]} name     [description]
   * @param {[type]} parentId [description]
   * @param {[type]} tag      [description]
   */
  addLeafNode(id, name, parentId, tag) {
    var node = {};
    node.id = id;
    node.name = name;
    node.parentId = parentId;
    if (tag) node.tag = tag;
    this.leafNodes[node.id] = node;
    var marginLeft = 5;
    var parentDiv = $("#" + this.id);
    if (node.parentId != this.dataModel.rootNodeParentId) {
      let parentEl = this.getNodeEl(node.parentId);
      marginLeft = this._tfp.getPixel(parentEl.css("margin-left")) + 20;
      parentDiv = this.getNodeChildsEl(node.parentId);
      if (parentDiv.length == 0) return;
      var parentNode = this.nodes[node.parentId];
      if (!parentNode) return;
      parentNode.leafNodes.push(node.id);
      var parentIcon = parentEl.find(".tfp-tree-node-icon").find("img");
      if (parentIcon.get(0).src.indexOf("/dot") > 0) {
        parentIcon.get(0).src = this.iconPath + "expand-" + this.iconColor + ".png";
      }
    }
    this.createLeafNode(parentDiv, node, marginLeft);
  }

  /**
   * 更新节点
   * @param  {[type]} id       [description]
   * @param  {[type]} name     [description]
   * @param  {[type]} parentId [description]
   * @return {[type]}          [description]
   */
  updateNode(id, name, parentId) {
    var node = this.nodes[id];
    if (!node) return;
    var nodeDiv = this.getNodeEl(id);
    var childNodesDiv = this.getNodeChildsEl(id);
    var nodeIcon = nodeDiv.find(".tfp-tree-node-icon").find("img");
    if (node.name != name) {
      node.name = name;
      nodeDiv.find(".tfp-tree-node-text").html(name);
    }
    //如果父节点变了，则需要重新关联
    if (node.parentId != parentId) {
      if (node.parentId != this.dataModel.rootNodeParentId) {
        var parentOld = this.nodes[node.parentId];
        parentOld.childNodes.remove(node.id);
        //如果老的父节点没有其他子节点了，则应该修改老父节点的图标为无法收起或展开
        if (parentOld.childNodes.length == 0) {
          var parentOldEl = this.getNodeEl(node.parentId);
          var parentOldIcon = parentOldEl.find(".tfp-tree-node-icon").find("img");
          parentOldIcon.get(0).src = this.iconPath + "dot-" + this.iconColor + ".png";
        }
      }
      var parentDiv = null;
      var parentMargin = 5;
      if (parentId == this.dataModel.rootNodeParentId) {
        parentDiv = $("#" + this.id);
      } else {
        parentDiv = this.getNodeEl(parentId);;
        var parentNewIconDiv = parentDiv.find(".tfp-tree-node-icon");
        parentMargin = this._tfp.getPixel(parentNewIconDiv.css("margin-left")) + 20;
        this.setChildMargin(node, parentMargin);
        var parentNew = this.nodes[parentId];
        //如果新的父节点原来没有子节点，则应该修改新父节点的图标为展开
        if (parentNew.childNodes.length == 0) {
          parentNewIconDiv.find("img").get(0).src = this.iconPath + "expand-" + this.iconColor + ".png";
        }
        parentNew.childNodes.push(id);
      }
      nodeIcon.css("margin-left", parentMargin + "px");
      //nodeDiv.css("background-color", "");
      nodeDiv.find(".tfp-tree-node-button").hide();
      parentDiv.append(nodeDiv.clone());
      parentDiv.append(childNodesDiv.clone());
      node.parentId = parentId;
      nodeDiv.remove();
      childNodesDiv.remove();
    }
  }

  /**
   * 设置子节点左边距
   * @param {[type]} parent       [description]
   * @param {[type]} parentMargin [description]
   */
  setChildMargin(parent, parentMargin) {
    for (var i = 0; i < parent.childNodes.length; i++) {
      var node = this.nodes[parent.childNodes[i]];
      var nodeDiv = this.getNodeEl(node.id);
      var nodeIconDiv = nodeDiv.find(".tfp-tree-node-icon");
      nodeIconDiv.css("margin-left", (parentMargin + 20) + "px");
      this.setChildMargin(node, parentMargin + 20);
    }
    if (!parent.leafNodes) return;
    for (var i = 0; i < parent.leafNodes.length; i++) {
      var leafNode = this.leafNodes[parent.leafNodes[i]];
      var nodeDiv = this.getLeafNodeEl(leafNode.id);
      var nodeIconDiv = nodeDiv.find(".tfp-tree-node-icon");
      nodeIconDiv.css("margin-left", (parentMargin + 20) + "px");
    }
  }

  /**
   * 获得选中的节点
   * @param  {[type]} getData [description]
   * @return {[type]}         [description]
   */
  getCheckedNodes(getData) {
    var nodes = [];
    let that = this;
    this._jqObj.find(".tfp-tree-node").each(function () {
      var input = $(this).first(".tfp-tree-node-checkbox").find("input");
      if (input.get(0).checked && input.val() != "") {
        var node = that.nodes[input.val()];
        if (getData) {
          nodes.push(node);
        } else {
          nodes.push({
            id: node.id,
            name: node.name,
            parentId: node.parentId
          });
        }
      }
    });
    return nodes;
  }

  /**
   * 获得选中的叶节点
   * @param  {[type]} getData [description]
   * @return {[type]}         [description]
   */
  getCheckedLeafNodes(getData) {
    var nodes = [];
    let that = this;
    this._jqObj.find(".tfp-tree-leaf-node").each(function () {
      var input = $(this).first(".tfp-tree-node-checkbox").find("input");
      if (input.get(0).checked && input.val() != "") {
        var node = that.leafNodes[input.val()];
        if (getData) {
          nodes.push(node);
        } else {
          nodes.push({
            id: node.id,
            name: node.name,
            parentId: node.parentId
          });
        }
      }
    });
    return nodes;
  }

  /**
   * 获得选中的节点值
   * @return {[type]} [description]
   */
  getCheckedNodesValue() {
    if (!this.showNodeCheckbox) return "";
    var values = "";
    var that = this;
    this._jqObj.find(".tfp-tree-node").each(function () {
      var input = $(this).find(".tfp-tree-node-checkbox").find("input");
      if (input.length > 0 && input.get(0).checked && input.val() != "") {
        if (values != "") values += ",";
        values += input.val();
        if (!that.multiCheck) return false;
      }
    });
    return values;
  }

  /**
   * 获得选中的叶节点值
   * @return {[type]} [description]
   */
  getCheckedLeafNodesValue() {
    if (!this.showLeafNodeCheckbox) return "";
    var values = "";
    var that = this;
    this._jqObj.find(".tfp-tree-leaf-node").each(function () {
      var input = $(this).find(".tfp-tree-node-checkbox").find("input");
      if (input.length > 0 && input.get(0).checked && input.val() != "") {
        if (values != "") values += ",";
        values += input.val();
        if (!that.multiCheck) return false;
      }
    });
    return values;
  }

  /**
   * 设置指定属性的数据绑定信息
   * @param {*} attr 
   * @param {*} settingData 
   * @param {*} attrSetting 
   */
  setDataBindSetting(attr, settingData, attrSetting) {
    if (attr.name == "nodeDataQuerySetting") {
      settingData.type = "query";
      settingData.serviceNameSuffix = "query_node";
      settingData.serviceComment = "节点数据查询";
      attrSetting.dataMember = "data";
    } else if (attr.name == "nodeDataDeleteSetting") {
      settingData.type = "delete";
      settingData.serviceNameSuffix = "delete_node";
      settingData.serviceComment = "节点数据删除";
    } else if (attr.name == "leafNodeDataQuerySetting") {
      settingData.type = "query";
      settingData.serviceNameSuffix = "query_leafnode";
      settingData.serviceComment = "叶节点数据查询";
      attrSetting.dataMember = "data";
    } else if (attr.name == "leafNodeDataDeleteSetting") {
      settingData.type = "delete";
      settingData.serviceNameSuffix = "delete_leafnode";
      settingData.serviceComment = "叶节点数据删除";
    }
  }

  addTitlePanel() {
    //如果要显示标题栏，或添加按钮，或重置按钮
    if(this.dataModel.showTitlePanel && (this.dataModel.title || this.dataModel.showAddButton || this.dataModel.showResetButton)) {
      let htmlTitlePanel = "<div class=\"tfp-tree-title-panel\"><label>";
      if(this.dataModel.title) htmlTitlePanel += "<span></span>"+this.dataModel.title;
      htmlTitlePanel += "</label>";
      htmlTitlePanel += "<div class=\"tfp-tree-title-panel-right\">";
      if(this.dataModel.showAddButton) htmlTitlePanel += "<div><img title=\"添加\" src=\"/node_modules/tfp/src/components/tree/images/add.png\"></div>";
      if(this.dataModel.showResetButton) htmlTitlePanel += "<div><img title=\"重置\" src=\"/node_modules/tfp/src/components/tree/images/clear.png\"></div>";
      htmlTitlePanel += "</div></div>";
      this._jqObj.append(htmlTitlePanel);
      let that = this;
      let addButton = this._jqObj.find(".tfp-tree-title-panel-right").find("img[title=添加]");
      if(addButton.length>0) {
        addButton.click(function() {
          if(that.dataModel.onClickAddButton) {
            try {
              eval(that.dataModel.onClickAddButton);
            } catch(err) {
              console.log(err);
            }
          }
        });
      }
      let resetButton = this._jqObj.find(".tfp-tree-title-panel-right").find("img[title=重置]");
      if(resetButton.length>0) {
        resetButton.click(function() {
          that.clearSelectNode();
        });
      }
    }
  }

  initRuntime() {
    if (!this.dataModel.loadDataService && !(this.dataModel.nodeDataQuerySetting
      && (this.dataModel.nodeDataQuerySetting.servicePath || this.dataModel.nodeDataQuerySetting.serviceCpt))) return;
    this.loadData();
  }
}