import { FormInput } from "../controller.js";

/**
 * 穿梭框组件
 * @param {[type]} dataModel [description]
 */
export default class Transfer extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Transfer", dataModel, parent);
  }

  get defaultVal() { return this.dataModel.defaultVal; }
  set defaultVal(value) {
    this.dataModel.defaultVal = value;
    this.setDefaultVal();
  }

  get options() { return this.dataModel.options }
  set options(options) {
    if (this._jqObj && options && Array.isArray(options)) {
      this.dataModel.options = options;
      if (this._jqObj) {
        this.reRender();
      }
    }
  }

  get titleLeft() { return this.dataModel.titleLeft }
  set titleLeft(value) {
    this.dataModel.titleLeft = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get titleRight() { return this.dataModel.titleRight }
  set titleRight(value) {
    this.dataModel.titleRight = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get search() { return this.dataModel.search }
  set search(value) {
    this.dataModel.search = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get valueType() { return this.dataModel.valueType }
  set valueType(value) {
    if (!this.checkAttrOption("valueType", value)) {
      this._tfp.showMsg("不支持类型：" + value + "！");
      return;
    }
    this.dataModel.valueType = value;
    this.setDefaultVal();
  }

  get loadDataListService() { return this.dataModel.loadDataListService }
  set loadDataListService(value) {
    this.dataModel.loadDataListService = value;
  }

  get dataListBindingMember() { return this.dataModel.dataListBindingMember }
  set dataListBindingMember(value) {
    this.dataModel.dataListBindingMember = value;
  }

  get dataListValueFormat() { return this.dataModel.dataListValueFormat }
  set dataListValueFormat(value) {
    this.dataModel.dataListValueFormat = value;
  }

  get dataListTextFormat() { return this.dataModel.dataListTextFormat }
  set dataListTextFormat(value) {
    this.dataModel.dataListTextFormat = value;
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    let options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        let valueFormat = this.dataModel.dataListValueFormat;
        if (valueFormat.indexOf("{") < 0 && valueFormat.indexOf("#[") < 0) valueFormat = "{" + valueFormat + "}";
        option.value = this._tfp.replaceDataField(row, valueFormat);
        if (option.value) option.value = this._tfp.exeExpress(option.value);
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.value)) continue;
      option.text = option.value;
      if (this.dataModel.dataListTextFormat) {
        try {
          let textFormat = this.dataModel.dataListTextFormat;
          if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
          option.text = this._tfp.replaceDataField(row, textFormat);
          if (option.text) option.text = this._tfp.exeExpress(option.text);
        } catch (e) {
          console.log(e);
          return;
        }
      }
      if (isNull(option.text)) continue;
      options.push(option);
    }
    this.options = options;
  }

  reRender() {
    this._jqObj.empty();
    this._jqObj.append(this.getBodyHtml());
    if (!this._tfp.isDesigning) this.bindTransferChange();
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let html = "\r\n";
    let arrVal = [];
    if (this.dataModel.defaultVal) arrVal = (this.dataModel.defaultVal + "").split(",");
    html += indent + `<div class="tfp-transfer-meun">
      <div class="tfp-transfer-title">
        <div><label><input type="checkbox" class="left_checkbox">`+ this.dataModel.titleLeft + `</label></div>
        <div class="tfp-transfer-num"><span class="old_select_length">0</span>/<span class="old_total_length">0</span>
        </div>
      </div>`;
    if (this.dataModel.search)
      html += `<div class="tfp-transfer-search">
        <input class="old_search" type="text" placeholder="请输入" />
      </div>`;
    html += `<div class="old_select"`;
    if (!this.dataModel.search) html += ` style="top:40px;"`;
    html += `>`;
    if (this.dataModel.options)
      for (var i = 0; i < this.dataModel.options.length; i++) {
        let val = this.dataModel.options[i].value;
        let txt = this.dataModel.options[i].text;
        if (!txt) txt = val;
        if (!arrVal.includes(val))
          html += `<label value="` + val + `" title="` + txt + `"><input type="checkbox">` + txt + `</label>`;
      }
    html += `</div>
    </div>

    <div class="tfp-transfer-meun">
      <div class="click_button">
        <div><button class="to_right">></button></div>
        <div><button class="to_left"><</button></div>
      </div>
    </div>

    <div class="tfp-transfer-meun">
      <div class="tfp-transfer-title">
        <div><label><input type="checkbox" class="right_checkbox">`+ this.dataModel.titleRight + `</label></div>
        <div class="tfp-transfer-num"><span class="new_select_length">0</span>/<span class="new_total_length">0</span>
        </div>
      </div>`;
    if (this.dataModel.search)
      html += `<div class="tfp-transfer-search">
        <input class="new_search" type="text" placeholder="请输入" />
      </div>`;
    html += `<div class="new_select"`;
    if (!this.dataModel.search) html += ` style="top:40px;"`;
    html += `>`;
    if (this.dataModel.options)
      for (var i = 0; i < this.dataModel.options.length; i++) {
        let val = this.dataModel.options[i].value;
        let txt = this.dataModel.options[i].text;
        if (!txt) txt = val;
        if (arrVal.includes(val))
          html += `<label value="` + val + `" title="` + txt + `"><input type="checkbox">` + txt + `</label>`;
      }
    html += `</div>
    </div>`;
    return html + "\t";
  }

  bindTransferChange() {
    let that = this;
    length_return();

    $(".left_checkbox").click(function () {
      if ($(this).is(":checked")) {
        $(".old_select").find("input").each(function () {
          $(this).prop("checked", true);
        });
      } else {
        $(".old_select").find("input").each(function () {
          $(this).prop("checked", false);
        });
      }
      length_return();
    })
    $(".right_checkbox").click(function () {
      if ($(this).is(":checked")) {
        $(".new_select").find("input").each(function () {
          $(this).prop("checked", true);
        });
      } else {
        $(".new_select").find("input").each(function () {
          $(this).prop("checked", false);
        });
      }
      length_return();
    })

    $(".old_select").find("input").click(function () {
      if ($(".old_select").find("label").length == 0) return;
      let flagLeft = true;
      $(".old_select").find("input").each(function () {
        if (!$(this).is(":checked")) flagLeft = false;
      });
      $(".left_checkbox").prop("checked", flagLeft);
      length_return();
    })
    $(".new_select").find("input").click(function () {
      if ($(".new_select").find("label").length == 0) return;
      let flagRight = true;
      $(".new_select").find("input").each(function () {
        if (!$(this).is(":checked")) flagRight = false;
      });
      $(".right_checkbox").prop("checked", flagRight);
      length_return();
    })

    $(".to_left").click(function () {
      let old_select = $(".old_select");
      let new_select = $(".new_select");
      let oldHtml = [];
      new_select.find("input:checked").each(function () {
        oldHtml.push($(this).parent());
      });
      old_select.prepend(...oldHtml);
      $("input").prop("checked", false);
      length_return();
      that.setTransferValue();
    })
    $(".to_right").click(function () {
      let old_select = $(".old_select");
      let new_select = $(".new_select");
      let newHtml = [];
      old_select.find("input:checked").each(function () {
        newHtml.push($(this).parent());
      })
      new_select.prepend(...newHtml);
      $("input").prop("checked", false);
      length_return();
      that.setTransferValue();
    })

    $(".old_search").on("input change", function (event) {
      let old_select = $(".old_select");
      let kw = $(this).val().trim();
      if (!kw) {
        old_select.find("label").show();
      }
      old_select.find("label").each(function () {
        $(this).show();
        if ($(this).text().indexOf(kw) < 0) {
          $(this).hide();
        }
      });
    })
    $(".new_search").on("input change", function (event) {
      let new_select = $(".new_select");
      let kw = $(this).val().trim();
      if (!kw) {
        new_select.find("label").show();
      }
      new_select.find("label").each(function () {
        $(this).show();
        if ($(this).text().indexOf(kw) < 0) {
          $(this).hide();
        }
      })
    })

    function length_return() {
      let old_total_length = $(".old_select").find("label").length;
      let old_select_length = $(".old_select").find("input[type=checkbox]:checked").length;
      let new_total_length = $(".new_select").find("label").length;
      let new_select_length = $(".new_select").find("input[type=checkbox]:checked").length;
      $(".old_total_length").text(old_total_length)
      $(".old_select_length").text(old_select_length)
      $(".new_total_length").text(new_total_length)
      $(".new_select_length").text(new_select_length)
    };
  }

  setTransferValue() {
    let transferObj = [];
    let transferValue = [];
    let transferText = [];
    for (var j = 0; j < $(".new_select").find("label").length; j++) {
      let label = $(".new_select").find("label").eq(j);
      for (var i = 0; i < this.dataModel.options.length; i++) {
        let option = this.dataModel.options[i];
        if (option.value == label.attr("value")) {
          transferObj.push(option);
          transferValue.push(option.value);
          if (option.text) transferText.push(option.text);
          break;
        }
      }
    }
    if (transferObj.length == 0 || transferValue.length == 0 || transferText.length == 0) {
      this.value = '';
      return '';
    }
    if (this.dataModel.valueType == "obj") {
      this.value = transferObj;
    } else if (this.dataModel.valueType == "text") {
      this.value = transferText;
    } else {
      this.value = transferValue;
    }
  }

  addRightOption(value, text) {
    this._jqObj.find(".new_select").append("<label value=\"" + value + "\" title=\"" + text + "\"><input type=\"checkbox\">" + text + "</label>");
  }

  setDefaultVal() {
    let arrVal = [];
    if (this.dataModel.defaultVal) arrVal = (this.dataModel.defaultVal + "").split(",");
    if (this.dataModel.options && arrVal) {
      let transferObj = [];
      let transferValue = [];
      let transferText = [];
      for (var i = 0; i < arrVal.length; i++) {
        let val = arrVal[i];
        for (var j = 0; j < this.dataModel.options.length; j++) {
          let option = this.dataModel.options[j];
          if (option.value == val) {
            transferObj.push(option);
            transferValue.push(option.value);
            if (option.text) transferText.push(option.text);
            break;
          }
        }
      }
      if (transferObj.length == 0 || transferValue.length == 0 || transferText.length == 0) {
        this.dataModel.value = '';
      }
      if (this.dataModel.valueType == "obj") {
        this.dataModel.value = transferObj;
      } else if (this.dataModel.valueType == "text") {
        this.dataModel.value = transferText;
      } else {
        this.dataModel.value = transferValue;
      }
    }
    if (!this._tfp.isDesigning) {
      this.value = this.dataModel.value;
      this.valueOnChange();
      this.exeEventHandler("onChange", this.value);
    }
    if (this.dataModel.value) {
      this.reRender();
    }
  }

  setValue(values) {
    this.dataModel.defaultVal = values;
    this.setDefaultVal();
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.dataListValueFormat) {
      alert("请为[" + this.id + "]设置选项值数据格式！");
      return false;
    }
    return true;
  }
  
  initRuntime() {
    if (this.dataModel.value) this.value = this.dataModel.value;

    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService 
      || (this.dataModel.dataQuerySetting 
      && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
    )) {
      this.loadData();
    }

    this.setDefaultVal();
    this.bindTransferChange();
  }
}