import { InvisibleComponent } from "../controller.js";

/**
 * 计数器组件
 * @param {[type]} dataModel [description]
 */
export default class Timer extends InvisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Timer", dataModel, parent);
    this.timer = null;
    this.flag = false;
  }


  get interval () { return this.dataModel.interval }
  set interval (value) {
    this.dataModel.interval = value
  }

  get status () { return this.dataModel.status }
  set status (value) {
    this.dataModel.status = value
  }


  stop () {
    if (this.timer) {
      clearInterval(this.timer);
      this.flag = false;
      this.dataModel.status = false;
    }

  }
  start () {
    var that = this;
    if (!that.dataModel.onPolling) {
      tfp.showMsg("请为定时器组件设置轮询事件！");
    } else {
      if (!that.flag) {
        that.flag = true;
        that.dataModel.status = true;
        that.timer = setInterval(() => {
          eval(that.dataModel.onPolling);
        }, that.dataModel.interval);
      }
    }
  }


}