import { FormInput } from "../controller.js";

/**
 * 时间线组件
 * @param {[type]} dataModel [description]
 */
export default class TimeLine extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "TimeLine", dataModel, parent);

    if (!this.dataModel.options || this.dataModel.options.length == 0) {
      this.dataModel.options = [{
        text: "timeline1",
        time: "2023-03-30"
      }, {
        text: "timeline2",
        time: "2023-03-31"
      }, {
        text: "timeline3",
        time: "2023-04-01"
      }];
    }
  }

  get options() { return this.dataModel.options }
  set options(options) {
    if (this._jqObj && options && Array.isArray(options)) {
      this.dataModel.options = options;
      if (this._jqObj) {
        this.reRender();
      }
    }
  }

  get alignment() { return this.dataModel.alignment }
  set alignment(value) {
    this.dataModel.alignment = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get sort() { return this.dataModel.sort }
  set sort(value) {
    this.dataModel.sort = value;
    if (this._jqObj) {
      if (this.dataModel.sort == "positiveSequence") {
        this.dataModel.options.reverse()
      } else if (this.dataModel.sort == "invertedOrder") {
        this.dataModel.options.reverse()
      }
      this.reRender();
    }
  }

  get timeTop() { return this.dataModel.timeTop }
  set timeTop(value) {
    this.dataModel.timeTop = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get broadwise() { return this.dataModel.broadwise }
  set broadwise(value) {
    this.dataModel.broadwise = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get timeLineWidth() { return this.dataModel.timeLineWidth }
  set timeLineWidth(value) {
    this.dataModel.timeLineWidth = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get loadDataListService() { return this.dataModel.loadDataListService }
  set loadDataListService(value) {
    this.dataModel.loadDataListService = value;
  }

  get dataListBindingMember() { return this.dataModel.dataListBindingMember }
  set dataListBindingMember(value) {
    this.dataModel.dataListBindingMember = value;
  }

  get dataListTextFormat() { return this.dataModel.dataListTextFormat }
  set dataListTextFormat(value) {
    this.dataModel.dataListTextFormat = value;
  }

  get dataListTimeFormat() { return this.dataModel.dataListTimeFormat }
  set dataListTimeFormat(value) {
    this.dataModel.dataListTimeFormat = value;
  }

  get dataListIconFormat() { return this.dataModel.dataListIconFormat }
  set dataListIconFormat(value) {
    this.dataModel.dataListIconFormat = value;
  }

  reRender() {
    this._jqObj.empty();
    this._jqObj.append(this.getBodyHtml());
    if (!this._tfp.isDesigning) this.bindItemEvent();
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let html = "\r\n";

    if (this.dataModel.broadwise) {
      html += indent + "\t<div class=\"tfp-timeline-b\">\r\n";
    } else {
      html += indent + "\t<div class=\"tfp-timeline-v\">\r\n";
    }

    for (var i = 0; i < this.dataModel.options.length; i++) {
      let option = this.dataModel.options[i];
      let bgColor = "";
      let width = "200";

      if (!option.time) option.time = '';
      if (!option.icon) option.icon = '';

      if (option.color) bgColor = "background-color: " + option.color + ";";

      if (this.dataModel.timeLineWidth) width = this.dataModel.timeLineWidth;

      let iconHtml = "<div class=\"tfp-timeline-icon\" style=\"" + bgColor + "\"></div>";

      if (option.icon) iconHtml = "<img src=\"" + option.icon + "\" style=\"width: 24px; height: 24px;\">"

      let topStyle = "";
      let bottomStyle = "";

      if (this.dataModel.alignment == 'center') {
        topStyle = "left: calc(50% - 12px);";
        bottomStyle = "text-align: center;";
      } else if (this.dataModel.alignment == 'left') {
        topStyle = "left: 0;";
        bottomStyle = "text-align: left;";
      }

      if (this.dataModel.broadwise) {
        html += indent + "\t<div class=\"tfp-timeline-item\" style=\"width:" + width + "px;\">\r\n";
        html += indent + "\t<div class=\"tfp-timeline-top\" style=\"" + topStyle + "\">\r\n";
        html += indent + "\t<div class=\"tfp-timeline-line\" style=\"right:calc(" + width + "px - 12px);\"\"></div>\r\n";
        html += indent + "\t<div class=\"tfp-timeline-img\">" + iconHtml + "</div>\r\n";
        html += indent + "\t</div>\r\n";
        html += indent + "\t<div class=\"tfp-timeline-bottom\" style=\"" + bottomStyle + "\">\r\n";

        if (this.dataModel.timeTop) {
          html += indent + "\t<div class=\"tfp-timeline-time\">" + option.time + "</div>\r\n";

          html += indent + "\t<div class=\"tfp-timeline-text\"";
          if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
          html += ">" + option.text + "</div>\r\n";
        } else {
          html += indent + "\t<div class=\"tfp-timeline-text\"";
          if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
          html += ">" + option.text + "</div>\r\n";

          html += indent + "\t<div class=\"tfp-timeline-time\">" + option.time + "</div>\r\n";
        }

        html += indent + "\t</div>\r\n";
        html += indent + "\t</div>\r\n";
      } else {
        html += indent + "\t<div class=\"tfp-timeline-item-v\" style=\"height:" + width + "px;\">\r\n";
        html += indent + "\t<div class=\"tfp-timeline-left-v\">\r\n";
        html += indent + "\t<div class=\"tfp-timeline-line-v\" style=\"top:calc(-" + width + "px + 12px);\"></div>\r\n";
        html += indent + "\t<div class=\"tfp-timeline-img\">" + iconHtml + "</div>\r\n";
        html += indent + "\t</div>\r\n";
        html += indent + "\t<div class=\"tfp-timeline-right-v\" style=\"" + bottomStyle + "\">\r\n";
        if (this.dataModel.timeTop) {
          html += indent + "\t<div class=\"tfp-timeline-time\">" + option.time + "</div>\r\n";

          html += indent + "\t<div class=\"tfp-timeline-text\"";
          if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
          html += ">" + option.text + "</div>\r\n";
        } else {
          html += indent + "\t<div class=\"tfp-timeline-text\"";
          if (!this._tfp.isDesigning && option.onClick) html += " onclick =\"" + option.onClick + "\"";
          html += ">" + option.text + "</div>\r\n";

          html += indent + "\t<div class=\"tfp-timeline-time\">" + option.time + "</div>\r\n";
        }

        html += indent + "\t</div>\r\n";
        html += indent + "\t</div>\r\n";
      }
    }

    html += indent + "\t</div>\r\n";

    return html + "\t";
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.dataListTextFormat) {
      alert("请为[" + this.id + "]设置节点标题数据格式！");
      return false;
    }
    return true;
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    let options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        let textFormat = this.dataModel.dataListTextFormat;
        if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
        option.text = this._tfp.replaceDataField(row, textFormat);
        if (option.text) option.text = this._tfp.exeExpress(option.text);
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.text)) continue;
      if (this.dataModel.dataListTimeFormat) {
        try {
          let timeFormat = this.dataModel.dataListTimeFormat;
          if (timeFormat.indexOf("{") < 0 && timeFormat.indexOf("#[") < 0) timeFormat = "{" + timeFormat + "}";
          option.time = this._tfp.replaceDataField(row, timeFormat);
          if (option.time) option.time = this._tfp.exeExpress(option.time);
        } catch (e) {
          console.log(e);
          return;
        }
      }
      if (this.dataModel.dataListIconFormat) {
        try {
          let iconFormat = this.dataModel.dataListIconFormat;
          if (iconFormat.indexOf("{") < 0 && iconFormat.indexOf("#[") < 0) iconFormat = "{" + iconFormat + "}";
          option.icon = this._tfp.replaceDataField(row, iconFormat);
          if (option.icon) option.icon = this._tfp.exeExpress(option.icon);
        } catch (e) {
          console.log(e);
          return;
        }
      }
      options.push(option);
    }
    this.options = options;
  }

  bindItemEvent() {
    var that = this;
    this._jqObj.find(".tfp-timeline-text").click(function () {
      var index = $(this).parent().parent().index();
      var option = that.options[index];
      var value = option.text;
      that.dataModel.value = value;
      that.valueOnChange();
      that.exeEventHandler("onChange", value);

      try {
        if (option.onClick) eval(option.onClick);
        if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
      } catch (err) {
        console.log(err.message);
      }
    })
  }

  initRuntime() {
    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService 
      || (this.dataModel.dataQuerySetting 
      && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
    )) {
      this.loadData();
    }
    this.reRender();
  }
}