import TFPComponentRender from '../render.js'

export default class TimeRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let iptWidth = this.dataModel.showSecond ? 62 : 42;
    let val = "";
    let pla = "";
    if (this.dataModel.value) {
      val = this.dataModel.value;
    } else if (this.dataModel.defaultNow && this._tfp.isDesigning) {
      val = this.cpt.getCurTime();
    }
    if (this.dataModel.placeHolder) {
      pla = this.dataModel.placeHolder;
    }
    html += indent + "\t<input type=\"text\" readonly style=\"width:"
      + iptWidth + "px;\" value=\"" + val + "\" placeholder=\"" + pla + "\"/>\r\n";
    if (this.cpt.showIcon) html += indent + "\t<img src=\"" + this.cpt.iconUrl + "\" />\r\n";
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}