import {FormInput} from "../controller.js";

/**
 * 时间组件
 * @param {[type]} dataModel [description]
 */
export default class Time extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Time", dataModel, parent);
  }

  //属性
  get value() { return this.dataModel.value;}
  set value(value) { 
    this.dataModel.value = value;
    if(this._jqObj) {
      this._jqObj.find("input").val(value);
    }
    if(!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get iconUrl() {
    return this._tfp.rootPath+"/src/components/time/images/icon-24-"
      +this._tfp.curPage.contentColorMode+".png";
  }
  set iconUrl(value) {}

  get showIcon() { return this.dataModel.showIcon }
  set showIcon(value) { 
    this.dataModel.showIcon = value ? true : false;
    if(this._jqObj) {
      if(this.dataModel.showIcon) {
        if(this._jqObj.find("img").length==0) {
          this._jqObj.append("<img src=\""+this.iconUrl+"\" />");
        }
      } else {
        this._jqObj.find("img").remove();
      }
      this.resetWidth();
    }
  }

  get showSecond() { return this.dataModel.showSecond }
  set showSecond(value) { 
    this.dataModel.showSecond = value ? true : false;
    if(this._jqObj) {
      this.resetWidth();
      if(this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").val(this.getCurTime());
      }
    }
  }

  get defaultNow() { return this.dataModel.defaultNow }
  set defaultNow(value) { 
    this.dataModel.defaultNow = value ? true : false;
    if(this._jqObj) {
      if(this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").val(this.getCurTime());
      } else {
        this._jqObj.find("input").val("");
      }
    }
  }

  resetWidth = function() {
    let iptWidth = this.dataModel.showSecond ? 62 : 42;
    let cptMinWidth = iptWidth;
    if(this.showIcon) cptMinWidth += 30;
    let cptWidth = cptMinWidth;
    if(this._jqObj) {
      this._jqObj.css("width", cptWidth+"px");
      this._jqObj.css("min-width", cptMinWidth+"px");
      this._jqObj.find("input").css("width", iptWidth+"px");
    }
    if(!this.dataModel.styles) this.dataModel.styles = {};
    this.dataModel.styles["width"] = cptWidth+"px";
    this.dataModel.styles["min-width"] = cptMinWidth+"px";
  }

  clear() {
    this.value = "";
    this.closePicker();
  }

  getCurTime() {
    return (new Date()).format(this.showSecond ? "HH:mm:ss" : "HH:mm");
  }
  
  render() {
    super.render();  
    if(!this.dataModel.styles || !this.dataModel.styles.width) this.resetWidth();
  }

  initRuntime() {
    let that = this;
    this._jqObj.click(function() {
      let arrVal = [];
      if(that.dataModel.value) arrVal = that.dataModel.value.split(":");
      
      let optionsList = [];

      let curHour = (new Date()).getHours();
      curHour = curHour<10 ? "0"+curHour : curHour+"";
      let hourOptions = {
        options: [],
        width: "80px",
        value: curHour
      };
      if(arrVal.length>0) hourOptions.value = arrVal[0];
      for(var i=0;i<=23;i++) {
        let hour = i<10 ? "0"+i : i+"";
        hourOptions.options.push(hour);
      }
      optionsList.push(hourOptions);
      
      let curMinute = (new Date()).getMinutes();
      curMinute = curMinute<10 ? "0"+curMinute : curMinute+"";
      let minuteOptions = {
        options: [],
        width: "80px",
        value: curMinute
      };
      if(arrVal.length>1) minuteOptions.value = arrVal[1];
      for(var i=0;i<=59;i++) {
        let day = i<10 ? "0"+i : i+"";
        minuteOptions.options.push(day);
      }
      optionsList.push(minuteOptions);

      if(that.showSecond) {
        let curSecond = (new Date()).getSeconds();
        curSecond = curSecond<10 ? "0"+curSecond : curSecond+"";
        let secondOptions = {
          options: [],
          width: "60px",
          value: curSecond
        };
        if(arrVal.length>2) secondOptions.value = arrVal[2];
        for(var i=0;i<=59;i++) {
          let day = i<10 ? "0"+i : i+"";
          secondOptions.options.push(day);
        }
        optionsList.push(secondOptions);
      }

      window.popupList.show(optionsList, function(vals) {
        let val = vals[0]+":"+vals[1];
        if(that.showSecond) val += ":"+vals[2];
        that.value = val;
      });
    });
  }
}