import { FormInput } from "../controller.js";

/**
 * 时间组件
 * @param {[type]} dataModel [description]
 */
export default class Time extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Time", dataModel, parent);
  }

  //属性
  get value() { return this.dataModel.value; }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.find("input").val(value);
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    this.dataModel.placeHolder = value;
    if (this._jqObj) this._jqObj.find("input").attr("placeholder", value);
  }

  get iconUrl() {
    return this._tfp.rootPath + "/src/components/time/images/icon-24-"
      + this._tfp.curPage.contentColorMode + ".png";
  }
  set iconUrl(value) { }

  get showIcon() { return this.dataModel.showIcon }
  set showIcon(value) {
    this.dataModel.showIcon = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.showIcon) {
        if (this._jqObj.find("img").length == 0) {
          this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
        }
      } else {
        this._jqObj.find("img").remove();
      }
      this.resetWidth();
    }
  }

  get showSecond() { return this.dataModel.showSecond }
  set showSecond(value) {
    this.dataModel.showSecond = value ? true : false;
    if (this._jqObj) {
      this.resetWidth();
      if (this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").val(this.getCurTime());
      }
    }
  }

  get defaultNow() { return this.dataModel.defaultNow }
  set defaultNow(value) {
    this.dataModel.defaultNow = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").val(this.getCurTime());
      } else {
        this._jqObj.find("input").val("");
      }
    }
  }

  resetWidth = function () {
    //如果当前组件的宽度设置为了100%，则不要因为是否显示图标、是否显示秒等参数变化而改变宽度
    if (this.dataModel.styles && this.dataModel.styles["width"] == "100%") return;
    let iptWidth = this.dataModel.showSecond ? 68 : 48;
    let cptMinWidth = iptWidth;
    if (this.showIcon) cptMinWidth += 30;
    let cptWidth = cptMinWidth;
    if (this._jqObj) {
      if (this.dataModel.styles["width"] != "100%") this._jqObj.css("width", cptWidth + "px");
      this._jqObj.css("min-width", cptMinWidth + "px");
      this._jqObj.find("input").css("width", iptWidth + "px");
    }
    if (!this.dataModel.styles) this.dataModel.styles = {};
    if (this.dataModel.styles["width"] != "100%") this.dataModel.styles["width"] = cptWidth + "px";
    this.dataModel.styles["min-width"] = cptMinWidth + "px";
  }

  clear() {
    this.value = "";
    this.closePicker();
  }

  closePicker() {
    $(".tfp-time-picker").remove();
    $("body").unbind("click", this.closePicker);
  }

  showPicker() {
    let offset = this._jqObj.offset();
    let colorClass = 'tfp-time-picker-bgcolor';
    let html = "<div class=\"tfp-time-picker\" data-cptid=\"" + this.id + "\" "
      + "style=\"width: " + (this.showSecond ? 164 : 110) + "px; top: "
      + (offset.top + 31) + "px; left:" + offset.left + "px; display:none;\">";
    let vals = [];
    if (this.dataModel.value) {
      vals = this.dataModel.value.split(":");
    } else {
      vals = this.getCurTime().split(":");
    }
    html += "<ul data-value=\"" + vals[0] + "\">";
    for (var i = 0; i < 24; i++) {
      let hour = i < 10 ? "0" + i : i + "";
      html += "<li";
      if (hour == vals[0]) html += " class=\"" + colorClass + "\" style=\"color: #FFFFFF;\"";
      html += ">" + hour + "</li>";
    }
    html += "</ul>";
    html += "<ul data-value=\"" + vals[1] + "\">";
    for (var i = 0; i < 60; i++) {
      let minute = i < 10 ? "0" + i : i + "";
      html += "<li";
      if (minute == vals[1]) html += " class=\"" + colorClass + "\" style=\"color: #FFFFFF;\"";
      html += ">" + minute + "</li>";
    }
    html += "</ul>";
    if (this.showSecond) {
      html += "<ul data-value=\"" + vals[2] + "\">";
      for (var i = 0; i < 60; i++) {
        let second = i < 10 ? "0" + i : i + "";
        html += "<li";
        if (second == vals[2]) html += " class=\"" + colorClass + "\" style=\"color: #FFFFFF;\"";
        html += ">" + second + "</li>";
      }
      html += "</ul>";
    }
    html += "<div class=\"tfp-time-picker-footer\"><span>清空</span>"
      + "<input type=\"button\" value=\"确定\" /></div>";
    html += "</div>";
    $("body").append(html);
    let timePicker = $(".tfp-time-picker");
    timePicker.fadeIn("slow");
    timePicker.bind("click", function () {
      event.stopPropagation();
    });
    timePicker.find("ul").each(function () {
      $(this).find("li").each(function () {
        $(this).click(function () {
          $(this).parent().find("li").attr("class", "");
          $(this).parent().find("li").css("color", "");
          $(this).attr("class", "tfp-time-picker-bgcolor");
          $(this).css("color", "#FFFFFF");
          $(this).parent().attr("data-value", $(this).html());
        });
      });
      $(this).get(0).scrollTop = parseInt($(this).attr("data-value") * 25);
    });
    let that = this;
    let footer = timePicker.find(".tfp-time-picker-footer");
    footer.find("span").click(function () {
      that.clear();
    });
    footer.find("input").click(function () {
      that.onCheckTime();
    });
    $("body").bind("click", this.closePicker);
  }

  onCheckTime() {
    let timePicker = $(".tfp-time-picker");
    let val = timePicker.find("ul").eq(0).attr("data-value");
    val += ":" + timePicker.find("ul").eq(1).attr("data-value");
    if (this.showSecond) val += ":" + timePicker.find("ul").eq(2).attr("data-value");
    this.value = val;
    this.closePicker();
  }

  getCurTime() {
    return (new Date()).format(this.showSecond ? "HH:mm:ss" : "HH:mm");
  }

  render() {
    super.render();

    if (!this.dataModel.styles || !this.dataModel.styles.width) this.resetWidth();
  }

  initRuntime() {
    let that = this;

    if (this.readonly) {
      this._jqObj.find("input").css("padding-left", "0px");
    }

    this._jqObj.click(function () {
      if (that.dataModel.readonly || that.dataModel.disabled) return;
      if ($(".tfp-time-picker").length > 0) {
        let cptId = $(".tfp-time-picker").attr("data-cptid");
        if (cptId == that.dataModel.id) return;
        that.closePicker();
      }
      that.showPicker();
      event.stopPropagation();
    });
    if (this.dataModel.defaultNow && !this.dataModel.value) {
      this.dataModel.value = this.getCurTime();
      this._jqObj.find("input").val(this.dataModel.value);
    }
    this._jqObj.find("input").focus(function () {
      if (that.disabled) return;
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    })

    this._jqObj.find("input").blur(function () {
      if (that.disabled) return;
      try {
        if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
      } catch (err) {
        console.log(err.message);
      }
    })
  }
}