import TFPComponentRender from '../render.js'

export default class TextAreaRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr, otherOptions) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);

    if (this._tfp.isDesigning && attrHtml.indexOf("readonly") < 0)
      attrHtml += " readonly";

    if (!this._tfp.isDesigning) {
      var vid = escape(this.dataModel.id).replaceAll("%", "");
      if (otherOptions && otherOptions.gridContainer) {
        attrHtml += " name=\"" + this.dataModel.id + "_{{index}}\"";
        attrHtml += " value=\"{{item." + vid + "}}\"";
      }
      else {
        attrHtml += " name=\"" + this.dataModel.id + "\"";
        attrHtml += " value=\"{{" + vid + "}}\"";
      }

      // attrHtml += " value=\"{{" + this.dataModel.id + "}}\" bindinput=\"bindinput_controller\"";
      attrHtml += " bindinput=\"bindinput_controller\"";
    }

    return attrHtml;
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    if (this._tfp.isDesigning) {
      if (this.dataModel.value) return this.dataModel.value;
    }
    return "";
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }

    //cpt_wx.wxml = "{{" + this.dataModel.id + "}}";
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("textarea", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("textarea", false, parentIndent, retainStyleAttr, otherOptions);
  }
}