import TFPComponentRender from '../render.js'

export default class TextAreaRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);
    if(this._tfp.isDesigning && attrHtml.indexOf("readonly")<0) 
      attrHtml += " readonly";
    return attrHtml;
  }

  getBodyHtml(getComponentsHtml) {
    // if(this.value) return this.value;
    if (this.dataModel.value) return this.dataModel.value;
    return "";
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("textarea", false, parentIndent, retainStyleAttr);
  }
}