import { FormInput } from "../controller.js";

/**
 * 多行文本组件
 * @param {[type]} dataModel [description]
 */
export default class TextArea extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "TextArea", dataModel, parent);
  }

  get value () {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value (value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.val(value);
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }
  get placeholder () { return this.dataModel.placeholder }
  set placeholder (value) {
    this.dataModel.placeholder = value;
  }
  get disabled () { return this.dataModel.disabled }
  set disabled (value) {
    this.dataModel.disabled = value;
  }

  get maxlength () { return this.dataModel.maxlength }
  set maxlength (value) {
    this.dataModel.maxlength = value;
  }
  get autoHeight () { return this.dataModel.autoHeight }
  set autoHeight (value) {
    this.dataModel.autoHeight = value;
  }

  initRuntime () {
    let that = this;
    this._jqObj.change(function () {
      that.dataModel.value = that._jqObj.val();
      that.valueOnChange();
      that.exeEventHandler("onChange", that.dataModel.value);
    });
  }
}