import { FormInput } from "../controller.js";

/**
 * 多行文本组件
 * @param {[type]} dataModel [description]
 */
export default class TextArea extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "TextArea", dataModel, parent);
  }

  get value() {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.val(value);
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  /*get cols() { return this.dataModel.cols }
  set cols(value) { 
    this.dataModel.cols = value;
    if(this._jqObj) this._jqObj.attr("cols", value);
  }

  get rows() { return this.dataModel.rows }
  set rows(value) { 
    this.dataModel.rows = value;
    if(this._jqObj) this._jqObj.attr("rows", value);
  }*/

  get maxLength() { return this.dataModel.maxLength }
  set maxLength(value) {
    this.dataModel.maxLength = value;
    if (this._jqObj) this._jqObj.attr("maxlength", value);
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    this.dataModel.placeHolder = value;
    if (this._jqObj) this._jqObj.attr("placeholder", value);
  }

  get format() { return this.dataModel.format }
  set format(value) {
    this.dataModel.format = value;
  }

  initRuntime() {
    let that = this;
    
    if (that.dataModel.readonly) {
      this._jqObj.attr("readonly", "readonly");
    } else if (that.dataModel.disabled) {
      this._jqObj.attr("disabled", "disabled");
      return;
    }

    this._jqObj.change(function () {

      // 文本验证
      const verify = that.dataModel.verify;
      if (verify && typeof verify == 'object' && verify.verify && verify.verifyMsg) {
        const el = this;
        const jqObj = $(this);
        const reg = new RegExp(verify.verify);
        const tooltipId = 'tfp-tooltip-' + that.dataModel.id;
        // 判断文本验证是否通过
        if (!reg.test(val.toString())) {
          // 找到上一个浮动元素
          const _parent = $(el.offsetParent);
          if (!el.dataset.inputerror) jqObj.attr('data-bordercolor', jqObj.css('border-color'));
          if (_parent.css('position') == 'static' || !_parent.css('position')) _parent.css('position', 'relative');
          if ($('#' + tooltipId).length > 0) $('#' + tooltipId).remove();
          // 创建提示框元素
          const _tooltip = $('<div>', { 'id': tooltipId }).css({
            'position': 'absolute',
            'display': 'none',
            'margin': '0px',
            'padding': '8px 11px',
            'border': '1px solid #f56c6c',
            'border-radius': '4px',
            'font-size': '12px',
            'line-height': '12px',
            'color': '#606266',
            'white-space': 'nowrap',
          }).html(verify.verifyMsg).append($('<div>').css({
            'position': 'absolute',
            'top': '23px',
            'right': '20px',
            'width': '12px',
            'height': '12px',
            'background': '#fff',
            'border': '1px solid #f56c6c',
            'border-top': '0px',
            'border-left': '0px',
            'transform': 'rotate(45deg)',
            'border-radius': '0px 0px 4px 0px',
          }));
          // 将元素先添加到body中用于计算宽度
          $('body').append(_tooltip.css('top', '-10000px').show());
          // 计算出提示框元素应在的位置
          _tooltip.css({
            'top': (el.offsetTop - 40) + 'px',
            'left': (el.offsetLeft + el.offsetWidth - _tooltip[0].offsetWidth) + 'px',
          }).hide();
          // 将提示框渐显
          _parent.append(_tooltip.fadeIn(300, 'linear'));
          // 将文本控件添加红色边框
          jqObj.css('border-color', '#f56c6c').attr('data-inputerror', 'true');
          // 设置提示框定时关闭
          setTimeout(function () {
            _tooltip.fadeOut(300, 'linear', function () { $(this).remove(); });
          }, 2000);
        }
      }

      that.dataModel.value = that._jqObj.val();
      that.valueOnChange();
      that.exeEventHandler("onChange", that.dataModel.value);
    });

    // 监听输入框的输入事件
    this._jqObj.keypress(function (e) {
      // 如果输入框之前输入错误时校验当前输入是否符合文本验证规则
      if (this.dataset.inputerror) {
        const verify = that.dataModel.verify;
        var reg = new RegExp(verify.verify);
        // 如果符合验证规则则删除错误标志和红色表框
        if (reg.test(this.value + e.key)) {
          $(this).css('border-color', this.dataset.bordercolor).removeAttr('data-inputerror').removeAttr('data-bordercolor');
        }
      }
    });

    // 监听输入框的改变事件
    this._jqObj.change(function (e) {
      // 如果输入框之前输入错误时校验当前输入是否符合文本验证规则
      if (this.dataset.inputerror) {
        const verify = that.dataModel.verify;
        var reg = new RegExp(verify.verify);
        // 如果符合验证规则则删除错误标志和红色表框
        if (!this.value || reg.test(this.value)) {
          $(this).css('border-color', this.dataset.bordercolor).removeAttr('data-inputerror').removeAttr('data-bordercolor');
        }
      }
    });
  }
}