import TFPComponentRender from '../render.js'

export default class TextRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr, otherOptions) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);
    // attrHtml += " type=\"text\"";
    if (this._tfp.isDesigning && attrHtml.indexOf("readonly") < 0)
      attrHtml += " readonly";

    if (this.dataModel.type == "Password")
      attrHtml += " password=\"true\"";

    if (!this._tfp.isDesigning) {
      var vid = escape(this.dataModel.id).replaceAll("%", "");
      if (otherOptions && otherOptions.gridContainer) {
        attrHtml += " name=\"" + this.dataModel.id + "_{{index}}\"";
        attrHtml += " value=\"{{item." + vid + "}}\"";
      }
      else {
        attrHtml += " name=\"" + this.dataModel.id + "\"";
        attrHtml += " value=\"{{" + vid + "}}\"";
      }
      attrHtml += " bindinput=\"bindinput_controller\"";
    }
    else {
      if (this.dataModel.value) attrHtml += " value=\"" + this.dataModel.value + "\"";
    }

    return attrHtml;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("input", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("input", false, parentIndent, retainStyleAttr, otherOptions);
  }
}