import TFPComponentRender from '../render.js'

export default class TextRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml() {
    if (this.dataModel.icon) {
      let html = "\r\n";
      let indent = this.getHtmlIndent();
      let val = "";
      let pal = "";
      let imgUrl = "";
      let inpWidth = "";
      if (this.dataModel.value) val = this.dataModel.value;
      if (this.dataModel.placeHolder) pal = this.dataModel.placeHolder;
      imgUrl = this._tfp.getUrlRealPath(this.dataModel.icon);
      inpWidth = "width:calc(100% - 30px);"
      html += indent + "\t<input type=\"text\" value =\"" + val + "\" placeholder=\"" + pal + "\" style=\"" + inpWidth + "\"";
      if (this._tfp.isDesigning)
        html += " readonly";
      html += ">\r\n";
      if (this.dataModel.icon) html += indent + "\t<img src=\"" + imgUrl + "\" >\r\n";
      return html + indent;
    } else {
      return "";
    }
  }

  getAttrHtml(retainStyleAttr) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);
    if (!this.dataModel.icon) {
      attrHtml += " type=\"text\"";
      if (this._tfp.isDesigning && attrHtml.indexOf("readonly") < 0)
        attrHtml += " readonly";
      return attrHtml;
    }
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    if (this.dataModel.icon) {
      return super.getHtml("div", false, parentIndent, retainStyleAttr);
    } else {
      return super.getHtml("input", false, parentIndent, retainStyleAttr, true);
    }
  }
}