export default {
  "name": "Text",
  "comment": "单行文本",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "default": "{id}",
      "items": [
        {
          "name": "value",
          "comment": "文本内容",
          "type": "String"
        },
        {
          "name": "dataType",
          "comment": "数据类型",
          "type": "Select",
          "attrName": "type",
          "options": [
            {
              "value": "text",
              "text": "文本"
            },
            {
              "value": "number",
              "text": "整数"
            },
            {
              "value": "digit",
              "text": "小数"
            },
            {
              "value": "idcard",
              "text": "身份证"
            },
            {
              "value": "safe-password",
              "text": "安全密码输入"
            },
            {
              "value": "nickname",
              "text": "昵称输入"
            }
          ]
        },
        {
          "name": "confirm-type",
          "comment": "键盘右下角文字(仅文本)",
          "type": "Select",
          "isHtmlAttr": true,
          "options": [
            {
              "value": "send",
              "text": "发送"
            },
            {
              "value": "search",
              "text": "搜索"
            },
            {
              "value": "next",
              "text": "下一个"
            },
            {
              "value": "go",
              "text": "前往"
            }, {
              "value": "done",
              "text": "完成"
            }
          ]
        },
        {
          "name": "placeholder",
          "comment": "输入提示",
          "type": "String",
          "isHtmlAttr": true,
        },
        {
          "name": "maxlength",
          "comment": "最大长度",
          "type": "Int",
          "isHtmlAttr": true,
        },
        {
          "name": "confirmHold",
          "comment": "点击右下角键盘不收起",
          "type": "Switch",
          "isHtmlAttr": true,
          "attrName": "confirm-hold"
        },
        {
          "name": "adjustPosition",
          "comment": "是否自动上推页面",
          "type": "Switch",
          "isHtmlAttr": true,
          "attrName": "adjust-position"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "formula",
          "comment": "自动计算表达式",
          "type": "Formula"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
  },
  "events": [
    {
      "name": "bindfocus",
      "args": [{ 'name': 'e' }],
      "eventArgs": "",
      "comment": "获取焦点时"
    },
    {
      "name": "bindblur",
      "args": [{ 'name': 'e' }],
      "eventArgs": "",
      "comment": "失去焦点时"
    }
  ]
}