export default {
  "name": "Text",
  "comment": "单行文本",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "文本内容",
          "type": "String",
          "isHtmlAttr": true
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "placeHolder",
          "comment": "输入提示",
          "type": "String",
          "isHtmlAttr": true
        },
        {
          "name": "icon",
          "comment": "图标",
          "type": "PathPicker",
          "fileTypes": ["image"]
        },
        {
          "name": "dataType",
          "comment": "数据类型",
          "type": "Select",
          "default": "text",
          "options": [
            {
              "value": "text",
              "text": "文本"
            },
            {
              "value": "int",
              "text": "整数"
            },
            {
              "value": "float",
              "text": "小数"
            },
            {
              "value": "money",
              "text": "金额"
            }
          ]
        },
        {
          "name": "maxLength",
          "comment": "最大长度",
          "type": "Int",
          "isHtmlAttr": true,
          "hidden": "'{dataType}'!='text'"
        },
        {
          "name": "subDataType",
          "comment": "文本类型",
          "type": "Select",
          "options": [
            {
              "value": "phone",
              "text": "手机号"
            },
            {
              "value": "telephone",
              "text": "固定电话"
            },
            {
              "value": "postalCode",
              "text": "邮政编码"
            },
            {
              "value": "idCard",
              "text": "身份证号"
            },
            {
              "value": "email",
              "text": "邮箱"
            },
            {
              "value": "licensePlate",
              "text": "车牌号"
            }
          ],
          "hidden": "'{dataType}'!='text'"
        },
        {
          "name": "verify",
          "comment": "文本验证",
          "type": "Verify",
          "hidden": "!('{dataType}'=='text' && '{subDataType}'=='')"
        },
        {
          "name": "precise",
          "comment": "精度",
          "type": "Int",
          "hidden": "'{dataType}'!='float'"
        },
        {
          "name": "min",
          "comment": "最小值",
          "type": "Int",
          "isHtmlAttr": true,
          "hidden": "'{dataType}'=='text'"
        },
        {
          "name": "max",
          "comment": "最大值",
          "type": "Int",
          "isHtmlAttr": true,
          "hidden": "'{dataType}'=='text'"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "formula",
          "comment": "自动计算表达式",
          "type": "Formula"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "encrypted",
          "comment": "加密发送",
          "type": "Switch"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "120px",
    "height": "30px",
    "line-height": "30px",
    "padding-left": "2px",
    "padding-right": "2px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时",
      "isNotHtmlEvent": true
    }, {
      "name": "onDblClick",
      "comment": "双击时",
      "isNotHtmlEvent": true
    }, {
      "name": "onFocus",
      "comment": "获得焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onBlur",
      "comment": "失去焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onKeyDown",
      "comment": "按下按键时",
      "isNotHtmlEvent": true
    }, {
      "name": "onKeyPress",
      "comment": "按下并松开按键时",
      "isNotHtmlEvent": true
    }, {
      "name": "onKeyUp",
      "comment": "松开按键时",
      "isNotHtmlEvent": true
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }]
}