import { FormInput } from "../controller.js";

/**
 * 单行文本组件
 * @param {[type]} dataModel [description]
 */
export default class Text extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "Text", dataModel, parent);
    }
  }

  get value() {
    if (this._jqObj) {
      this.dataModel.value = this.dataModel.icon ? this._jqObj.find("input").val() : this._jqObj.val();
    }
    if (this.dataModel.value || this.dataModel.value == 0) return this.dataModel.value;
    return "";
  }
  set value(value) {
    let val = value;
    if (isNull(value)) {
      val = "";
      this.dataModel.value = null;
    } else {
      //如果设置了计算公式，则需要替换掉金额里的逗号
      if (this.dataModel.formula) {
        val = (val + "").trim().replaceAll(",", "");
        if (isNaN(val)) return;
      }
      this.dataModel.value = this.formatValue(val);
      val = this.dataModel.value;
      if(isNull(val)) val = "";
    }

    if (this._jqObj) {
      if (this.dataModel.icon) {
        this._jqObj.find("input").val(val);
      } else {
        this._jqObj.val(val);

      }
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", val);
    }
  }

  get maxLength() { return this.dataModel.maxLength }
  set maxLength(value) {
    this.dataModel.maxLength = value;
    if (this._jqObj) {
      if (this.dataModel.icon) {
        this._jqObj.find("input").attr("maxlength", value);
      } else {
        this._jqObj.attr("maxlength", value);
      }
    }
  }

  get precise() { return this.dataModel.precise }
  set precise(value) {
    this.dataModel.precise = value;
  }

  get min() { return this.dataModel.min }
  set min(value) {
    this.dataModel.min = value;
    if (this._jqObj) {
      if (this.dataModel.icon) {
        this._jqObj.find("input").attr("min", value);
      } else {
        this._jqObj.attr("min", value);
      }
    }
  }

  get max() { return this.dataModel.max }
  set max(value) {
    this.dataModel.max = value;
    if (this._jqObj) {
      if (this.dataModel.icon) {
        this._jqObj.find("input").attr("max", value);
      } else {
        this._jqObj.attr("max", value);
      }
    }
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    this.dataModel.placeHolder = value;
    if (this._jqObj) {
      if (this.dataModel.icon) {
        this._jqObj.find("input").attr("placeholder", value);
      } else {
        this._jqObj.attr("placeholder", value);
      }
    }
  }

  get icon() { return this.dataModel.icon }
  set icon(value) {
    this.dataModel.icon = value;
    if (!isNull(value)) {
      let imgHtml = '';
      let imgUrl = this._tfp.getUrlRealPath(value);
      imgHtml = "<img src=\"" + imgUrl + "\">"
      if (this._jqObj) {
        this._jqObj.find("input").css("width", "calc(100% - 30px)");
        this._jqObj.find("img").remove();
        this._jqObj.append(imgHtml);
      }
    } else {
      if (this._jqObj.find("img").length > 0) {
        if (this._jqObj) {
          this._jqObj.find("input").css("width", "100%");
          this._jqObj.find("img").remove();
        }
      }
    }
  }

  get dataType() {
    if (!this.dataModel.dataType) this.dataModel.dataType = "text";
    return this.dataModel.dataType;
  }
  set dataType(value) {
    this.dataModel.dataType = value;
  }

  get subDataType() {
    if (!this.dataModel.subDataType) this.dataModel.subDataType = "";
    return this.dataModel.subDataType;
  }
  set subDataType(value) {
    this.dataModel.subDataType = value;
  }

  formatValue(value) {
    const dataType = this.dataModel.dataType;
    const isNumber = ['int', 'float', 'money'].includes(dataType);
    if (isNull(value)) return null;
    if (isNumber && isNaN(value)) return null;
    let val = value;
    if (isNumber) {
      var min = parseFloat(this.dataModel.min);
      var max = parseFloat(this.dataModel.max);
      if (!isNaN(min) && val < parseFloat(min)) {
        val = parseFloat(min);
      }
      if (!isNaN(max) && val > parseFloat(max)) {
        val = parseFloat(max);
      }
      const precise = parseInt(this.dataModel.precise);
      if (dataType == 'int') {
        val = parseInt(parseFloat(val).toFixed(0));
      }
      else if (dataType == 'float') {
        val = parseFloat(val);
        if (!isNaN(precise) && precise >= 0) {
          val = parseFloat(val.toFixed(precise));
        }
      }
      else if (dataType == 'money') {
        if (!isNaN(precise) && precise >= 0) {
          val = this._tfp.formatMoney(val, precise);
        } else {
          val = this._tfp.formatMoney(val, 2);
        }
      }
    }
    return val;
  }

  initRuntime() {
    const that = this;

    const inputEl = that.dataModel.icon ? that._jqObj.find("input") : that._jqObj;
    const dataType = that.dataModel.dataType;
    const isNumber = ['int', 'float', 'money'].includes(dataType);

    if (isNumber) {
      inputEl.attr('type', 'number');
      if (that.dataModel.min) inputEl.attr('min', that.dataModel.min);
      if (that.dataModel.max) inputEl.attr('max', that.dataModel.max);
    }

    if (that.dataModel.readonly) {
      inputEl.attr("readonly", "readonly");
    } else if (that.dataModel.disabled) {
      inputEl.find("input").attr("disabled", "disabled");
    }

    inputEl.click(function () {
      if(that.dataModel.disabled) return;
      try {
        if (that.dataModel.onClick) eval(that.dataModel.onClick);
      } catch (err) {
        console.log(err.message);
      }
    });

    inputEl.dblclick(function () {
      if(that.dataModel.disabled) return;
      try {
        if (that.dataModel.onDblClick) eval(that.dataModel.onDblClick);
      } catch (err) {
        console.log(err.message);
      }
    });

    inputEl.focus(function () {
      if(that.dataModel.readonly || that.dataModel.disabled) return;
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    });

    inputEl.blur(function () {
      if(that.dataModel.readonly || that.dataModel.disabled) return;

      let val = $(this).val().trim();
      if (isNull(val)) return next();

      if (isNumber) try {
        if (isNaN(val)) {
          that._tfp.showBubble(that, `输入有误`, { changeBorder: false });
          return next();
        }

        const min = parseFloat(that.dataModel.min);
        const max = parseFloat(that.dataModel.max);

        if (!isNaN(min) && parseFloat(val) < min) {
          val = min;
          that._tfp.showBubble(that, `输入最小为${min}`, { changeBorder: false });
          return next();
        }
        if (!isNaN(max) && parseFloat(val) > max) {
          val = max;
          that._tfp.showBubble(that, `输入最大为${max}`, { changeBorder: false });
          return next();
        }

        val = that.formatValue(val);
      } catch (err) {
        console.error(err.message);
        // $(this).focus();
        that._tfp.showBubble(that, `输入有误`, { changeBorder: false });
        return next();
      }

      return next();

      function next() {
        that.value = val;
        try {
          if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
        } catch (err) {
          console.log(err.message);
        }
      }
    });

    inputEl.keydown(function () {
      if(that.dataModel.readonly || that.dataModel.disabled) return;
      try {
        if (that.dataModel.onKeyDown) eval(that.dataModel.onKeyDown);
      } catch (err) {
        console.log(err.message);
      }
    });

    inputEl.keyup(function () {
      if(that.dataModel.readonly || that.dataModel.disabled) return;
      try {
        if (that.dataModel.onKeyUp) eval(that.dataModel.onKeyUp);
      } catch (err) {
        console.log(err.message);
      }
    });

    inputEl.keypress(function () {
      if(that.dataModel.readonly || that.dataModel.disabled) return;
      try {
        if (that.dataModel.onKeyPress) eval(that.dataModel.onKeyPress);
      } catch (err) {
        console.log(err.message);
      }
    });
  }
}