import TFPComponentRender from '../render.js'

export default class TableRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    for(let i=0;i<this.dataModel.rows.length;i++) {
      let row = this.dataModel.rows[i];
      bodyHtml += indent+"<tr height=\""+row.height+"\">\r\n";
      for(let j=0;j<row.cells.length;j++) {
        let cell = row.cells[j];
        bodyHtml += indent+"\t<td";
        if(cell.rows>1) bodyHtml += " rowspan=\""+cell.rows+"\"";
        if(cell.cols>1) bodyHtml += " colspan=\""+cell.cols+"\"";
        if(cell.align) bodyHtml += " align=\""+cell.align+"\"";
        if(cell.valign) bodyHtml += " align=\""+cell.valign+"\"";
        let width = this.dataModel.columns[j].width+"";
        if(width.indexOf("%")<0) width += "px";
        bodyHtml += " style=\"width:"+width+";";
        if(this.dataModel.borderWidth && (this.dataModel.borderWidth+'')!='0') {
          let borderStyle = this.dataModel.borderWidth+"px solid "+(this.dataModel.borderColor ? this.dataModel.borderColor : "#000000");
          if(cell.borderBottomWidth) {
            bodyHtml += "border-bottom:"+cell.borderBottomWidth+"px "+cell.borderBottomStyle+" #000000;";
          } else {
            bodyHtml += "border-bottom:"+borderStyle+";";
          }
          if(cell.borderRightWidth) {
            bodyHtml += "border-right:"+cell.borderRightWidth+"px "+cell.borderRightStyle+" #000000;";
          } else {
            bodyHtml += "border-right:"+borderStyle+";";
          }
          if(cell.borderTopWidth) {
            bodyHtml += "border-top:"+cell.borderTopWidth+"px "+cell.borderTopStyle+" #000000;";
          } else if(i==0) {
            bodyHtml += "border-top:"+borderStyle+"; ";
          }
          if(cell.borderLeftWidth) {
            bodyHtml += "border-left:"+cell.borderLeftWidth+"px "+cell.borderLeftStyle+" #000000;";
          } else if(j==0) {
            bodyHtml += "border-left:"+borderStyle+"; ";
          }
        } else {
          if(cell.borderTopWidth && (cell.borderTopWidth+'')!='0') {
            bodyHtml += "border-top:"+cell.borderTopWidth+"px "+cell.borderTopStyle+" #000000;";
          } else if(this._tfp.isDesigning && i==0) {
            bodyHtml += "border-top:1px dashed #CCCCCC;";
          }
          if(cell.borderBottomWidth && (cell.borderBottomWidth+'')!='0') {
            bodyHtml += "border-bottom:"+cell.borderBottomWidth+"px "+cell.borderBottomStyle+" #000000;";
          } else if(this._tfp.isDesigning) {
            bodyHtml += "border-bottom:1px dashed #CCCCCC;";
          }
          if(cell.borderLeftWidth && (cell.borderLeftWidth+'')!='0') {
            bodyHtml += "border-left:"+cell.borderLeftWidth+"px "+cell.borderLeftStyle+" #000000;";
          } else if(this._tfp.isDesigning && j==0) {
            bodyHtml += "border-left:1px dashed #CCCCCC;";
          }
          if(cell.borderRightWidth && (cell.borderRightWidth+'')!='0') {
            bodyHtml += "border-right:"+cell.borderRightWidth+"px "+cell.borderRightStyle+" #000000;";
          } else if(this._tfp.isDesigning) {
            bodyHtml += "border-right:1px dashed #CCCCCC;";
          }
        }
        if(this.dataModel.cellPadding) bodyHtml += "padding:"+this.dataModel.cellPadding+"px;";
        if(cell.hidden) bodyHtml += "display:none;"
        if(cell.bgColor) bodyHtml += "background-color:"+cell.bgColor+";"
        bodyHtml += "\">";
        if(cell.components && cell.components.length>0) {
            cell.components.forEach(cptId => {
              this.dataModel.components.forEach(cdmChild => {
                if(cdmChild.id==cptId) {
                  if(this._tfp.isDesigning || !this._tfp.get(cdmChild.id) //|| (this._tfp.curPage.pageType=="print-report")
                    ) {
                    cdmChild.tableCellRowIndex = i;
                    cdmChild.tableCellColIndex = j;
                  } else {
                    let Render = this._tfp.renders[cdmChild.type];
                    if (!Render) return;
                    let render = new Render(this._tfp, cdmChild, this.level + 1);
                    bodyHtml += render.getHtml(getComponentsHtml, indent, true);
                  }
                }
              });
            });
        }
        bodyHtml += "</td>\r\n";
      }
      bodyHtml += indent+"</tr>\r\n";
    }
    return bodyHtml + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("table", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}