export default {
  "name": "Table",
  "comment": "普遍表格",
  "cssFiles": [
    "style.css"
  ],
  "attrs": [
    {
      "name": "tableSetting",
      "comment": "表格设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "allowPage",
          "comment": "多条数据分多页显示",
          "type": "Switch",
          "default": false,
          "isPrint": true
        },
        {
          "name": "mainTableKeyField",
          "comment": "主表主键字段",
          "type": "String",
          "isPrint": true
        },
        {
          "name": "borderWidth",
          "comment": "边框宽度",
          "type": "Int",
          "default": 1
        },
        {
          "name": "borderColor",
          "comment": "边框颜色",
          "type": "Color",
          "default": "#000000"
        }]
    },
    {
      "name": "dynamicRowSetting",
      "comment": "动态行设置",
      "type": "group",
      "items": [
        {
          "name": "dynamicRowDataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px",
          "isDataBindSetting": true
        },
        {
          "name": "dynamicRowStartIndex",
          "comment": "起始行索引",
          "type": "Int"
        },
        {
          "name": "dynamicRowEndIndex",
          "comment": "结束行索引",
          "type": "Int"
        },
        {
          "name": "associatedMainTableField",
          "comment": "明细表关联主表字段",
          "type": "String",
          "isPrint": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "font-size": "0"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    },
    {
      "name": "onAfterBindData",
      "comment": "绑定数据后",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "data",
          "comment": "绑定的数据",
          "type": "Array"
        }
      ]
    },
    {
      "name": "onCellClick",
      "comment": "单击单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellJqObj",
          "comment": "单元格jQuery对象",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellDblClick",
      "comment": "双击单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellJqObj",
          "comment": "单元格jQuery对象",
          "type": "Object"
        }
      ]
    }, {
      "name": "onCellMouseOver",
      "comment": "鼠标经过单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellJqObj",
          "comment": "单元格jQuery对象",
          "type": "Object"
        }
      ]
    }, {
      "name": "onCellMouseOut",
      "comment": "鼠标移出单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellJqObj",
          "comment": "单元格jQuery对象",
          "type": "Object"
        }
      ]
    }]
}