function TableDesigner() {
    this.selectedTableTds = null;
    this.pageDesigner = null;

    this.showTableRowSetting = function () {
        event.stopPropagation();
        $("#divTableColSetting").hide();
        let offset = $("#divTableToolBar").find(".row-setting").offset();
        $("#divTableRowSetting").css("top", (offset.top + 28) + "px");
        $("#divTableRowSetting").css("left", offset.left + "px");
        $("#divTableRowSetting").css("display", "flex");
    }

    this.showTableColSetting = function () {
        event.stopPropagation();
        $("#divTableRowSetting").hide();
        let offset = $("#divTableToolBar").find(".col-setting").offset();
        $("#divTableColSetting").css("top", (offset.top + 28) + "px");
        $("#divTableColSetting").css("left", offset.left + "px");
        $("#divTableColSetting").css("display", "flex");
    }

    this.talebMoveIconOnClick = function () {
        event.stopPropagation();
    }

    this.talebMoveIconOnMouseDown = function () {
        if (!uiDesigner.curSelectedCptId) return;
        event.stopPropagation();
        $("#divTableRowSetting").hide();
        $("#divTableColSetting").hide();
        let offset = $("#" + uiDesigner.curSelectedCptId).offset();
        this.pageDesigner.mouseInfo.offset = [{
            top: offset.top,
            left: offset.left
        }];
        //获得鼠标按下的坐标
        this.pageDesigner.mouseInfo.downX = event.clientX;
        this.pageDesigner.mouseInfo.downY = event.clientY;
        //如果没有设置拖拽类型，则默认为移动组件
        this.pageDesigner.mouseInfo.dragType = "MoveComponent";
        this.pageDesigner.mouseInfo.cptId = uiDesigner.curSelectedCptId;
        //先不要设置为正在拖拽，只有当鼠标上下移动的位置超过一定范围后才能算是移动，否则点击选中组件也会造成组件移动
        this.pageDesigner.mouseInfo.isDrag = false;
        this.pageDesigner.mouseInfo.haveAddOperation = false;  //是否已经添加操作记录
    }

    this.unSelectTable = function () {
        if (!this.selectedTableTds) return;
        $("#divTableToolBar").hide();
        $("#divTableRowSetting").hide();
        $("#divTableColSetting").hide();
        $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").children("td").css("background", "");
        this.selectedTableTds = null;
    }

    this.tableTdOnMouseDown = function (tableId, td) {
        event.stopPropagation();
        $("#divTableRowSetting").hide();
        $("#divTableColSetting").hide();
        $("#" + tableId).children("tbody").children("tr").children("td").css("background", "");
        $(td).css("background", "#C9EFFB");
        this.selectedTableTds = {
            tableId: tableId,
            srcRowIndex: $(td).parent().index(),
            srcColIndex: $(td).index(),
            srcRowSpan: 1,
            srcColSpan: 1,
            curRowIndex: $(td).parent().index(),
            curColIndex: $(td).index(),
            isDrag: false
        };
        let rowSpan = $(td).attr("rowspan");
        if (rowSpan && parseInt(rowSpan) > 1) this.selectedTableTds.srcRowSpan = parseInt(rowSpan);
        let colSpan = $(td).attr("colspan");
        if (colSpan && parseInt(colSpan) > 1) this.selectedTableTds.srcColSpan = parseInt(colSpan);
        if ((rowSpan && parseInt(rowSpan) > 1) || (colSpan && parseInt(colSpan) > 1)) return;
        this.selectedTableTds.isDrag = true;
    }

    this.tableTdOnMouseMove = function (tableId, td) {
        if (!this.selectedTableTds || !this.selectedTableTds.isDrag) return;
        let curRowIndex = $(td).parent().index();
        let curColIndex = $(td).index();
        if (this.selectedTableTds.curRowIndex == curRowIndex && this.selectedTableTds.curColIndex == curColIndex) return;
        let startRowIndex = this.selectedTableTds.srcRowIndex;
        if (curRowIndex < this.selectedTableTds.srcRowIndex) startRowIndex = curRowIndex;
        let endRowIndex = curRowIndex;
        if (curRowIndex < this.selectedTableTds.srcRowIndex) endRowIndex = this.selectedTableTds.srcRowIndex;
        let startColIndex = this.selectedTableTds.srcColIndex;
        if (curColIndex < this.selectedTableTds.srcColIndex) startColIndex = curColIndex;
        let endColIndex = curColIndex;
        if (curColIndex < this.selectedTableTds.srcColIndex) endColIndex = this.selectedTableTds.srcColIndex;
        $("#" + tableId).children("tbody").children("tr").children("td").css("background", "");
        for (let i = startRowIndex; i <= endRowIndex; i++) {
            let tr = $("#" + tableId).children("tbody").children("tr").eq(i);
            for (let j = startColIndex; j <= endColIndex; j++) {
                let tdTmp = tr.children("td").eq(j);
                let rowSpan = $(tdTmp).attr("rowspan");
                if (rowSpan && parseInt(rowSpan) > 1) {
                    this.selectedTableTds.isDrag = false;
                    return;
                }
                let colSpan = $(tdTmp).attr("colspan");
                if (colSpan && parseInt(colSpan) > 1) {
                    this.selectedTableTds.isDrag = false;
                    return;
                }
                $(tdTmp).css("background", "#C9EFFB");
            }
        }
        this.selectedTableTds.curRowIndex = curRowIndex;
        this.selectedTableTds.curColIndex = curColIndex;
    }

    this.tableTdOnMouseUp = function () {
        if (!this.pageDesigner.mouseInfo || !this.pageDesigner.mouseInfo.dragType) event.stopPropagation();
        if (!this.selectedTableTds) return;
        this.selectedTableTds.isDrag = false;
        //console.log(this.selectedTableTds);
        $("#divTableToolBar").find("div:not(.table-move)").hide();
        $("#divTableToolBar").find(".cell-setting").show();
        //如果只选中了一个单元格
        if (this.selectedTableTds.srcRowIndex == this.selectedTableTds.curRowIndex
            && this.selectedTableTds.srcColIndex == this.selectedTableTds.curColIndex) {
            $("#divTableToolBar").find(".cell-setting-split").show();
            //如果单元格没有合并
            if (this.selectedTableTds.srcRowSpan == 1) {
                $("#divTableToolBar").find(".row-setting-split, .row-setting").show();
            }
            if (this.selectedTableTds.srcColSpan == 1) {
                $("#divTableToolBar").find(".col-setting-split, .col-setting").show();
            }
            if (this.selectedTableTds.srcRowSpan > 1 || this.selectedTableTds.srcColSpan > 1) {
                $("#divTableToolBar").find(".cell-split").show();
            }
        } else {
            $("#divTableToolBar").find(".cell-merge").show();
        }
        if(tfp.curPage.positionType!="absolute") {
            $("#divTableToolBar").find(".table-move").hide();
            $("#divTableToolBar").find(".cell-setting-split").hide();
        }
    }

    this.mergeTableCells = function () {
        event.stopPropagation();
        if (!this.selectedTableTds) return;
        if (this.selectedTableTds.curRowIndex == this.selectedTableTds.srcRowIndex
            && this.selectedTableTds.curColIndex == this.selectedTableTds.srcColIndex) return;
        let firstTd = null;
        let startRowIndex = this.selectedTableTds.srcRowIndex;
        if (this.selectedTableTds.curRowIndex < this.selectedTableTds.srcRowIndex) startRowIndex = this.selectedTableTds.curRowIndex;
        let endRowIndex = this.selectedTableTds.curRowIndex;
        if (this.selectedTableTds.curRowIndex < this.selectedTableTds.srcRowIndex) endRowIndex = this.selectedTableTds.srcRowIndex;
        let startColIndex = this.selectedTableTds.srcColIndex;
        if (this.selectedTableTds.curColIndex < this.selectedTableTds.srcColIndex) startColIndex = this.selectedTableTds.curColIndex;
        let endColIndex = this.selectedTableTds.curColIndex;
        if (this.selectedTableTds.curColIndex < this.selectedTableTds.srcColIndex) endColIndex = this.selectedTableTds.srcColIndex;
        let tableCpt = tfp.get(uiDesigner.curSelectedCptId);
        for (let i = startRowIndex; i <= endRowIndex; i++) {
            let tr = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(i);
            for (let j = startColIndex; j <= endColIndex; j++) {
                let tdTmp = tr.children("td").eq(j);
                let cell = tableCpt.dataModel.rows[i].cells[j];
                if (i == startRowIndex && j == startColIndex) {
                    firstTd = tdTmp;
                    cell.rows = endRowIndex - startRowIndex + 1;
                    cell.cols = endColIndex - startColIndex + 1;
                } else {
                    $(tdTmp).hide();
                    $(tdTmp).css("background-color", "");
                    $(tdTmp).empty();
                    cell.hidden = true;
                    cell.rows = 1;
                    cell.cols = 1;
                    delete cell["bgColor"];
                    delete cell["align"];
                    delete cell["valign"];
                    cell.components = [];
                }
                $(tdTmp).css("background", "#C9EFFB");
            }
        }
        this.selectedTableTds.srcRowSpan = endRowIndex - startRowIndex + 1;
        this.selectedTableTds.srcColSpan = endColIndex - startColIndex + 1;
        if (endRowIndex > startRowIndex) $(firstTd).attr("rowspan", this.selectedTableTds.srcRowSpan);
        if (endColIndex > startColIndex) $(firstTd).attr("colspan", this.selectedTableTds.srcColSpan);
        this.selectedTableTds.curRowIndex = startRowIndex;
        this.selectedTableTds.curColIndex = startColIndex;
        this.selectedTableTds.srcRowIndex = startRowIndex;
        this.selectedTableTds.srcColIndex = startColIndex;
        this.tableTdOnMouseUp();
        //console.log(this.selectedTableTds);
    }

    this.splitTableCells = function () {
        event.stopPropagation();
        if (!this.selectedTableTds) return;
        if (this.selectedTableTds.srcRowIndex != this.selectedTableTds.curRowIndex
            || this.selectedTableTds.srcColIndex != this.selectedTableTds.curColIndex) return;
        if (this.selectedTableTds.srcRowSpan == 1 && this.selectedTableTds.srcColSpan == 1) return;

        let tableCpt = tfp.get(uiDesigner.curSelectedCptId);
        for (let i = this.selectedTableTds.srcRowIndex; i < this.selectedTableTds.srcRowIndex + this.selectedTableTds.srcRowSpan; i++) {
            let tr = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(i);
            for (let j = this.selectedTableTds.srcColIndex; j < this.selectedTableTds.srcColIndex + this.selectedTableTds.srcColSpan; j++) {
                let tdTmp = tr.children("td").eq(j);
                let cell = tableCpt.dataModel.rows[i].cells[j];
                cell.rows = 1;
                cell.cols = 1;
                delete cell["hidden"];
                $(tdTmp).attr("rowspan", "");
                $(tdTmp).attr("colspan", "");
                $(tdTmp).show();
            }
        }
        this.selectedTableTds.curRowIndex = this.selectedTableTds.srcRowIndex + this.selectedTableTds.srcRowSpan - 1;
        this.selectedTableTds.curColIndex = this.selectedTableTds.srcColIndex + this.selectedTableTds.srcColSpan - 1;
        this.selectedTableTds.srcRowSpan = 1;
        this.selectedTableTds.srcColSpan = 1;
        this.tableTdOnMouseUp();
        //console.log(this.selectedTableTds);
    }

    this.resetCptRowIndex = function (tableCpt, startIndex, isAdd) {
        for(let i=startIndex;i<tableCpt.dataModel.rows.length;i++) {
            let row = tableCpt.dataModel.rows[i];
            for(let j=0;j<row.cells.length;j++) {
                let cell = row.cells[j];
                if(cell.components) {
                    cell.components.forEach(cptId => {
                        let cpt = tfp.get(cptId);
                        if(cpt) {
                            if(isAdd) {
                                cpt.dataModel.tableCellRowIndex++;
                            } else {
                                cpt.dataModel.tableCellRowIndex--;
                            }
                        }
                    });
                }
            }
        }
    }

    this.insertRow = function (position) {
        event.stopPropagation();
        $("#divTableRowSetting").hide();
        if (!this.selectedTableTds || this.selectedTableTds.srcRowSpan != 1) return;
        let tableCpt = tfp.get(this.selectedTableTds.tableId);
        let curRowEl = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(this.selectedTableTds.srcRowIndex);
        let curRow = tableCpt.dataModel.rows[this.selectedTableTds.srcRowIndex];
        let rowHtml = "<tr height=\"" + curRow.height + "\">\r\n";
        let newRow = {
            height: curRow.height,
            cells: []
        };
        let borderStyle = "";
        if (tableCpt.dataModel.borderWidth) {
            borderStyle = tableCpt.dataModel.borderWidth + "px solid " + (tableCpt.dataModel.borderColor ? tableCpt.dataModel.borderColor : "#000000");
        }
        let spanCells = {};
        tableCpt.dataModel.columns.forEach((col, index) => {
            let cellOld = curRow.cells[index];
            let cellNew = {
                "cols": cellOld.cols,
                "rows": 1,
                "components": []
            };
            if (cellOld.hidden) {
                cellNew.hidden = true;
                //先在当前行查找当前合并的起始单元格
                let tmpCellIndex = index;
                //是否是在当前行内合并的单元格
                let isCurRowSpanCell = false;
                while (tmpCellIndex > 0) {
                    tmpCellIndex--;
                    let cellTmp = curRow.cells[tmpCellIndex];
                    //如果遇到非隐藏单元格
                    if (!cellTmp.hidden) {
                        //如果该单元格的行进行了合并，则判断是否是包含当前单元格
                        if (cellTmp.cols > 1 && cellTmp.cols > (index - tmpCellIndex)) {
                            isCurRowSpanCell = true;
                        }
                        break;
                    }
                }
                //如果不是在当前行内合并的单元格
                if (!isCurRowSpanCell) {
                    let spanStartRowIndex = -1;
                    let spanStartColIndex = -1;
                    let tmpRowIndex = this.selectedTableTds.srcRowIndex;
                    while (tmpRowIndex > 0) {
                        tmpRowIndex--;
                        let rowTmp = tableCpt.dataModel.rows[tmpRowIndex];
                        let cellTmp = rowTmp.cells[index];
                        if (!cellTmp.hidden) {
                            if (cellTmp.rows > 1 && cellTmp.rows > (this.selectedTableTds.srcRowIndex - tmpRowIndex)) {
                                spanStartRowIndex = tmpRowIndex;
                                spanStartColIndex = index;
                                //不能直接在这里改这个单元格的合并行数，因为当前行可能有多个单元格是被向上合并的
                            }
                            tmpRowIndex++;
                            break;
                        }
                    }
                    if (spanStartRowIndex >= 0 && !spanCells[spanStartRowIndex + "-" + spanStartColIndex]) {
                        let cellSpan = tableCpt.dataModel.rows[spanStartRowIndex].cells[spanStartColIndex];
                        cellSpan.rows++;
                        let spanRowEl = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(spanStartRowIndex);
                        let spanCell = spanRowEl.children("td").eq(spanStartColIndex);
                        spanCell.attr("rowspan", cellSpan.rows);
                        spanCells[spanStartRowIndex + "-" + spanStartColIndex] = true;
                    }
                }
            } else if (cellOld.rows > 1) {  //如果该单元格向下合并
                if (position == "after") {
                    cellOld.rows++;
                    curRowEl.children("td").eq(index).attr("rowspan", cellOld.rows);
                    cellNew.hidden = true;
                } else {
                    cellNew.rows = 1;
                    cellNew.cols = 1;
                }
            }
            if (cellOld.bgColor) cellNew.bgColor = cellOld.bgColor;
            if (cellOld.align) cellNew.align = cellOld.align;
            if (cellOld.valign) cellNew.valign = cellOld.valign;
            newRow.cells.push(cellNew);
            rowHtml += "<td";
            if (cellNew.rows > 1) rowHtml += " rowspan=\"" + cellNew.rows + "\"";
            if (cellNew.cols > 1) rowHtml += " colspan=\"" + cellNew.cols + "\"";
            if (cellNew.align) rowHtml += " align=\"" + cellNew.align + "\"";
            if (cellNew.valign) rowHtml += " align=\"" + cellNew.valign + "\"";
            rowHtml += " style=\"width:" + col.width + "px;";
            if (cellNew.bgColor) rowHtml += "background-color:" + cellNew.bgColor + ";";
            if (cellNew.hidden) rowHtml += "display:none;";
            if (tableCpt.dataModel.cellPadding) rowHtml += "padding:" + tableCpt.dataModel.cellPadding + "px;"
            if (tableCpt.dataModel.borderWidth) {
                rowHtml += "border-bottom:" + borderStyle + "; border-right:" + borderStyle + ";";
            }
            rowHtml += "\"></td>\r\n";
        });
        rowHtml += "</tr>\r\n";
        let newRowEl = null;
        if (position == "before") {
            $(rowHtml).insertBefore(curRowEl);
            newRowEl = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(this.selectedTableTds.srcRowIndex);
            tableCpt.dataModel.rows.splice(this.selectedTableTds.srcRowIndex, 0, newRow);
            if (this.selectedTableTds.srcRowIndex == 0 && tableCpt.dataModel.borderWidth) {
                newRowEl.children("td").css("border-top", borderStyle);
                let oldRowEl = newRowEl.next();
                oldRowEl.children("td").css("border-top", "");
            }
            this.selectedTableTds.srcRowIndex++;
            this.selectedTableTds.curRowIndex++;
            this.resetCptRowIndex(tableCpt, this.selectedTableTds.srcRowIndex, true);
        } else {
            $(rowHtml).insertAfter(curRowEl);
            newRowEl = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(this.selectedTableTds.srcRowIndex + 1);
            tableCpt.dataModel.rows.splice(this.selectedTableTds.srcRowIndex + 1, 0, newRow);
            this.resetCptRowIndex(tableCpt, this.selectedTableTds.srcRowIndex + 1, true);
        }
        newRowEl.children("td").eq(0).css("border-left", borderStyle);
        const that = this;
        newRowEl.children("td").each(function () {
            that.bindTableTdEvent(that.selectedTableTds.tableId, this);
        });
    }

    this.delRow = function () {
        event.stopPropagation();
        $("#divTableRowSetting").hide();
        if (!this.selectedTableTds || this.selectedTableTds.srcRowSpan != 1) return;
        $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(this.selectedTableTds.srcRowIndex).remove();
        let tableCpt = tfp.get(this.selectedTableTds.tableId);
        let curRow = tableCpt.dataModel.rows[this.selectedTableTds.srcRowIndex];
        curRow.cells.forEach((cell, index) => {
            //如果是隐藏的单元格，则需要充值合并单元格的行数
            if (cell.hidden) {
                //先在当前行查找当前合并的起始单元格
                let tmpCellIndex = index;
                //是否是在当前行内合并的单元格
                let isCurRowSpanCell = false;
                while (tmpCellIndex > 0) {
                    tmpCellIndex--;
                    let cellTmp = curRow.cells[tmpCellIndex];
                    //如果遇到非隐藏单元格
                    if (!cellTmp.hidden) {
                        //如果该单元格的行进行了合并，则判断是否是包含当前单元格
                        if (cellTmp.cols > 1 && cellTmp.cols > (index - tmpCellIndex)) {
                            isCurRowSpanCell = true;
                        }
                        break;
                    }
                }
                //如果不是在当前行内合并的单元格
                if (!isCurRowSpanCell) {
                    let spanStartRowIndex = -1;
                    let spanStartColIndex = -1;
                    let tmpRowIndex = this.selectedTableTds.srcRowIndex;
                    while (tmpRowIndex > 0) {
                        tmpRowIndex--;
                        let rowTmp = tableCpt.dataModel.rows[tmpRowIndex];
                        let cellTmp = rowTmp.cells[index];
                        if (!cellTmp.hidden) {
                            if (cellTmp.rows > 1 && cellTmp.rows > (this.selectedTableTds.srcRowIndex - tmpRowIndex)) {
                                spanStartRowIndex = tmpRowIndex;
                                spanStartColIndex = index;
                                //不能直接在这里改这个单元格的合并行数，因为当前行可能有多个单元格是被向上合并的
                            }
                            tmpRowIndex++;
                            break;
                        }
                    }
                    let spanCells = {};
                    if (spanStartRowIndex >= 0 && !spanCells[spanStartRowIndex + "-" + spanStartColIndex]) {
                        let cellSpan = tableCpt.dataModel.rows[spanStartRowIndex].cells[spanStartColIndex];
                        cellSpan.rows--;
                        let spanRowEl = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(spanStartRowIndex);
                        let spanCell = spanRowEl.children("td").eq(spanStartColIndex);
                        spanCell.attr("rowspan", cellSpan.rows);
                        spanCells[spanStartRowIndex + "-" + spanStartColIndex] = true;
                    }
                }
            } else if (cell.rows > 1) {
                let nextRow = tableCpt.dataModel.rows[this.selectedTableTds.srcRowIndex + 1];
                let nextCell = nextRow.cells[index];
                nextCell.rows = cell.rows - 1;
                nextCell.cols = cell.cols;
                delete nextCell["hidden"];
                let nextRowEl = $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").eq(this.selectedTableTds.srcRowIndex);
                let nextCellEl = nextRowEl.children("td").eq(index);
                nextCellEl.attr("rowspan", nextCell.rows > 1 ? nextCell.rows : "");
                nextCellEl.attr("colspan", nextCell.cols > 1 ? nextCell.cols : "");
                nextCellEl.show();
            }
        });
        tableCpt.dataModel.rows.splice(this.selectedTableTds.srcRowIndex, 1);
        $("#" + this.selectedTableTds.tableId).children("tbody").children("tr").children("td").css("background", "");
        $("#divTableToolBar").find("div:not(.table-move)").hide();
        this.resetCptRowIndex(tableCpt, this.selectedTableTds.srcRowIndex, false);
        this.selectedTableTds = null;
    }

    this.setTableRowHeight = function () {
        event.stopPropagation();
        $("#divTableRowSetting").hide();
        if (!this.selectedTableTds || this.selectedTableTds.srcRowSpan != 1) return;
        let tableCpt = tfp.get(this.selectedTableTds.tableId);
        let curRow = tableCpt.dataModel.rows[this.selectedTableTds.srcRowIndex];
        let args = {
            height: curRow.height
        };
        const that = this;
        tfp.openDialog("设置行高", "tfp/src/components/table/SetTableRowHeight.tfp", "200px", "130px",
            JSON.stringify(args), function (height) {
                curRow.height = height;
                $("#" + that.selectedTableTds.tableId).children("tbody").children("tr").eq(that.selectedTableTds.srcRowIndex).attr("height", height);
            });
    }

    this.resetCptColIndex = function (tableCpt, startIndex, isAdd) {
        for(let i=0;i<tableCpt.dataModel.rows.length;i++) {
            let row = tableCpt.dataModel.rows[i];
            for(let j=startIndex;j<row.cells.length;j++) {
                let cell = row.cells[j];
                if(cell.components) {
                    cell.components.forEach(cptId => {
                        let cpt = tfp.get(cptId);
                        if(cpt) {
                            if(isAdd) {
                                cpt.dataModel.tableCellColIndex++;
                            } else {
                                cpt.dataModel.tableCellColIndex--;
                            }
                        }
                    });
                }
            }
        }
    }

    this.insertCol = function (position) {
        event.stopPropagation();
        $("#divTableColSetting").hide();
        if (!this.selectedTableTds || this.selectedTableTds.srcColSpan != 1) return;
        let tableCpt = tfp.get(this.selectedTableTds.tableId);
        let curCol = tableCpt.dataModel.columns[this.selectedTableTds.srcColIndex];
        let newCol = {
            width: curCol.width
        };
        let borderStyle = "";
        if (tableCpt.dataModel.borderWidth) {
            borderStyle = tableCpt.dataModel.borderWidth + "px solid " + (tableCpt.dataModel.borderColor ? tableCpt.dataModel.borderColor : "#000000");
        }
        let tableEl = $("#" + this.selectedTableTds.tableId);
        tableCpt.dataModel.columns.splice(this.selectedTableTds.srcColIndex, 0, newCol);
        tableCpt.dataModel.rows.forEach((row, index) => {
            let newCell = {
                "cols": 1,
                "rows": 1,
                "components": []
            };
            let curRowEl = tableEl.children("tbody").children("tr").eq(index);
            let curCellEl = curRowEl.children("td").eq(this.selectedTableTds.srcColIndex);
            let curCell = row.cells[this.selectedTableTds.srcColIndex];
            let newCellHtml = "<td ";
            //if(curCell.rows>1) newCellHtml += " rowspan=\""+curCell.rows+"\"";
            //if(curCell.cols>1) newCellHtml += " colspan=\""+curCell.cols+"\"";
            if (curCell.align) newCellHtml += " align=\"" + curCell.align + "\"";
            if (curCell.valign) newCellHtml += " align=\"" + curCell.valign + "\"";
            newCellHtml += " style=\"width:" + curCol.width + "px;";
            if (curCell.hidden) {
                //先在当前行查找当前合并的起始单元格
                let tmpCellIndex = this.selectedTableTds.srcColIndex;
                //是否是在当前行内合并的单元格
                let isCurRowSpanCell = false;
                while (tmpCellIndex > 0) {
                    tmpCellIndex--;
                    let cellTmp = row.cells[tmpCellIndex];
                    //如果遇到非隐藏单元格
                    if (!cellTmp.hidden) {
                        //如果该单元格的行进行了合并，则判断是否是包含当前单元格
                        if (cellTmp.cols > 1 && cellTmp.cols > (this.selectedTableTds.srcColIndex - tmpCellIndex)) {
                            cellTmp.cols++;
                            let cellElTmp = curRowEl.children("td").eq(tmpCellIndex);
                            cellElTmp.attr("colspan", cellTmp.cols);
                            newCell.hidden = true;
                            isCurRowSpanCell = true;
                        }
                        tmpCellIndex++;
                        break;
                    }
                }
                if (!isCurRowSpanCell) {
                    if (position == "right") {
                        newCell.hidden = true;
                    } else if (tmpCellIndex < this.selectedTableTds.srcColIndex) {
                        newCell.hidden = true;
                    }
                }
            } else if (curCell.cols > 1) {
                //如果当前当前单元格是合并的起始单元格，且在右侧添加列
                //则该单元格合并列数加1，该行新加的单元格隐藏
                if (position == "right") {
                    newCell.hidden = true;
                    curCell.cols++;
                    curCellEl.attr("colspan", curCell.cols);
                }
            }
            if (curCell.bgColor) newCellHtml += "background-color:" + cellNew.bgColor + ";";
            if (newCell.hidden) newCellHtml += "display:none;";
            if (tableCpt.dataModel.cellPadding) newCellHtml += "padding:" + tableCpt.dataModel.cellPadding + "px;"
            if (tableCpt.dataModel.borderWidth) {
                newCellHtml += "border-bottom:" + borderStyle + "; border-right:" + borderStyle + ";";
            }
            newCellHtml += "\"></td>";
            let newCellEl = null;
            if (position == "left") {
                row.cells.splice(this.selectedTableTds.srcColIndex, 0, newCell);
                $(newCellHtml).insertBefore(curCellEl);
                newCellEl = curRowEl.children("td").eq(this.selectedTableTds.srcColIndex);
            } else {
                row.cells.splice(this.selectedTableTds.srcColIndex + 1, 0, newCell);
                $(newCellHtml).insertAfter(curCellEl);
                newCellEl = curRowEl.children("td").eq(this.selectedTableTds.srcColIndex + 1);
            }
            if (index == 0) {
                newCellEl.css("border-top", borderStyle);
            }
            if (newCellEl.index() == 0) {
                newCellEl.css("border-left", borderStyle);
            }
            this.bindTableTdEvent(this.selectedTableTds.tableId, newCellEl.get(0));
        });
        if (position == "left") {
            this.selectedTableTds.srcColIndex++;
            this.selectedTableTds.curColIndex++;
            this.resetCptColIndex(tableCpt, this.selectedTableTds.srcColIndex, true);
        } else {
            this.resetCptColIndex(tableCpt, this.selectedTableTds.srcColIndex+1, true);
        }
        this.resetTableWidth(tableCpt);
    }

    this.delCol = function () {
        event.stopPropagation();
        $("#divTableColSetting").hide();
        if (!this.selectedTableTds || this.selectedTableTds.srcColSpan != 1) return;
        let tableCpt = tfp.get(this.selectedTableTds.tableId);
        let tableEl = $("#" + this.selectedTableTds.tableId);
        tableCpt.dataModel.columns.splice(this.selectedTableTds.srcColIndex, 1);
        tableCpt.dataModel.rows.forEach((row, index) => {
            let curRowEl = tableEl.children("tbody").children("tr").eq(index);
            let curCellEl = curRowEl.children("td").eq(this.selectedTableTds.srcColIndex);
            let curCell = row.cells[this.selectedTableTds.srcColIndex];
            if (curCell.hidden) {
                //先在当前行查找当前合并的起始单元格
                let tmpCellIndex = this.selectedTableTds.srcColIndex;
                //是否是在当前行内合并的单元格
                let isCurRowSpanCell = false;
                while (tmpCellIndex > 0) {
                    tmpCellIndex--;
                    let cellTmp = row.cells[tmpCellIndex];
                    //如果遇到非隐藏单元格
                    if (!cellTmp.hidden) {
                        //如果该单元格的行进行了合并，则判断是否是包含当前单元格
                        if (cellTmp.cols > 1 && cellTmp.cols > (this.selectedTableTds.srcColIndex - tmpCellIndex)) {
                            cellTmp.cols--;
                            let cellElTmp = curRowEl.children("td").eq(tmpCellIndex);
                            cellElTmp.attr("colspan", cellTmp.cols);
                            isCurRowSpanCell = true;
                        }
                        tmpCellIndex++;
                        break;
                    }
                }
            } else if (curCell.cols > 1) {
                let nextCell = row.cells[this.selectedTableTds.srcColIndex + 1];
                nextCell.cols = curCell.cols - 1;
                nextCell.rows = curCell.rows;
                delete nextCell["hidden"];
                let nextCellEl = curRowEl.children("td").eq(this.selectedTableTds.srcColIndex + 1);
                nextCellEl.attr("colspan", nextCell.cols > 1 ? nextCell.cols : "");
                nextCellEl.attr("rowspan", nextCell.rows > 1 ? nextCell.rows : "");
                nextCellEl.show();
            }
            row.cells.splice(this.selectedTableTds.srcColIndex, 1);
            curCellEl.remove();
        });
        $("#divTableToolBar").find("div:not(.table-move)").hide();
        this.resetCptColIndex(tableCpt, this.selectedTableTds.srcColIndex, false);
        this.selectedTableTds = null;
        this.resetTableWidth(tableCpt);
    }

    this.resetTableWidth = function (tableCpt) {
        let totalWidth = 0;
        tableCpt.dataModel.columns.forEach((col, index) => {
            totalWidth += parseInt(col.width);
        });
        tableCpt._jqObj.css("width", totalWidth + "px");
    }

    this.setTableColWidth = function () {
        event.stopPropagation();
        $("#divTableColSetting").hide();
        if (!this.selectedTableTds || this.selectedTableTds.srcColSpan != 1) return;
        let tableCpt = tfp.get(this.selectedTableTds.tableId);
        let curCol = tableCpt.dataModel.columns[this.selectedTableTds.srcColIndex];
        let args = {
            width: curCol.width
        };
        const that = this;
        tfp.openDialog("设置列宽", "tfp/src/components/table/SetTableColWidth.tfp", "200px", "130px", JSON.stringify(args), function (width) {
            curCol.width = width;
            let tableEl = $("#" + that.selectedTableTds.tableId);
            tableCpt.dataModel.rows.forEach((row, rowIndex) => {
                let rowEl = tableEl.children("tbody").children("tr").eq(rowIndex);
                cellEl = rowEl.children("td").eq(that.selectedTableTds.srcColIndex);
                cellEl.css("width", width + ((width+'').indexOf("%")>0 ? "" : "px"));
            });
            if((width+'').indexOf("%")<0) that.resetTableWidth(tableCpt);
        });
    }

    this.setCellStyle = function (tableCpt, cell, setting, rowIndex, colIndex) {
        delete cell["bgColor"];
        delete cell["align"];
        delete cell["valign"];
        delete cell["paddingLeft"];
        delete cell["paddingRight"];
        delete cell["paddingTop"];
        delete cell["paddingBottom"];
        delete cell["borderTopWidth"];
        delete cell["borderTopStyle"];
        delete cell["borderBottomWidth"];
        delete cell["borderBottomStyle"];
        delete cell["borderLeftWidth"];
        delete cell["borderLeftStyle"];
        delete cell["borderRightWidth"];
        delete cell["borderRightStyle"];
        for (let p in setting) {
            cell[p] = setting[p];
        }
        let rowEl = tableCpt._jqObj.children("tbody").children("tr").eq(rowIndex);
        let cellEl = rowEl.children("td").eq(colIndex);
        //cellEl.css("background-color", cell.bgColor ? cell.bgColor : "");
        cellEl.attr("align", cell.align ? cell.align : "");
        cellEl.attr("valign", cell.valign ? cell.valign : "");
        //cellEl.css("padding-left", cell.paddingLeft ? cell.paddingLeft + "px" : "");
        //cellEl.css("padding-right", cell.paddingRight ? cell.paddingRight + "px" : "");
        //cellEl.css("padding-top", cell.paddingTop ? cell.paddingTop + "px" : "");
        //cellEl.css("padding-bottom", cell.paddingBottom ? cell.paddingBottom + "px" : "");
        if(cell.borderTopWidth) {
            cellEl.css("border-top", cell.borderTopWidth+"px "+cell.borderTopStyle+" #000000");
        } else {
            cellEl.css("border-top", "");
        }
        if(cell.borderBottomWidth) {
            cellEl.css("border-bottom", cell.borderBottomWidth+"px "+cell.borderBottomStyle+" #000000");
        } else {
            cellEl.css("border-bottom", "");
        }
        if(cell.borderLeftWidth) {
            cellEl.css("border-left", cell.borderLeftWidth+"px "+cell.borderLeftStyle+" #000000");
        } else {
            cellEl.css("border-left", "");
        }
        if(cell.borderRightWidth) {
            cellEl.css("border-right", cell.borderRightWidth+"px "+cell.borderRightStyle+" #000000");
        } else {
            cellEl.css("border-right", "");
        }
    }

    this.setCellSetting = function () {
        event.stopPropagation();
        $("#divTableRowSetting").hide();
        $("#divTableColSetting").hide();
        if (!this.selectedTableTds) return;
        let tableCpt = tfp.get(this.selectedTableTds.tableId);
        let args = {};
        let curCell = null;
        if (this.selectedTableTds.srcRowIndex == this.selectedTableTds.curRowIndex
            && this.selectedTableTds.srcColIndex == this.selectedTableTds.curColIndex) {
            curCell = tableCpt.dataModel.rows[this.selectedTableTds.srcRowIndex].cells[this.selectedTableTds.srcColIndex];
            if (curCell.align) args.align = curCell.align;
            if (curCell.valign) args.valign = curCell.valign;
            if (curCell.bgColor) args.bgColor = curCell.bgColor;
            if (curCell.borderTopWidth) args.borderTopWidth = curCell.borderTopWidth;
            if (curCell.borderTopStyle) args.borderTopStyle = curCell.borderTopStyle;
            if (curCell.borderBottomWidth) args.borderBottomWidth = curCell.borderBottomWidth;
            if (curCell.borderBottomStyle) args.borderBottomStyle = curCell.borderBottomStyle;
            if (curCell.borderLeftWidth) args.borderLeftWidth = curCell.borderLeftWidth;
            if (curCell.borderLeftStyle) args.borderLeftStyle = curCell.borderLeftStyle;
            if (curCell.borderRightWidth) args.borderRightWidth = curCell.borderRightWidth;
            if (curCell.borderRightStyle) args.borderRightStyle = curCell.borderRightStyle;
        }
        const that = this;
        tfp.openDialog("单元格设置", "tfp/src/components/table/TableCellSetting.tfp", "360px", "250px", JSON.stringify(args), function (ret) {
            if (curCell) {
                that.setCellStyle(tableCpt, curCell, ret, that.selectedTableTds.srcRowIndex, that.selectedTableTds.srcColIndex);
            } else {
                for (let i = that.selectedTableTds.srcRowIndex; i <= that.selectedTableTds.curRowIndex; i++) {
                    let row = tableCpt.dataModel.rows[i];
                    for (let j = that.selectedTableTds.srcColIndex; j <= that.selectedTableTds.curColIndex; j++) {
                        let cell = row.cells[j];
                        that.setCellStyle(tableCpt, cell, ret, i, j);
                    }
                }
            }
        });
    }

    this.bindTableTdEvent = function (tableId, td) {
        const that = this;
        $(td).mousedown(function () {
            that.tableTdOnMouseDown(tableId, this);
        });
        $(td).mousemove(function () {
            that.tableTdOnMouseMove(tableId, this);
        });
        $(td).mouseup(function () {
            that.tableTdOnMouseUp(tableId, this);
        });

        /*$(td).dblclick(function() {
            let html = $(this).html();
            let text = $(this).text();
            if (html.indexOf("<") < 0) {
                $(this).html("<input style=\"border:0;background-color:#FFFFFF; "
                +"border:0; width:"+$(this).width()+"px; height:"+$(this).height()+"px;\" "
                + "value=\"" + $(this).text() + "\" onblur=\"tfp.get('" + tableId + "').resetTdContent(this)\">");
                $(this).find("input").focus();
            }
        });*/
    }

    this.init = function (_pageDesigner) {
        this.pageDesigner = _pageDesigner;
        $("body").append(`  <div id="divTableToolBar" style="display: none;">
        <div class="table-move" title="移动表格" onclick="tableDesigner.talebMoveIconOnClick()" onmousedown="tableDesigner.talebMoveIconOnMouseDown()" style="background-image: url(../tfp/src/components/table/images/move.png);background-position:4px 4px;background-repeat: no-repeat;">
        </div>
        <div class="cell-setting-split" style="display: none;width:0; height: 16px; border-left: 1px solid #dddddd; margin-left: 3px; padding: 0; margin-right: 3px; border-radius: 0;"></div>
        <div class="cell-merge" title="合并单元格" onclick="tableDesigner.mergeTableCells()" style="display: none;">
          <img src="../tfp/src/components/table/images/merge.png">
        </div>
        <div class="cell-split" title="拆分单元格" onclick="tableDesigner.splitTableCells()" style="display: none;">
          <img src="../tfp/src/components/table/images/split.png">
        </div>
        <div class="cell-setting" title="单元格设置" style="display: none;" onclick="tableDesigner.setCellSetting()">
          <img src="../tfp/src/components/table/images/cell-setting.png">
        </div>
        <div class="row-setting-split" style="display: none;width:0; height: 16px; border-left: 1px solid #dddddd; margin-left: 3px; padding: 0; margin-right: 3px; border-radius: 0;"></div>
        <div class="row-setting" title="行设置" style="margin-left: 0; width: 32px;display: none;" onclick="tableDesigner.showTableRowSetting()">
          <img src="../tfp/src/components/table/images/row-setting.png">
          <img src="../tfp/src/components/table/images/arrow-down.png" style="width: 6px; height: 6px; margin-left: 2px; margin-right: 2px;">
        </div>
        <div class="col-setting-split" style="display: none;width:0; height: 16px; border-left: 1px solid #dddddd; margin-left: 3px; padding: 0; margin-right: 3px; border-radius: 0;"></div>    
        <div class="col-setting" title="列设置" style="margin-left: 0; width: 32px;display: none;" onclick="tableDesigner.showTableColSetting()">
          <img src="../tfp/src/components/table/images/col-setting.png">
          <img src="../tfp/src/components/table/images/arrow-down.png" style="width: 6px; height: 6px; margin-left: 2px; margin-right: 2px;">
        </div>
      </div>
    
      <div id="divTableRowSetting" style="display: none;">
        <div title="设置行高" style="margin-left: 0;" onclick="tableDesigner.setTableRowHeight()">
          <img src="../tfp/src/components/table/images/set-width.png">
          <label>设置行高</label>
        </div>
        <div title="在上面插入行" onclick="tableDesigner.insertRow('before')">
          <img src="../tfp/src/components/table/images/insert-row-before.png">
          <label>在上面插入行</label>
        </div>
        <div title="在下面插入行" onclick="tableDesigner.insertRow('after')">
          <img src="../tfp/src/components/table/images/insert-row-after.png">
          <label>在下面插入行</label>
        </div>
        <div title="删除行" onclick="tableDesigner.delRow()">
          <img src="../tfp/src/components/table/images/del-row.png">
          <label>删除行</label>
        </div>
      </div>
    
      <div id="divTableColSetting" style="display: none;">
        <div title="设置列宽" onclick="tableDesigner.setTableColWidth()">
          <img src="../tfp/src/components/table/images/set-height.png">
          <label>设置列宽</label>
        </div>
        <div title="在左边插入列" onclick="tableDesigner.insertCol('left')">
          <img src="../tfp/src/components/table/images/insert-col-before.png">
          <label>在左边插入列</label>
        </div>
        <div title="在右边插入列" onclick="tableDesigner.insertCol('right')">
          <img src="../tfp/src/components/table/images/insert-col-after.png">
          <label>在右边插入列</label>
        </div>
        <div title="删除列" onclick="tableDesigner.delCol()">
          <img src="../tfp/src/components/table/images/del-col.png">
          <label>删除列</label>
        </div>
      </div>`);
    }
}

window.tableDesigner = new TableDesigner();