import { ContainerComponent } from "../controller.js";

/**
 * 普遍表格组件
 * @param {[type]} dataModel [description]
 */
export default class Table extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Table", dataModel, parent);
    if (!this.dataModel.columns) {
      this.dataModel.columns = [{
        "width": "200"
      }, {
        "width": "200"
      }, {
        "width": "200"
      }];
      this.dataModel.rows = [
        {
          "height": "30",
          "cells": [{
            cols: 1,
            rows: 1,
            components: []
          }, {
            cols: 1,
            rows: 1,
            components: []
          }, {
            cols: 1,
            rows: 1,
            components: []
          }]
        },
        {
          "height": "30",
          "cells": [{
            cols: 1,
            rows: 1,
            components: []
          }, {
            cols: 1,
            rows: 1,
            components: []
          }, {
            cols: 1,
            rows: 1,
            components: []
          }]
        },
        {
          "height": "30",
          "cells": [{
            cols: 1,
            rows: 1,
            components: []
          }, {
            cols: 1,
            rows: 1,
            components: []
          }, {
            cols: 1,
            rows: 1,
            components: []
          }]
        }
      ];
    }
  }

  get allowPage() { return this.dataModel.allowPage ? true : false }
  set allowPage(value) {
    this.dataModel.allowPage = value ? true : false;
  }

  get mainTableKeyField() { return this.dataModel.mainTableKeyField }
  set mainTableKeyField(value) {
    this.dataModel.mainTableKeyField = value;
  }

  get borderWidth() { return this.dataModel.borderWidth }
  set borderWidth(value) {
    this.dataModel.borderWidth = value;
    if (isNaN(value) || parseInt(value) < 0) this.dataModel.borderWidth = 0;
    this.resetBorder();
  }

  get borderColor() { return this.dataModel.borderColor }
  set borderColor(value) {
    this.dataModel.borderColor = value;
    this.resetBorder();
  }

  get cellPadding() { return this.dataModel.cellPadding }
  set cellPadding(value) {
    this.dataModel.cellPadding = value;
    if (this._jqObj) this._jqObj.children("tbody").children("tr").children("td").css("padding", value ? value + "px" : "");
  }

  get dynamicRowStartIndex() { return this.dataModel.dynamicRowStartIndex }
  set dynamicRowStartIndex(value) {
    this.dataModel.dynamicRowStartIndex = value;
  }

  get dynamicRowEndIndex() { return this.dataModel.dynamicRowEndIndex }
  set dynamicRowEndIndex(value) {
    this.dataModel.dynamicRowEndIndex = value;
  }

  get associatedMainTableField() { return this.dataModel.associatedMainTableField }
  set associatedMainTableField(value) {
    this.dataModel.associatedMainTableField = value;
  }

  resetBorder() {
    if (this._jqObj) {
      let borderColor = "#000000";
      if (this.dataModel.borderColor) borderColor = this.dataModel.borderColor;
      if (isNull(this.dataModel.borderWidth) || (this.dataModel.borderWidth + '') == '0') {
        if (this._tfp.isDesigning) {
          this._jqObj.children("tbody").children("tr").children("td").css("border", "1px dashed #cccccc");
        } else {
          this._jqObj.children("tbody").children("tr").children("td").css("border", "0");
        }
      } else {
        this._jqObj.children("tbody").children("tr").children("td").css("border", this.dataModel.borderWidth + "px solid " + borderColor);
      }
    }
  }

  getContainerEl(cptId, cdm) {
    //如果设置了当前容器td，则表示是设计时拖拽新的组件
    if (this.curContainerTd) {
      let colIndex = this.curContainerTd.index();
      let rowIndex = this.curContainerTd.parent().index();
      let cell = this.dataModel.rows[rowIndex].cells[colIndex];
      cell.components.push(cptId);
      return this.curContainerTd;
    } else if (!isNaN(cdm.tableCellRowIndex) && parseInt(cdm.tableCellRowIndex) >= 0) {  //否则根据数据模型里的行列索引获得对应的容器td
      let rowEl = this._jqObj.children("tbody").children("tr").eq(cdm.tableCellRowIndex);
      return rowEl.children("td").eq(cdm.tableCellColIndex);
    }
    return null;
  }

  resetTdContent(ipt) {
    let val = $(ipt).val();
    $(ipt).parent().html(val);
  }

  showToolBar() {
    let offset = this._jqObj.offset();
    $("#divTableToolBar").css("top", (offset.top - 33) + "px");
    $("#divTableToolBar").css("left", (offset.left - 2) + "px");
    $("#divTableToolBar").css("display", "flex");
  }

  /**
   * 设置指定属性的数据绑定信息
   * @param {*} attr 
   * @param {*} settingData 
   * @param {*} attrSetting 
   */
  setDataBindSetting(attr, settingData, attrSetting) {
    if (attr.name == "dynamicRowDataQuerySetting") {
      settingData.type = "query";
      settingData.serviceNameSuffix = "query_dynamic_row";
      settingData.serviceComment = "动态行数据查询";
      attrSetting.dataMember = "data";
    }
  }

  bindDynamicRowsData(data, cb) {
    let startIndex = -1;
    let endIndex = -1;
    if (!isNaN(this.dataModel.dynamicRowStartIndex)) {
      startIndex = parseInt(this.dataModel.dynamicRowStartIndex);
      if (!isNaN(this.dataModel.dynamicRowEndIndex)) {
        endIndex = parseInt(this.dataModel.dynamicRowEndIndex);
      } else {
        endIndex = startIndex;
      }
    }
    let templateRowsHtml = "";
    let rowsList = [];
    for (let i = startIndex; i <= endIndex; i++) {
      let rowEl = this._jqObj.children("tbody").children("tr").get(i);
      templateRowsHtml += rowEl.outerHTML + "\r\n";
      rowsList.push(rowEl);
    }
    let beforeRowEl = null;
    if (this._jqObj.children("tbody").children("tr").length > endIndex + 1) {
      beforeRowEl = this._jqObj.children("tbody").children("tr").eq(endIndex + 1);
    }
    rowsList.forEach(rowEl => {
      rowEl.remove();
    });

    for (let i = 0; i < data.length; i++) {
      let row = data[i];
      let rowHtml = templateRowsHtml;
      try {
        rowHtml = this._tfp.replaceDataField(row, rowHtml);
      } catch (err) {
        console.log(err);
      }
      if (beforeRowEl) {
        $(rowHtml).insertBefore(beforeRowEl);
      } else {
        this._jqObj.children("tbody").append(rowHtml);
      }
    }
    if (cb) cb(data);
  }

  requestDynamicRowsData(cb) {
    if (!this.dataModel.dynamicRowDataQuerySetting
      || !this.dataModel.dynamicRowDataQuerySetting.servicePath) {
      cb();
      return;
    }
    let options = {
      cptId: this.id + "_DynamicRows",
      servicePath: this.dataModel.dynamicRowDataQuerySetting.servicePath,
      autoReload: false,
      autoShowError: true,
      showLoading: true,
      encryptRequestArgs: this.dataModel.dynamicRowDataQuerySetting.encryptRequestArgs,
      encryptResponseArgs: this.dataModel.dynamicRowDataQuerySetting.encryptResponseArgs
    };
    //如果设置了查询的请求参数，则绑定到服务对象上
    if (this.dataModel.dynamicRowDataQuerySetting.requestArgs
      && this.dataModel.dynamicRowDataQuerySetting.requestArgs.length > 0) {
      options.argSettings = this.dataModel.dynamicRowDataQuerySetting.requestArgs;
    }
    var that = this;
    //发起动态请求
    this._tfp.request(options, function (req, res) {
      let dataMember = that.dataModel.dynamicRowDataQuerySetting.dataMember;
      let data = res[dataMember];
      if (data && data.pageSize && data.rows) data = data.rows;
      if (!data || !Array.isArray(data)) {
        cb();
        return;
      }
      that.bindDynamicRowsData(data, cb);
    });
  }

  bindData(data) {
    if (!this.dataModel.components || !data) return;
    let _data = data;
    //如果绑定数据是数组，则取数组的第一个元素作为绑定数据对象
    if (Array.isArray(_data)) {
      if (_data.length == 0) return;
      _data = data[0];
    }
    let startIndex = -1;
    let endIndex = -1;
    if (!isNaN(this.dataModel.dynamicRowStartIndex)) {
      startIndex = parseInt(this.dataModel.dynamicRowStartIndex);
      if (!isNaN(this.dataModel.dynamicRowEndIndex)) {
        endIndex = parseInt(this.dataModel.dynamicRowEndIndex);
      } else {
        endIndex = startIndex;
      }
    }
    for (var i = 0; i < this.dataModel.components.length; i++) {
      let cdm = this.dataModel.components[i];
      //如果设置了动态行
      if (startIndex >= 0 && cdm.tableCellRowIndex >= startIndex && cdm.tableCellRowIndex <= endIndex) {
        continue;
      }
      this._tfp.bindCptData(cdm, _data);
    }
    var that = this;
    if (this.dataModel.dynamicRowDataQuerySetting && this.dataModel.dynamicRowDataQuerySetting.servicePath && startIndex >= 0) {
      this.requestDynamicRowsData(function (dynamicRowData) {
        that.exeOnAterBindData(_data, dynamicRowData);
      });
      return;
    }
    this.exeOnAterBindData(_data);
  }

  bindCellEvent() {
    let that = this;
    this._jqObj.children("tbody").children("tr").each(function () {
      let rowIndex = $(this).index();
      $(this).children("td").each(function () {
        let colIndex = $(this).index();
        let cellJqObj = $(this);
        if (that.dataModel.onCellClick) {
          $(this).click(function () {
            eval(that.dataModel.onCellClick);
          });
        }
        if (that.dataModel.onCellDblClick) {
          $(this).dblclick(function () {
            eval(that.dataModel.onCellDblClick);
          });
        }
        if (that.dataModel.onCellMouseOver) {
          $(this).mouseover(function () {
            eval(that.dataModel.onCellMouseOver);
          });
        }
        if (that.dataModel.onCellMouseOut) {
          $(this).mouseout(function () {
            eval(that.dataModel.onCellMouseOut);
          });
        }
      });
    });
  }

  exeOnAterBindData(data, dynamicRowData) {
    if (this.dataModel.onAfterBindData) {
      try {
        eval(this.dataModel.onAfterBindData);
      } catch (err) {
        console.log(err);
      }
    }
    this.bindCellEvent();
  }

  onLoadData(req, res) {
    var data = res;
    //如果设置了数据绑定成员名称，则从服务响应对象中取这个成员对象作为表单的数据源
    //否则，将整个响应对象作为表单的数据源
    if (this.dataModel.dataBindingMember) {
      data = res[this.dataModel.dataBindingMember];
    } else if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
      data = res[this.dataModel.dataQuerySetting.dataMember];
    }
    //如果是翻页的数据
    if (data.rows && data.pageCount) data = data.rows;
    //如果是数组
    if (Array.isArray(data)) data = data[0];
    //把数据先缓存起来，以便后续某些场景需要继续使用
    this.dataModel.data = data;
    this.bindData(data);
  }

  initDesigning() {
    var that = this;
    this._jqObj.click(function () {
      that.showToolBar();
    });
    this._jqObj.children("tbody").children("tr").children("td").each(function () {
      tableDesigner.bindTableTdEvent(that.id, this);
    });
  }

  initRuntime() {
    let that = this;
    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if ((this.dataModel.dataQuerySetting 
      && (this.dataModel.dataQuerySetting.servicePath
      || this.dataModel.dataQuerySetting.serviceCpt)
    )) {
      this.loadData();
    } else if (this.dataModel.dynamicRowDataQuerySetting
      && this.dataModel.dynamicRowDataQuerySetting.servicePath && startIndex >= 0) {
      this.requestDynamicRowsData(function (dynamicRowData) {
        that.exeOnAterBindData([], dynamicRowData);
      });
    } else {
      this.bindCellEvent();
    }
  }
}