import TFPComponentRender from '../render.js'

export default class SwiperRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let val = "";
    html += indent;
    var selectednow = 0;
    if (this.dataModel.selectednow) {
      selectednow = this.dataModel.selectednow;
    }
    if (!this.dataModel.options) {
      this.dataModel.options = [
        {
          "srcJson": {
            "type": "iconfont",
            "class": "wxfpicon  wxfpicon-home-line",
            "color": "#888888",
            "bgColor": "",
            "filePath": "/node_modules/tfp/src/wxfpfont.css"
          },
          "srcJson2": {
            "type": "iconfont",
            "class": "wxfpicon  wxfpicon-home",
            "color": "#2AA144",
            "bgColor": "",
            "filePath": "/node_modules/tfp/src/wxfpfont.css"
          },
          "tabbarname": "首页",
          "tabbarsrc1": "wxfpicon  wxfpicon-home-line",
          "tabbarsrc2": "wxfpicon  wxfpicon-home",
          "tabjumpUrl": "/pages/home/home"
        }, {
          "srcJson": {
            "type": "iconfont",
            "class": "wxfpicon  wxfpicon-mine-line",
            "color": "#888888",
            "bgColor": "",
            "filePath": "/node_modules/tfp/src/wxfpfont.css"
          },
          "srcJson2": {
            "type": "iconfont",
            "class": "wxfpicon  wxfpicon-mine",
            "color": "#2AA144",
            "bgColor": "",
            "filePath": "/node_modules/tfp/src/wxfpfont.css"
          },
          "tabbarname": "我的",
          "tabbarsrc1": "wxfpicon  wxfpicon-mine-line",
          "tabbarsrc2": "wxfpicon  wxfpicon-mine",
          "tabjumpUrl": "/pages/mine/mine"
        }
      ];
    }
    html += indent;
    for (var i = 0; i < this.dataModel.options.length; i++) {
      let option = this.dataModel.options[i];
      if (selectednow == i) {
        html += `<div class="tabbar_item" style="width: 50%;display: flex;flex-direction: column;align-items: center;">`;
        if (option.srcJson2.type == 'iconfont') {
          html += `<div class="wxfpicon ` + option.tabbarsrc2 + `" style="font-size: 25px;`;
          if (option.srcJson2.color) {
            html += `color:` + option.srcJson2.color + ';';
          }
          if (option.srcJson2.bgColor) {
            html += `background-color:` + option.srcJson2.bgColor + ';';
          }
          html += `";></div>`;
        } else if (option.srcJson2.type == 'httpurl') {
          html += `<div class="wxfpicon ` + option.tabbarsrc2 + `"></div>`;
          html += `<img class="wx-image" src="` + option.srcJson2.url + `"
	style="height: 25px;"/>`;
        } else if (option.srcJson2.type == 'url') {
          html += `<img class="wx-image" src="` + this._tfp.getUrlRealPath(option.srcJson2.url) + `"
	style="height: 25px;"/>`;
        }
        html += `<div class="tabbar_name" style="color:` + this.dataModel.selectedColor + `;">` + option.tabbarname + `</div>\n`;
      } else {
        html += `<div class="tabbar_item" style="width: 50%;display: flex;flex-direction: column;align-items: center;">`;
        if (option.srcJson.type == 'iconfont') {
          html += `<div class="wxfpicon ` + option.tabbarsrc1 + `" style="font-size: 25px;`;
          if (option.srcJson.color) {
            html += `color:` + option.srcJson.color + ';';
          }
          if (option.srcJson.bgColor) {
            html += `background-color:` + option.srcJson.bgColor + ';';
          }
          html += `";></div>`;
        } else if (option.srcJson.type == 'httpurl') {
          html += `<div class="wxfpicon ` + option.tabbarsrc1 + `"></div>`;
          html += `<img class="wx-image" src="` + option.srcJson.url + `"
        style="height: 25px;"/>`;
        } else if (option.srcJson.type == 'url') {
          html += `<img class="wx-image" src="` + this._tfp.getUrlRealPath(option.srcJson.url) + `"
        style="height: 25px;"/>`;
        }
        html += `<div class="tabbar_name" style="color:` + this.dataModel.tabcolor + `;">` + option.tabbarname + `</div>\n`;
      }
      html += "</div>\r\n";
    }
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    if (!this.dataModel.options) return cpt_wx;

    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    for (var i = 0; i < this.dataModel.options.length; i++) {
      var option = this.dataModel.options[i];
      bodyHtml += this.cpt.getOptionWx(indent, option, i);
    }
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}