import { FormInput } from "../controller.js";

/**
 * 面板组件
 * @param {[type]} dataModel [description]
 */
export default class Tabbar extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Tabbar", dataModel, parent);
  }

  // 字体默认颜色
  get tabcolor() { return this.dataModel.tabcolor }
  set tabcolor(value) {
    this.dataModel.tabcolor = value;
    if (this._jqObj) {
      this._jqObj.empty();
      for (var i = 0; i < this.dataModel.options.length; i++) {
        this.addOption(this.dataModel.options[i], true, i, this.dataModel.selectednow);
      }
    }
  }

  // 字体选中颜色
  get selectedColor() { return this.dataModel.selectedColor }
  set selectedColor(value) {
    this.dataModel.selectedColor = value;
    if (this._jqObj) {
      this._jqObj.empty();
      for (var i = 0; i < this.dataModel.options.length; i++) {
        this.addOption(this.dataModel.options[i], true, i);
      }
    }
  }

  // 当前选中
  get selectednow() { return this.dataModel.selectednow }
  set selectednow(value) {
    this.dataModel.selectednow = value;
    if (this._jqObj) {
      this._jqObj.empty();
      for (var i = 0; i < this.dataModel.options.length; i++) {
        this.addOption(this.dataModel.options[i], true, i);
      }
    }
  }

  get options() {
    return this.dataModel.options;
  }
  set options(value) {
    if (!value) return;
    this.dataModel.options = value;
    this.setOptions(value);
    if (this._jqObj) {
      this._jqObj.empty();
      var selectednow = 0;
      if (this.dataModel.selectednow) {
        selectednow = this.dataModel.selectednow;
      }
      for (var i = 0; i < value.length; i++) {
        this.addOption(value[i], true, i);
      }
    }
  }

  getOptionHtml(indent, option, index) {
    let optionHtml = "";
    optionHtml += indent;
    if (index == this.dataModel.selectednow) {
      optionHtml += `<div class="tabbar_item" style="width: 50%;display: flex;flex-direction: column;align-items: center;">`;
      if (option.srcJson2.type == 'iconfont') {
        optionHtml += `<div class="wxfpicon ` + option.tabbarsrc2 + `" style="font-size: 25px;`;
        if (option.srcJson2.color) {
          optionHtml += `color:` + option.srcJson2.color + ';';
        }
        if (option.srcJson2.bgColor) {
          optionHtml += `background-color:` + option.srcJson2.bgColor + ';';
        }
        optionHtml += `";></div>`;
      } else if (option.srcJson2.type == 'httpurl') {
        optionHtml += `<div class="wxfpicon ` + option.tabbarsrc2 + `"></div>`;
        optionHtml += `<img class="wx-image" src="` + option.srcJson2.url + `"
        style="height: 25px;"/>`;
      } else if (option.srcJson2.type == 'url') {
        optionHtml += `<img class="wx-image" src="` + this._tfp.getUrlRealPath(option.srcJson2.url) + `"
        style="height: 25px;"/>`;
      }
      optionHtml += `<div class="tabbar_name" style="color:` + this.dataModel.selectedColor + `;">` + option.tabbarname + `</div>\n`;
    } else {
      optionHtml += `<div class="tabbar_item" style="width: 50%;display: flex;flex-direction: column;align-items: center;">`;
      if (option.srcJson.type == 'iconfont') {
        optionHtml += `<div class="wxfpicon ` + option.tabbarsrc1 + `" style="font-size: 25px;`;
        if (option.srcJson.color) {
          optionHtml += `color:` + option.srcJson.color + ';';
        }
        if (option.srcJson.bgColor) {
          optionHtml += `background-color:` + option.srcJson.bgColor + ';';
        }
        optionHtml += `";></div>`;
      } else if (option.srcJson.type == 'httpurl') {
        optionHtml += `<div class="wxfpicon ` + option.tabbarsrc1 + `"></div>`;
        optionHtml += `<img class="wx-image" src="` + option.srcJson.url + `"
        style="height: 25px;"/>`;
      } else if (option.srcJson.type == 'url') {
        optionHtml += `<img class="wx-image" src="` + this._tfp.getUrlRealPath(option.srcJson.url) + `"
        style="height: 25px;"/>`;
      }
      optionHtml += `<div class="tabbar_name" style="color:` + this.dataModel.tabcolor + `;">` + option.tabbarname + `</div>\n`;
    }
    optionHtml += "</div>\r\n";
    return optionHtml;
  }

  getOptionWx(indent, option, index) {
    let optionHtml = "";
    optionHtml += indent;
    if (index == this.dataModel.selectednow) {
      optionHtml += `\t<view class="tabbar_item" style="width: 50%;display: flex;flex-direction: column;align-items: center;" bindtap="bindclick_toNewPage" data-url="` + option.tabjumpUrl + `" data-type="redirectTo">\n`;
      if (option.srcJson2.type == 'iconfont') {
        optionHtml += `\t\t\t<view class="wxfpicon ` + option.tabbarsrc2 + `" style="font-size: 25px;`;
        if (option.srcJson2.color) {
          optionHtml += `color:` + option.srcJson2.color + ';';
        }
        if (option.srcJson2.bgColor) {
          optionHtml += `background-color:` + option.srcJson2.bgColor + ';';
        }
        optionHtml += `"></view>`;
      } else if (option.srcJson2.type == 'httpurl') {
        optionHtml += `\t\t\t<image class="wx-image" src="` + option.srcJson2.url + `"
        style="height:25px;width: 25px;"/>`;
      } else if (option.srcJson2.type == 'url') {
        optionHtml += `\t\t\t<image class="wx-image" wx-if="{{apiUrl}}" src="{{apiUrl}}` + this._tfp.getUrlRealPath(option.srcJson2.url) + `"
        style="height:25px;width: 25px;"/>`;
      }
      optionHtml += `<view class="tabbar_name" style="color:` + this.dataModel.selectedColor + `;">` + option.tabbarname + `</view>\n`;
    } else {
      optionHtml += `\t<view class="tabbar_item" style="width: 50%;display: flex;flex-direction: column;align-items: center;" bindtap="bindclick_toNewPage" data-url="` + option.tabjumpUrl + `" data-type="redirectTo">\n`;
      if (option.srcJson.type == 'iconfont') {
        optionHtml += `<view class="wxfpicon ` + option.tabbarsrc1 + `" style="font-size: 25px;`;
        if (option.srcJson.color) {
          optionHtml += `color:` + option.srcJson.color + ';';
        }
        if (option.srcJson.bgColor) {
          optionHtml += `background-color:` + option.srcJson.bgColor + ';';
        }
        optionHtml += `"></view>`;
      } else if (option.srcJson.type == 'httpurl') {
        optionHtml += `\t\t\t<image class="wx-image" src="` + option.srcJson.url + `"
        style="height:25px;width: 25px;"/>`;
      } else if (option.srcJson.type == 'url') {
        optionHtml += `\t\t\t<image class="wx-image" wx-if="{{apiUrl}}" src="{{apiUrl}}` + this._tfp.getUrlRealPath(option.srcJson.url) + `"
        style="height:25px;width: 25px;"/>`;
      }
      optionHtml += `<view class="tabbar_name" style="color:` + this.dataModel.tabcolor + `;">` + option.tabbarname + `</view>\n`;
    }
    optionHtml += "\t\t</view>\r\n";
    return optionHtml;
  }

  addOption(option, isInit, index) {
    let indent = this.getHtmlIndent();
    let str = "";
    str += this.getOptionHtml(indent, option, index);
    if (str != "") {
      this._jqObj.append(str);
      if (!isInit) this.dataModel.options.push(option);
    }
  }
}