import TFPComponentRender from '../render.js'

export default class TabRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml = function (getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    let title_selected = " tfp-tab-title-selected";
    if (this.dataModel.position == "bottom") title_selected = " tfp-tab-title-selected-bottom";
    if (this.dataModel.position == "left") title_selected = " tfp-tab-title-selected-right";
    if (this.dataModel.position == "right") title_selected = " tfp-tab-title-selected-left";
    let top = parseInt(this.dataModel.titleHeight) + 1;
    let left = parseInt(this.dataModel.titleWidth) + 1;
    if (this.dataModel.hideTabHeader) top = 0;
    let headBorderColor = "#ccc";
    if(this._tfp.curPage.bgColorMode=="dark") headBorderColor = "#666";
    let headStyle = " style=\"flex-direction:row;width:100%;height: " + top + "px;bottom:auto;top:0px;border-bottom:1px solid "+headBorderColor+";border-right:none;border-left:none;\"";
    let titleStyle = "style=\"flex-basis: " + this.dataModel.titleWidth + "px;height:" + this.dataModel.titleHeight + "px;display: flex;justify-content: center;align-items: center;padding:0;\"";
    let pagesStyle = "style=\"top:" + top + "px;right:0px;bottom:0px;left:0px;\"";
    if (this.dataModel.position == "bottom") {
      headStyle = " style=\"flex-direction:row;width:100%;height: " + top + "px;bottom:0px;top:auto;border-top:1px solid "+headBorderColor+";border-bottom:none;border-right:none;border-left:none;\"";
      titleStyle = "style=\"flex-basis: " + this.dataModel.titleWidth + "px;height:" + this.dataModel.titleHeight + "px;display: flex;justify-content: center;align-items: center;padding:0;\"";
      pagesStyle = "style=\"top:0px;right:0px;bottom:" + top + "px;left:0px;\"";
    } else if (this.dataModel.position == "left") {
      headStyle = " style=\"flex-direction:column;width:" + left + "px;height:100%;right:auto;left:0px;border-bottom:none;border-left:none;border-right:1px solid "+headBorderColor+";\"";
      titleStyle = "style=\"flex-basis: " + this.dataModel.titleHeight + "px;width: " + this.dataModel.titleWidth + "px;height: " + this.dataModel.titleHeight + "px;display: flex;justify-content: flex-end;align-items: center;padding-right:10px;\"";
      pagesStyle = "style=\"top:0px;right:0px;bottom:0px;left:" + left + "px;\"";
    } else if (this.dataModel.position == "right") {
      headStyle = " style=\"flex-direction:column;width:" + left + "px;height:100%;left:auto;right:0px;border-bottom:none;border-left:none;border-left:1px solid "+headBorderColor+";\"";
      titleStyle = "style=\"flex-basis: " + this.dataModel.titleHeight + "px;width: " + this.dataModel.titleWidth + "px;height: " + this.dataModel.titleHeight + "px;display: flex;justify-content: flex-start;align-items: center;padding-left:10px;\"";
      pagesStyle = "style=\"top:0px;right:" + left + "px;;bottom:0px;left:0px;\"";
    }

    bodyHtml += indent + "\t<div class=\"tfp-tab-head\" " + headStyle + ">\r\n";
    if (this.dataModel.components) {
      for (var i = 0; i < this.dataModel.components.length; i++) {
        let tabPageDM = this.dataModel.components[i];
        bodyHtml += indent + "\t\t<div class=\"tfp-tab-title";
        if (i == this.dataModel.pageIndex) {
          bodyHtml += title_selected;
        } else {
          if (!tabPageDM.styles) tabPageDM.styles = {};
          tabPageDM.styles["display"] = "none";
        }
        let dot = '';
        if (tabPageDM.icon) {
          let iconSize = 20;
          if (tabPageDM.iconSize) iconSize = tabPageDM.iconSize;
          iconSize = this._tfp.getPx(iconSize);
          let iconRadius = 4;
          if (tabPageDM.iconRadius || (tabPageDM.iconRadius + "") == "0") iconRadius = tabPageDM.iconRadius;
          iconRadius = this._tfp.getPx(iconRadius);
          if (tabPageDM.icon.type == "url") {
            dot = "<img src=\"" + tabPageDM.icon.url + "\" style=\"width:" + iconSize + "px; height:" + iconSize
              + "px; margin-right:5px;border-radius: " + iconRadius + "px;\">";
          } else {
            dot = "<span class=\"" + tabPageDM.icon.class + "\" style=\" margin-right:5px;border-radius: " + iconRadius + "px; "
              + "font-size:" + iconSize + "px;height:" + iconSize + "px;line-height:" + iconSize + "px;"
              + "background-color:" + tabPageDM.icon.bgColor + ";color:" + tabPageDM.icon.color + ";\"></span>";
          }
        }
        bodyHtml += "\" " + titleStyle + ">" + dot + "" + tabPageDM.title + "</div>\r\n";
      }
    }
    bodyHtml += indent + "\t</div>\r\n";
    bodyHtml += indent + "\t<div class=\"tfp-tab-pages\" " + pagesStyle + ">\r\n";
    if (this.dataModel.components && getComponentsHtml) {
      bodyHtml += this.getComponentsHtml(getComponentsHtml, indent);
    }
    bodyHtml += indent + "\t</div>\r\n";
    return bodyHtml + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}