export default {
  "name": "Tab",
  "comment": "选项卡",
  "cssFiles": [
    "style.{bgColorMode}.css",
    {
      "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont.css",
      "onlyRuntime": true
    },
    {
      "src": "/node_modules/tfp/src/components/button/iconfont/iconfont.css",
      "onlyRuntime": true
    },
    {
      "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont_tb.css",
      "onlyDesigning": true
    },
    {
      "src": "/node_modules/tfp/src/components/button/iconfont/iconfont_tb.css",
      "onlyDesigning": true
    }
  ],
  "attrs": [
    {
      "name": "pages",
      "comment": "选项页集合",
      "type": "Dataset",
      "special": true,
      "columns": [
        {
          "id": "id",
          "name": "ID",
          "type": "String",
          "width": "100px",
          "readonly": true
        },
        {
          "id": "title",
          "name": "标题",
          "type": "String",
          "width": "200px",
          "required": true
        },
        {
          "id": "icon",
          "name": "小图标",
          "type": "Icon",
          "width": "50px"
        },
        {
          "id": "iconSize",
          "name": "小图标大小",
          "type": "Int",
          "default": 20,
          "width": "80px"
        },
        {
          "id": "iconRadius",
          "name": "小图标圆角",
          "type": "Int",
          "default": 4,
          "width": "80px"
        }
      ]
    },
    {
      "name": "pageIndex",
      "comment": "当前选项页索引",
      "type": "Int",
      "special": true,
      "default": 0
    },
    {
      "name": "titleWidth",
      "comment": "选项页标题宽度",
      "type": "Int",
      "required": true,
      "default": 150
    },
    {
      "name": "titleHeight",
      "comment": "选项页标题高度",
      "type": "Int",
      "required": true,
      "default": 40
    },
    {
      "name": "hideTabHeader",
      "comment": "隐藏选项页标题",
      "type": "Switch"
    },
    {
      "name": "position",
      "comment": "选项页标题位置",
      "type": "Select",
      "default": "top",
      "options": [
        {
          "value": "top",
          "text": "顶部"
        },
        {
          "value": "right",
          "text": "右侧"
        },
        {
          "value": "bottom",
          "text": "底部"
        },
        {
          "value": "left",
          "text": "左侧"
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "position": "absolute",
    "left": 0,
    "top": 0,
    "right": 0,
    "bottom": 0
  },
  "methods": [
    {
      "name": "showTabPage",
      "comment": "显示指定索引的选项页",
      "args": [
        {
          "name": "index",
          "comment": "索引",
          "type": "Int",
          "required": true
        }
      ]
    }, {
      "name": "setBadgeNumber",
      "comment": "设置指定选项页的标题角标",
      "args": [
        {
          "name": "index",
          "comment": "索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "number",
          "comment": "数量",
          "type": "Int",
          "required": true
        }
      ]
    }
  ],
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onMouseOver",
      "comment": "鼠标经过时"
    }, {
      "name": "onMouseOut",
      "comment": "鼠标移出时"
    }, {
      "name": "onAddTabPage",
      "comment": "添加选项页时",
      "isNotHtmlEvent": true
    }, {
      "name": "onDelTabPage",
      "comment": "删除选项页时",
      "isNotHtmlEvent": true
    }, {
      "name": "onTabIndexChange",
      "comment": "选中页变化时",
      "isNotHtmlEvent": true
    }]
}