import { ContainerComponent } from "../controller.js";

/**
 * 选项卡组件
 * @param {[type]} dataModel [description]
 */
export default class Tab extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Tab", dataModel, parent);

    if (!this.dataModel.components || this.dataModel.components.length == 0) {
      this.dataModel.components = [{
        id: this.id + "_page1",
        type: "TabPage",
        isAttached: true,
        title: "page1",
        iconSize: 20,
        iconRadius: 4
      }, {
        id: this.id + "_page2",
        type: "TabPage",
        title: "page2",
        iconSize: 20,
        iconRadius: 4,
        isAttached: true,
        styles: {
          display: "none"
        }
      }];
    }
  }

  get pages() {
    var pages = [];
    for (var i = 0; i < this.dataModel.components.length; i++) {
      let tabPageDM = this.dataModel.components[i];
      pages.push({ id: tabPageDM.id, type: "TabPage", title: tabPageDM.title, icon: tabPageDM.icon, iconSize: tabPageDM.iconSize, iconRadius: tabPageDM.iconRadius });
    }
    return pages;
  }
  set pages(value) {
    let pages = [];
    if (value) pages = value;
    let tabPages = [];
    if (this.dataModel.pageIndex >= pages.length) this.dataModel.pageIndex = pages.length - 1;
    if (this.dataModel.pageIndex < 0) this.dataModel.pageIndex = 0;
    for (var i = 0; i < pages.length; i++) {
      let page = pages[i];
      let cdm = null;
      if (page.id) {
        let tabPage = this._tfp.components[page.id];
        cdm = tabPage.dataModel;
        cdm.title = page.title;
        cdm.icon = page.icon;
        cdm.iconSize = page.iconSize;
        cdm.iconRadius = page.iconRadius;
        if (cdm.styles && cdm.styles.display) delete cdm.styles["display"];
        delete this._tfp.components[tabPage.id];
      } else {
        cdm = {
          type: "TabPage",
          isAttached: true,
          title: page.title,
          icon: page.icon,
          iconSize: page.iconSize,
          iconRadius: page.iconRadius
        };
      }
      if (i != this.dataModel.pageIndex) {
        if (cdm.styles) {
          cdm.styles.display = "none";
        } else {
          cdm.styles = { display: "none" };
        }
      }
      tabPages.push(cdm);
    }
    this.dataModel.components = tabPages;
    this._jqObj.remove();
    this.render();
    if (this.dataModel.components.length > 0) this.showTabPage(0);
  }

  get pageIndex() { return this.dataModel.pageIndex }
  set pageIndex(value) {
    this.dataModel.pageIndex = value;
    if (this._jqObj) this.showTabPage(value);
  }

  get titleWidth() { return this.dataModel.titleWidth }
  set titleWidth(value) {
    this.dataModel.titleWidth = this._tfp.getPx(value);
    if (this._jqObj) {
      // this.setTabStyle();
      this._jqObj.remove();
      this.render();
      if (this.dataModel.components.length > 0) this.showTabPage(0);
    }
  }

  get titleHeight() { return this.dataModel.titleHeight }
  set titleHeight(value) {
    this.dataModel.titleHeight = this._tfp.getPx(value);
    if (this._jqObj) {
      // this.setTabStyle();
      this._jqObj.remove();
      this.render();
      if (this.dataModel.components.length > 0) this.showTabPage(0);
    }
  }

  get hideTabHeader() { return this.dataModel.hideTabHeader ? true : false }
  set hideTabHeader(value) {
    this.dataModel.hideTabHeader = value ? true : false;
    if (this.dataModel.hideTabHeader) {
      this._jqObj.children(".tfp-tab-head").hide();
      this._jqObj.children(".tfp-tab-pages").css({ "top": "0", "right": "0", "bottom": "0", "left": "0" });
    } else {
      this._jqObj.children(".tfp-tab-head").show();
      // this.setTabStyle();
      this._jqObj.remove();
      this.render();
      if (this.dataModel.components.length > 0) this.showTabPage(0);
    }
  }

  get position() { return this.dataModel.position }
  set position(value) {
    this.dataModel.position = value;
    // this.setTabStyle();
    this._jqObj.remove();
    this.render();
    if (this.dataModel.components.length > 0) this.showTabPage(0);
  }

  get containerEl() {
    return this._jqObj.children(".tfp-tab-pages").get(0);
  }

  get hasAttachedChilds() {
    return true
  }

  // setTabStyle() {
  //   let top = parseInt(this.dataModel.titleHeight) + 1;
  //   let left = parseInt(this.dataModel.titleWidth) + 1;
  //   if (this.dataModel.position == "bottom") {
  //     this._jqObj.children(".tfp-tab-head").css({ "flex-direction": "row", "width": "100%", "height": top + "px", "top": "auto", "bottom": "0px", "border-top": "1px solid #ccc", "border-bottom": "none", "border-right": "none", "border-left": "none" });
  //     this._jqObj.children(".tfp-tab-head").children().css({ "flex-basis": this.dataModel.titleWidth, "height": this.dataModel.titleHeight, "line-height": this.dataModel.titleHeight + "px", "text-align": "center", "padding": "0" });
  //     this._jqObj.children(".tfp-tab-pages").css({ "top": "0px", "right": "0px", "bottom": top + "px", "left": "0px" });
  //   } else if (this.dataModel.position == "left") {
  //     this._jqObj.children(".tfp-tab-head").css({ "flex-direction": "column", "width": left + "px", "height": "100%", "right": "auto", "left": "0px", "border-bottom": "none", "border-left": "none", "border-right": "1px solid #ccc" });
  //     this._jqObj.children(".tfp-tab-head").children().css({ "flex-basis": this.dataModel.titleHeight, "width": this.dataModel.titleWidth, "height": this.dataModel.titleHeight, "line-height": this.dataModel.titleHeight + "px", "text-align": "right", "padding-right": "10px" });
  //     this._jqObj.children(".tfp-tab-pages").css({ "top": "0px", "right": "0px", "bottom": "0px", "left": left + "px" });
  //   } else if (this.dataModel.position == "right") {
  //     this._jqObj.children(".tfp-tab-head").css({ "flex-direction": "column", "width": left + "px", "height": "100%", "left": "auto", "right": "0px", "border-bottom": "none", "border-right": "none", "border-left": "1px solid #ccc" });
  //     this._jqObj.children(".tfp-tab-head").children().css({ "flex-basis": this.dataModel.titleHeight, "width": this.dataModel.titleWidth, "height": this.dataModel.titleHeight, "line-height": this.dataModel.titleHeight + "px", "text-align": "left", "padding-left": "10px" });
  //     this._jqObj.children(".tfp-tab-pages").css({ "top": "0px", "right": left + "px", "bottom": "0px", "left": "0px" });
  //   } else {
  //     this._jqObj.children(".tfp-tab-head").css({ "flex-direction": "row", "width": "100%", "height": top + "px", "bottom": "auto", "top": "0px", "border-bottom": "1px solid #ccc", "border-right": "none", "border-left": "none" });
  //     this._jqObj.children(".tfp-tab-head").children().css({ "flex-basis": this.dataModel.titleWidth, "height": this.dataModel.titleHeight, "line-height": this.dataModel.titleHeight + "px", "text-align": "center", "padding": "0" });
  //     this._jqObj.children(".tfp-tab-pages").css({ "top": top + "px", "right": "0px", "bottom": "0px", "left": "0px" });
  //   }
  //   if (this._jqObj) this.showTabPage(this.dataModel.pageIndex);
  // }

  showTabPage(index) {
    let title_selected = "tfp-tab-title-selected";
    if (this.dataModel.position == "bottom") title_selected = "tfp-tab-title-selected-bottom";
    if (this.dataModel.position == "left") title_selected = "tfp-tab-title-selected-right";
    if (this.dataModel.position == "right") title_selected = "tfp-tab-title-selected-left";
    let _titleHeight = this._tfp.getPx(this.dataModel.titleHeight);
    this._jqObj.children(".tfp-tab-pages").children(".tfp-tabpage").hide();
    this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").removeClass("tfp-tab-title-selected tfp-tab-title-selected-bottom tfp-tab-title-selected-right tfp-tab-title-selected-left");
    this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").css("height", _titleHeight + "px");
    this._jqObj.children(".tfp-tab-pages").children(".tfp-tabpage").eq(index).show();
    this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").eq(index).addClass(title_selected);
    //this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").eq(index).css("height", (_titleHeight-1)+"px");
    if (!this._tfp.isDesigning) {
      this.dataModel.pageIndex = index;
      for (var i = 0; i < this.dataModel.components.length; i++) {
        let tabPageDM = this.dataModel.components[i];
        if (i == index) {
          if (tabPageDM.styles) delete tabPageDM.styles["display"];
        } else {
          if (!tabPageDM.styles) tabPageDM.styles = {};
          tabPageDM.styles["display"] = "none";
        }
      }
    }
    if (this.dataModel.onTabIndexChange && !this._tfp.isDesigning)
      eval(this.dataModel.onTabIndexChange);
  }

  setBadgeNumber(index, number) {
    let num = number;
    if (number > 99) num = '99+';
    let rightStyle = 'right: 1.25rem;transform: translate(100%);';
    if (this.dataModel.position == 'right') rightStyle = 'right: 0rem;';
    if (this.dataModel.position == 'left') rightStyle = 'left: 0rem;';
    let badgeHtml = `<sup style="position: absolute;top: 0;` + rightStyle + `background: red;display: inline-flex;align-items: center;justify-content: center;line-height: 18px;border-radius: 10px;height: 18px;padding: 0 6px;color: white;font-size: 12px;">` + num + `</sup>`;
    this._jqObj.find(".tfp-tab-title").eq(index).css("position", "relative");
    this._jqObj.find(".tfp-tab-title").eq(index).append(badgeHtml);
  }

  initRuntime() {
    var that = this;
    this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").each(function (index) {
      $(this).click(function () {
        that.showTabPage(index);
      });
    });
    if (this.pageIndex != 0) {
      this.showTabPage(this.pageIndex);
    } else {
      let _titleHeight = this._tfp.getPx(this.dataModel.titleHeight);
      //this._jqObj.children(".tfp-tab-head").children(".tfp-tab-title").eq(0).css("height", (_titleHeight-1)+"px");
    }
  }

  initDesigning() {
    if (this._tfp.isDesigning) this.initRuntime();
  }
}