import TFPComponentRender from '../render.js'

export default class SwitchRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr, otherOptions) {
    var vid = escape(this.dataModel.id).replaceAll("%", "");
    var attrHtml = super.getAttrHtml(retainStyleAttr);
    if (!this.dataModel.options || this.dataModel.options.length != 2)
      this.dataModel.options = [false, true];
    if (!this._tfp.isDesigning) {
      if (otherOptions && otherOptions.gridContainer) {
        attrHtml += " name=\"" + this.dataModel.id + "_{{index}}\"";
        attrHtml += " checked=\"{{item." + vid + "}}\"";
      }
      else {
        attrHtml += " name=\"" + this.dataModel.id + "\"";
        attrHtml += " checked=\"{{" + vid + "}}\"";
      }

      attrHtml += " bindchange=\"bindchange_controller\"";
    }
    else {
      if ((this.dataModel.value + "") == (this.dataModel.options[1] + ""))
        attrHtml += " checked";
      attrHtml += " style=\"background-color:" + this.dataModel.controlColor + "\"";
    }
    return attrHtml;
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "";
    let indent = this.getHtmlIndent();

    bodyHtml += "<div";
    bodyHtml += " class=\"wx-switch-wrapper\"";
    bodyHtml += ">";
    bodyHtml += "<div";
    bodyHtml += " class=\"wx-switch-input\"";
    bodyHtml += ">";
    bodyHtml += "</div>";
    bodyHtml += "</div>";
    return bodyHtml;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("switch", getComponentsHtml, parentIndent, retainStyleAttr, otherOptions);
  }
}